<?php

// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: AiAPIController.php,v 1.3.6.3.2.1 2026/02/03 13:35:09 qvarin Exp $

namespace Pmb\AI\Controller;

use Pmb\AI\Library\ParseMarkdown;
use Pmb\AI\Library\Source\Semantic;
use Pmb\AI\Orm\AISettingsOrm;
use Pmb\Common\Controller\Controller;
use Pmb\Common\Helper\UrlEntities;

if (stristr($_SERVER['REQUEST_URI'], basename(__FILE__))) {
    die("no access");
}

class AiAPIController extends Controller
{
    public $action = "list";

    public function proceed($action = "")
    {
        $this->action = $action;

        switch ($action) {
            case 'semantic_chat_catalog':
                $this->semanticChatCatalogAction();
                break;
            default:
                $this->ajaxError('No action', 404);
                break;
        }
    }

    public function semanticChatCatalogAction()
    {
        try {
            $aiSettings = AISettingsOrm::fetchActiveAiSettings();
            if (empty($aiSettings)) {
                throw new \Exception('No active AI settings');
            }
        } catch (\Exception $e) {
            $this->ajaxError($e->getMessage(), 403);
        }

        $_SESSION["ai_search_semantic_index"] = array_filter($_SESSION["ai_search_semantic_index"], function ($semantic_search) {
            return $semantic_search['time'] >= strtotime('-1 day');
        });

        $semantic = new Semantic($aiSettings);
        $sessionInfos = $_SESSION["ai_search_semantic_index"][$this->data->session_index] ?? [];
        if (empty($sessionInfos) || !is_array($sessionInfos)) {
            $this->ajaxError('No index list', 404);
        }

        if (isset($sessionInfos["response"])) {
            $this->ajaxJsonResponse([
                'response' => $sessionInfos["response"]
            ]);
        }

        $content = $semantic->textGeneration($sessionInfos['semantic_query'], $sessionInfos['index_list']);
        if (empty($content)) {
            $this->ajaxError('API error (empty content)', 404);
        }

        $parseMarkdown = new ParseMarkdown();
        $content = $parseMarkdown->parseText($content, $sessionInfos['index_list']);

        $_SESSION["ai_search_semantic_index"][$this->data->session_index]["response"] = $content;
        $this->ajaxJsonResponse(['response' => $content]);
    }
}
