<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: selector_searcher_bulletin.class.php,v 1.1.4.4 2025/11/28 15:59:14 dbellamy Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

//Classe de recherche pour selecteurs
global $class_path;
require_once("$class_path/sel_searcher.class.php");

class selector_searcher_bulletin extends sel_searcher {

    public $cur_typ_query='bulletin';

    public function make_first_search() {
        global $msg;
        global $elt_query;
        global $results_show_all;

        $restrict = "niveau_biblio='s' ";
        $restrict.= "and bulletin_notice=notice_id ";

        $suite_rqt="or code='".$elt_query."' ";

        $issn_verif=traite_code_ISSN(stripslashes($elt_query));
        if (isISSN(stripslashes($elt_query))) {
            $suite_rqt.=" or code='".$issn_verif."' ";
            $q_count = "select count(distinct notice_id) from notices, bulletins where ".$restrict." and (0 ".$suite_rqt.")";
            $r_count = pmb_mysql_query($q_count);
            $n_count = pmb_mysql_result($r_count,0,0);
            $this->nbresults = $n_count;

            $q_list = "select distinct(notice_id) from notices, bulletins where ".$restrict." and (0 ".$suite_rqt.")";
            if(!$results_show_all){
                $q_list .= $this->get_query_limit();
            }
            $r_list = pmb_mysql_query($q_list);
            $this->t_query=$r_list;
            if(!$results_show_all){
                $this->nbepage=ceil($this->nbresults/$this->get_nb_per_page());
            }else{
                $this->nbepage=1;
            }
        }else{
            $aq=new analyse_query(stripslashes($elt_query));
            if ($aq->error) {
                $this->show_form();
                error_message($msg["searcher_syntax_error"],sprintf($msg["searcher_syntax_error_desc"],$aq->current_car,$aq->input_html,$aq->error_message));
                return ;
            } else {
                $q_members = $aq->get_query_members("notices","index_wew","index_sew","notice_id");
                $q_count = "select count(distinct notice_id) from notices, bulletins where ".$restrict." and (".$q_members["where"]." ".$suite_rqt.")";
                $r_count = pmb_mysql_query($q_count);
                $n_count = pmb_mysql_result($r_count,0,0);
                $this->nbresults = $n_count;

                $q_list = "select distinct(notice_id), ".$q_members['select']." as pert from notices, bulletins where ".$restrict." and (".$q_members["where"]." ".$suite_rqt.") ".$q_members['post'];
                if(!$results_show_all){
                    $q_list.= $this->get_query_limit();
                }
                $r_list = pmb_mysql_query($q_list);
                $this->t_query=$r_list;
                if(!$results_show_all){
                    $this->nbepage=ceil($this->nbresults/$this->get_nb_per_page());
                }else{
                    $this->nbepage=1;
                }
            }
        }
        return AUT_LIST;
    }

    public function make_aut_search() {
        global $results_show_all;

        switch ($this->aut_type) {
            case 'perio':
                $q_count="select count(*) from bulletins where bulletin_notice='".$this->aut_id."' ";
                $q_list="select bulletin_id from bulletins where bulletin_notice='".$this->aut_id."' order by date_date desc, bulletin_numero desc";
                if(!$results_show_all){
                    $q_list.= $this->get_query_limit();
                }
                break;
        }
        $r_count = pmb_mysql_query($q_count);
        $n_count = pmb_mysql_result($r_count,0,0);
        $this->nbresults=$n_count;

        $r_list = pmb_mysql_query($q_list);
        $this->t_query=$r_list;
        if(!$results_show_all){
            $this->nbepage=ceil($this->nbresults/$this->get_nb_per_page());
        }else{
            $this->nbepage=1;
        }
    }

    public function aut_list() {

        global $msg, $charset;
        global $elt_query;

        $research = '<b>'.htmlentities($msg['771'],ENT_QUOTES,$charset).'</b>&nbsp;'.htmlentities(stripslashes($elt_query),ENT_QUOTES,$charset);

        $this->show_form();
        if ($this->nbresults) {
            $research .= " => ".sprintf($msg["searcher_results"],$this->nbresults);
            $research .= $this->get_button_show_all();
            $this->aut_b_list = str_replace('!!research!!', $research, $this->aut_b_list);
            print $this->aut_b_list;
            $list = '';
            // on lance la requete
            while(($nz=pmb_mysql_fetch_object($this->t_query))) {
                // notice de perio
                $perio = new selector_display_record_serial($nz->notice_id, $this->base_url);
                $perio->action="<a href='".$this->base_url."&typ_query=".$this->cur_typ_query."&etat=aut_search&aut_type=perio&aut_id=!!aut_id!!' >!!display!!</a>";
                $perio->doForm();
                $list.= $this->aut_r_list;
                if (count($this->aut_r_list_values)) {
                    foreach($this->aut_r_list_values as $v) {
                        $list=str_replace("!!$v!!", $perio->$v, $list);
                    }
                }
            }
            print $list;
            print $this->back_script_show_all;
            // fin de liste
            print $this->aut_e_list;
        } else {
            error_message_history($msg[357], $msg[1915], 1);
        }
    }

    public function get_title_elt_list() {
        global $msg;

        return $msg['selector_lib_bull'];
    }

    public function get_instance_sel_display($row) {
        return new selector_display_bulletin($row->bulletin_id, $this->base_url,'sel_searcher_select_');
    }

    public function aut_elt_list() {
        $this->elt_list();
    }

    public function get_title_column_number() {
        global $msg;

        return $msg['acquisition_nb_expl'];
    }
}