<?php
// +-------------------------------------------------+
//  2002-2010 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: XMLClass.class.php,v 1.6.10.2 2025/12/16 11:07:55 qvarin Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) {
    die("no access");
}

class XMLClass
{

    public $defaultMimetypeFile;

    //xml dcrivant les classes  utilis par dfaut
    public $defaultMimetype;

    //tab rsultant du xml par defaut
    public $mimetypeFiles = array();

    //tableau associatif des manisfest par classes d'affichage
    public $classMimetypes = array();

    public $file;

    public $analyseur;

    //tableau associatif rsultant des diffrents manifest, dcrivant les mimetypes supports par chaque classe
    public function __construct($file = "")
    {
        $this->file = $file;
    }

    //Mthodes
    public function defaultMimetypeParse($parser, $nom, $attributs)
    {
        global $_starttag;
        $_starttag = true;
        if ($nom == 'MIMETYPE' && $attributs['TYPE'] && $attributs['CLASS']) {
            $this->defaultMimetype[$attributs['TYPE']] = $attributs['CLASS'];
        }
        if ($nom == 'MIMETYPES') {
            $this->defaultMimetype = array();
        }
    }

    //on fait tout dans la mthode dbutBalise....
    public function finBalise($parser, $nom)
    {
    }

    public function texte($parser, $data)
    {
    }

    public function analyser($file = "")
    {
        global $charset;

        if ($file != "") {
            $xmlToParse = $file;
        } else {
            $xmlToParse = $this->file;
        }

        if (!($fp = @fopen($xmlToParse, "r"))) {
            die(htmlentities("impossible d'ouvrir le fichier $xmlToParse", ENT_QUOTES, $charset));
        }
        $data = fread($fp, filesize($xmlToParse));

        $rx = "/<?xml.*encoding=[\'\"](.*?)[\'\"].*?>/m";
        if (preg_match($rx, $data, $m)) {
            $encoding = strtoupper($m[1]);
        } else {
            $encoding = "ISO-8859-1";
        }

        $this->analyseur = xml_parser_create($encoding);
        xml_parser_set_option($this->analyseur, XML_OPTION_TARGET_ENCODING, $charset);
        xml_parser_set_option($this->analyseur, XML_OPTION_CASE_FOLDING, true);
        xml_set_element_handler($this->analyseur, [$this, "debutBalise"], [$this, "finBalise"]);
        xml_set_character_data_handler($this->analyseur, [$this, "texte"]);

        fclose($fp);

        if (!xml_parse($this->analyseur, $data, true)) {
            die(sprintf("erreur XML %s  la ligne: %d ( $xmlToParse )\n\n",
                xml_error_string(xml_get_error_code($this->analyseur)),
                xml_get_current_line_number($this->analyseur)));
        }

        $this->analyseur = null;
    }
}
