<?php

// +-------------------------------------------------+
//  2002-2012 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: cms_module_animationslist_view_calendar_rgaa_django.class.php,v 1.1.4.2 2025/07/03 14:21:11 jparis Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) {
    die("no access");
}

use Pmb\Animations\Models\AnimationModel;

class cms_module_animationslist_view_calendar_rgaa_django extends cms_module_common_view_django
{
    public const COLOR_STATUT = "statut";

    public const COLOR_CALENDAR = "calendar";

    public function __construct($id = 0)
    {
        $this->use_dojo = true;
        parent::__construct($id);
        $this->default_template = "
<div>
  <div id='calendar_{{ id }}'></div>
  <script>
    document.addEventListener('DOMContentLoaded', function() {
        const calendar = new Calendar('calendar_{{ id }}', 'events');
		calendar.setData({{ events }});
    });
  </script>

  <blockquote>
    {% for legend in legends %}
      <p style='margin: 0px;'>
        <span style='display:inline-block;width:1em;height:1em;background-color:{{ legend.color }}'></span>&nbsp;{{ legend.animation }}&nbsp;&nbsp;
      </p>
    {% endfor %}
  </blockquote>
</div>";
    }

    public function get_form()
    {
        if (empty($this->parameters["calendar_color"])) {
            $this->parameters["calendar_color"] = self::COLOR_STATUT;
        }

        $form = "
        <div class='row'>
            <div class='colonne3'>
                <label for='calendar_color_statut'>
                    " . $this->format_text($this->msg['cms_module_animationslist_view_calendar_color']) . "
                </label>
            </div>
            <div class='colonne-suite'>
                <input type='radio' id='calendar_color_statut'
                     value='" . self::COLOR_STATUT . "'
                     name='" . $this->get_form_value_name("calendar_color") . "'
                    " . ($this->parameters["calendar_color"] == self::COLOR_STATUT ? "checked" : "") . "/>
                <label for='calendar_color'>
                    " . $this->format_text($this->msg['calendar_color_statut']) . "
                </label>

                <input type='radio' id='calendar_color_calendar'
                     value='" . self::COLOR_CALENDAR . "'
                     name='" . $this->get_form_value_name("calendar_color") . "'
                    " . ($this->parameters["calendar_color"] == self::COLOR_CALENDAR ? "checked" : "") . "/>
                <label for='calendar_color'>
                    " . $this->format_text($this->msg['calendar_color_calendar']) . "
                </label>
            </div>
        </div>
        <div class='row'>
            <div class='colonne3'>
                <label for='" . $this->class_name . "_link_animation'>
                    " . $this->format_text($this->msg['cms_module_animationslist_view_calendar_link_animation']) . "
                </label>
            </div>
            <div class='colonne-suite'>
                " . $this->get_constructor_link_form('animation') . "
            </div>
        </div>
        <div class='row'>
            <div class='colonne3'>
                <label for='" . $this->class_name . "_link_animationslist'>
                    " . $this->format_text($this->msg['cms_module_animationslist_view_calendar_link_animationslist']) . "
                </label>
            </div>
            <div class='colonne-suite'>
                 " . $this->get_constructor_link_form('animationslist') . "
            </div>
        </div>";

        $form .= parent::get_form();
        return $form;
    }

    public function save_form()
    {
        $this->save_constructor_link_form('animation');
        $this->save_constructor_link_form('animationslist');
        $this->parameters['calendar_color'] = $this->get_value_from_form("calendar_color");
        return parent::save_form();
    }

    public function get_headers($datas = [])
    {
        global $opac_url_base;
        $headers = parent::get_headers($datas);
        $headers[] = '<script src="' . $opac_url_base . '/includes/javascript/rgaa/Calendar.js"></script>';
        return $headers;
    }

    public function render($datas)
    {
        $renderDatas = [
            "legends" => [
                "colors" => [],
                "animations" => [],
            ],
            "animations" => [],
            "events" => [],
        ];

        $styles = [];
        if (!empty($datas["animations"])) {
            foreach ($datas["animations"] as $idAnimation) {
                $animation = new AnimationModel($idAnimation);
                $animation->fetchEvent();
                if (empty($animation->event->startDate)) {
                    continue;
                }

                // On choisi la couleur du calendrier
                if (self::COLOR_CALENDAR == $this->parameters["calendar_color"]) {
                    $animation->fetchCalendar();
                    $color = $animation->calendar->color;
                    $colorKey = $animation->numCalendar;
                    $colorName = $animation->calendar->name;
                } else {
                    $animation->fetchStatus();
                    $color = $animation->status->color;
                    $colorKey = $animation->numStatus;
                    $colorName = $animation->status->label;
                }

                if ($animation->event->duringDay) {
                    $endDate = $animation->event->startDate;
                } else {
                    $endDate = $animation->event->endDate;
                }

                $animationData = $animation->getCmsData(['fetchParent', 'fetchMailing']);
                $animationData['link'] = $this->get_constructed_link("animation", $idAnimation);
                $renderDatas['animations'][] = $animationData;
                $renderDatas['events'][] = [
                    'title' => $this->format_text($animation->name),
                    'start' => $animation->event->startDate,
                    'end' => $endDate,
                    'color' => $color,
                    'link' => $this->get_constructed_link("animation", $idAnimation),
                ];

                $styles[$colorKey] = $color;
                if (!isset($renderDatas["legends"]['colors'][$colorKey])) {
                    $renderDatas["legends"]['colors'][$colorKey] = [
                        'color' => $color,
                        'colorKey' => $colorKey,
                        'name' => $colorName
                    ];
                }

                $renderDatas["legends"]['animations'][] = [
                    "color" => $color,
                    "animation" => $this->format_text($animation->name),
                    "link" => $this->get_constructed_link("animation", $idAnimation),
                ];
            }
        }

        $renderDatas['events'] = encoding_normalize::json_encode(encoding_normalize::utf8_normalize($renderDatas['events']));
        if (empty($renderDatas['events'])) {
            $renderDatas['events'] = "{}";
        }

        $renderDatas["legends"]['colors'] = array_values($renderDatas["legends"]['colors']);

        return parent::render($renderDatas);
    }

    public function get_format_data_structure()
    {
        $formatData = (new AnimationModel())->getCmsStructure("animations[i]");
        $formatData[0]['children'][] = [
            'var' => "animations[i].link",
            'desc' => $this->msg['cms_module_animationslist_view_calendar_link'],
        ];
        $formatData[] = [
            'var' => "calendar",
            'desc' => $this->msg['cms_module_animationslist_view_calendar_calendar_desc'],
        ];
        $formatData[] = [
            'var' => "legends",
            'desc' => $this->msg['cms_module_animationslist_view_calendar_legends_desc'],
            'children' => [
                [
                    'var' => "legends[i].animations",
                    'desc' => $this->msg['cms_module_animationslist_view_calendar_legend_calendar_desc'],
                ],
                [
                    'var' => "legends[i].colors",
                    'desc' => $this->msg['cms_module_animationslist_view_calendar_legend_color_desc'],
                ],
            ],
        ];
        return array_merge($formatData, parent::get_format_data_structure());
    }
}
