<?php

// +-------------------------------------------------+
//  2002-2012 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: cms_module_agenda_view_calendar_rgaa_django.class.php,v 1.1.2.2 2025/09/02 09:20:20 qvarin Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) {
    die("no access");
}

class cms_module_agenda_view_calendar_rgaa_django extends cms_module_common_view_django
{
    public function __construct($id = 0)
    {
        $this->use_dojo = true;
        parent::__construct($id);
        $this->default_template = "
<div>
  <div id='calendar_{{ id }}'></div>
  <script>
    document.addEventListener('DOMContentLoaded', function() {
        const calendar = new Calendar('calendar_{{ id }}', 'events');
		calendar.setData({{ calendar_events }});
    });
  </script>

  <blockquote>
    {% for legend in legends.colors %}
      <p style='margin: 0px;'>
        <span style='display:inline-block;width:1em;height:1em;background-color:{{ legend.color }}'></span>&nbsp;{{ legend.event }}&nbsp;&nbsp;
      </p>
    {% endfor %}
  </blockquote>
</div>";
    }

    public function get_form()
    {
        $form = "
		<div class='row'>
			<div class='colonne3'>
				<label for='". $this->class_name . "_link_events'>
				    ".$this->format_text($this->msg['cms_module_agenda_view_calendar_link_event'])."
				</label>
			</div>
			<div class='colonne-suite'>
		        ". $this->get_constructor_link_form('events') ."
			</div>
		</div>";

        $form .= parent::get_form();
        return $form;
    }

    public function save_form()
    {
        $this->save_constructor_link_form('events');
        return parent::save_form();
    }

    public function get_headers($datas = [])
    {
		global $opac_url_base;
        $headers = parent::get_headers($datas);
        $headers[] = '<script src="'.$opac_url_base.'/includes/javascript/rgaa/Calendar.js"></script>';
        return $headers;
    }

    public function render($datas)
    {
        $renderDatas = [
            "legends" => [
                "colors" => [],
                "events" => [],
            ],
            "events" => [],
            "calendar_events" => [],
        ];

        if (!empty($datas["events"])) {
            foreach ($datas["events"] as $event) {
                $event->link = $this->get_constructed_link("event", $event->id);
                $renderDatas['events'][] = $event;

                $renderDatas['calendar_events'][] = [
                    'title' => $this->format_text($event->get_title()),
                    'start' => $event->event_start['value'],
                    'end' => $event->event_end['value'],
                    'color' => $event->color,
                    'link' => $event->link,
                ];

                if (!isset($renderDatas["legends"]['colors'][$event->color])) {
                    $renderDatas["legends"]['colors'][$event->color] = [
                        'color' => $event->color,
                        'colorKey' => $event->color,
                        'name' => $this->format_text($event->calendar)
                    ];
                }

                $renderDatas["legends"]['events'][] = [
                    "color" => $event->color,
                    "event" => $this->format_text($event->get_title()),
                    "link" => $event->link,
                ];
            }
        }

        $renderDatas['calendar_events'] = encoding_normalize::json_encode(encoding_normalize::utf8_normalize($renderDatas['calendar_events']));
        if (empty($renderDatas['calendar_events'])) {
            $renderDatas['calendar_events'] = "{}";
        }

        $renderDatas["legends"]['colors'] = array_values($renderDatas["legends"]['colors']);

        return parent::render($renderDatas);
    }

    public function get_format_data_structure()
    {
        $datasource = new cms_module_agenda_datasource_agenda();
        $formatData = $datasource->get_format_data_structure("eventslist");
        $formatData[0]['children'][] = [
            'var' => "events[i].link",
            'desc' => $this->msg['cms_module_agenda_view_calendar_link_desc'],
        ];
        $formatData[] = [
            'var' => "calendar_events",
            'desc' => $this->msg['cms_module_agenda_view_calendar_calendar_desc'],
        ];
        $formatData[] = [
            'var' => "legends",
            'desc' => $this->msg['cms_module_agenda_view_calendar_legends_desc'],
            'children' => [
                [
                    'var' => "legends[i].events",
                    'desc' => $this->msg['cms_module_agenda_view_calendar_legend_calendar_desc'],
                ],
                [
                    'var' => "legends[i].color",
                    'desc' => $this->msg['cms_module_agenda_view_calendar_legend_color_desc'],
                ],
            ],
        ];
        return array_merge($formatData, parent::get_format_data_structure());
    }
}
