<?php

// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: cleanDatastoreLabel.php,v 1.1.4.2 2025/08/08 13:03:27 qvarin Exp $

// Check if the script is run from the command line
if (php_sapi_name() !== 'cli') {
    die('This script can only be run from the command line.');
}

// Base path
$base_path = './../..';
$class_path = $base_path . '/classes';
$include_path = $base_path . '/includes';

// Base variables
$base_noheader = 1;
$base_nocheck = 1;
$base_nobody = 1;
$base_nosession = 1;

$_GET = [];
$_POST = [];
$_FILES = [];
$_SERVER['REQUEST_URI'] = '';
$_SERVER['HTTP_USER_AGENT'] = '';

define('CONTRIBUTION_ENTITIES', [
    'http://www.pmbservices.fr/ontology#record' => 'record',
    // 'http://www.pmbservices.fr/ontology#serial' => 'serial',
    'http://www.pmbservices.fr/ontology#bulletin' => 'bulletin',
    'http://www.pmbservices.fr/ontology#author' => 'author',
    'http://www.pmbservices.fr/ontology#publisher' => 'publisher',
    'http://www.pmbservices.fr/ontology#work' => 'work',
    'http://www.pmbservices.fr/ontology#collection' => 'collection',
    'http://www.pmbservices.fr/ontology#subcollection' => 'subcollection',
    'http://www.pmbservices.fr/ontology#indexint' => 'indexint',
    'http://www.pmbservices.fr/ontology#serie' => 'serie',
    'http://www.pmbservices.fr/ontology#authperso' => 'authperso',
    'http://www.w3.org/2004/02/skos/core#Concept' => 'concept',
    'http://www.pmbservices.fr/ontology#category' => 'category'
]);

function setDatabase(string $bdd)
{
    global $database;
    $database = $bdd;
}

function argumentsHelp()
{
    echo "Usage :" . PHP_EOL;
    echo "  php cleanDatastoreLabel.php <entity> [options]" . PHP_EOL;
    echo PHP_EOL;
    echo "Exemples :" . PHP_EOL;
    echo "  php cleanDatastoreLabel.php                       (all entities are cleaned by default)" . PHP_EOL;
    echo "  php cleanDatastoreLabel.php record                (records are cleaned)" . PHP_EOL;
    echo "  php cleanDatastoreLabel.php record author -bd=pmb (records and explnums are cleaned in the pmb database)" . PHP_EOL;
    echo PHP_EOL;
    echo "Options :" . PHP_EOL;
    echo "  -bd=<database>, --database=<database>             Database name" . PHP_EOL;
    echo "  -h, --help                                        Display this help" . PHP_EOL;
    echo PHP_EOL;
    echo "Entities :                                          Optional, all entities are cleaned by default" . PHP_EOL;
    foreach (CONTRIBUTION_ENTITIES as $entity) {
        echo "  $entity" . PHP_EOL;
    }
    exit;
}

function contributionUnknownEntity(string $entity)
{
    echo "Unknown entity: $entity" . PHP_EOL;
    echo "Use entities: " . PHP_EOL;
    foreach (CONTRIBUTION_ENTITIES as $entity) {
        echo "  $entity" . PHP_EOL;
    }
    exit(1);
}

function arguments()
{
    // Rcuprer les arguments en ligne de commande
    $argv = $_SERVER['argv'];
    if (! is_array($argv)) {
        $argv = [];
    }

    // Supprimer le nom du script lui-mme
    array_shift($argv);

    // Recherche de l'argument --database= dans les arguments fournis pour rcuprer le nom de la base de donnes
    foreach ($argv as $key => $arg) {
        if ($arg === '--help' || $arg === '-h') {
            argumentsHelp();
        }

        if (strpos($arg, '-bd=') === 0) {
            setDatabase(substr($arg, strlen('-bd=')));
            unset($argv[$key]);
            break;
        }

        if (strpos($arg, '--database=') === 0) {
            setDatabase(substr($arg, strlen('--database=')));
            unset($argv[$key]);
            break;
        }
    }

    return $argv;
}

$entities = arguments();
if (empty($entities)) {
    $entities = CONTRIBUTION_ENTITIES;
} else {
    foreach ($entities as $entity) {
        if (!in_array($entity, CONTRIBUTION_ENTITIES)) {
            contributionUnknownEntity($entity);
        }
    }
}

require_once $base_path . '/includes/init.inc.php';

// Disable error reporting
ini_set('display_errors', 0);
error_reporting(0);

//On inclut les messages pour viter les warnings dans les inclusions de fichiers qui utilisent $msg
global $msg, $lang;
$messages = new XMLlist("$include_path/messages/$lang.xml", 0);
$messages->analyser();
$msg = $messages->table;

require_once $base_path . '/classes/entities.class.php';
require_once $base_path . '/devel/sphinx/progress_bar.php';

echo "Clean Datastore Label" . PHP_EOL;
echo "  Database: " . LOCATION . PHP_EOL;
echo "  Started at: " . date('Y-m-d H:i:s') . PHP_EOL . PHP_EOL;

foreach ($entities as $entity) {
    try {
        $uriType = array_flip(CONTRIBUTION_ENTITIES)[$entity];
        $items = new contribution_area_items($uriType);
        $items->cleanItems(true);
    } catch (InvalidArgumentException $e) {
        echo "Error: " . $e->getMessage() . PHP_EOL;
        exit(1);
    }
}