<?php
// +-------------------------------------------------+
// | 2002-2011 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: list_analysis_caddie_content_ui.class.php,v 1.1.4.4 2026/02/11 07:21:56 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

class list_analysis_caddie_content_ui extends list_caddie_content_ui {
		
    public function get_dataset_title() {
        global $msg, $charset;
        
        if(isset($msg['caddie_de_ANALYSIS'])) {
            return htmlentities($msg['caddie_de_ANALYSIS'], ENT_QUOTES, $charset);
        }
        return parent::get_dataset_title();
    }
    
	protected function _get_query_select() {
	    $query_select = parent::_get_query_select();
	    $query_select .= ", bulletins.*";
	    return $query_select;
	}
	
	protected function _get_query_left_join() {
	    switch (static::$object_type) {
	        case 'NOTI':
	            return parent::_get_query_left_join()."
                    left join analysis on analysis_notice=notices.notice_id
					left join bulletins on analysis_bulletin=bulletins.bulletin_id";
	    }
	    return parent::_get_query_left_join();
	}
	
	protected function _get_query_items_data() {
	    return "SELECT analysis.analysis_notice AS record_id ".$this->_get_query_select_items_fields()."
            FROM exemplaires
            JOIN bulletins ON bulletins.bulletin_id = exemplaires.expl_bulletin
            JOIN analysis ON analysis.analysis_bulletin = bulletins.bulletin_id
            ".$this->_get_query_join_items_fields()."
            WHERE analysis.analysis_notice IN (".implode(',', $this->records_ids).")";
	}
	
	protected function init_default_columns() {
	    parent::init_default_columns();
	    switch (static::$object_type) {
	        case 'NOTI':
	            $this->add_column('bulletin_numero');
	            $this->add_column('mention_date');
	            $this->add_column('date_date');
	            $this->add_column('bulletin_titre');
	            $this->add_column('bulletin_serial');
	            $this->add_column('bulletin_cb');
	            break;
	        default:
	            break;
	    }
	}
}