<?php
// +-------------------------------------------------+
// | 2002-2011 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: custom_fields_text.class.php,v 1.2.4.2 2025/11/18 14:22:49 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

class custom_fields_text extends custom_fields {
    
    protected static $type = 'text';
    
    public static function val($field, $value) {
        global $pmb_perso_sep;
        
        $value=format_output($field,$value);
        if (!$value) {
            $value=array();
        }
        if(!isset($field["OPTIONS"][0]["ISHTML"][0]["value"])) {
            $field["OPTIONS"][0]["ISHTML"][0]["value"] = '';
        }
        if($field["OPTIONS"][0]["ISHTML"][0]["value"]){
            return array("ishtml" => true, "value"=>implode($pmb_perso_sep,$value), "withoutHTML" =>implode($pmb_perso_sep,$value));
        }else{
            return implode($pmb_perso_sep,$value);
        }
    }
    
    protected static function get_js_function_add($field) {
        return "<script>
			function add_custom_text_(field_id, field_name, field_size, field_maxlen) {
				document.getElementById('customfield_text_'+field_id).value = document.getElementById('customfield_text_'+field_id).value * 1 + 1;
		        count = document.getElementById('customfield_text_'+field_id).value;
            
				var node_dnd_id = get_custom_dnd_on_add('spaceformorecustomfieldtext_'+field_id, 'customfield_text_'+field_name, (count-1));
				var buttonAdd = document.getElementById('button_add_'+ field_name + '_' + field_id);
            
				f_aut0 = document.createElement('input');
		        f_aut0.setAttribute('name',field_name+'[]');
		        f_aut0.setAttribute('id',field_name+(count-1));
		        f_aut0.setAttribute('data-form-name',field_name);
		        f_aut0.setAttribute('type','text');
		        f_aut0.setAttribute('size',field_size);
		        f_aut0.setAttribute('maxlength',field_maxlen);
		        f_aut0.setAttribute('value','');
		        space=document.createElement('br');
				document.getElementById(node_dnd_id).appendChild(f_aut0);
				if (buttonAdd) document.getElementById(node_dnd_id).appendChild(buttonAdd);
				document.getElementById(node_dnd_id).appendChild(space);
			}
		</script>";
    }
    
    protected static function get_event_button_add($field) {
        $options=$field['OPTIONS'][0];
        return 'add_custom_text_(\''.$field['ID'].'\', \''.addslashes($field['NAME']).'\', \''.addslashes($options['SIZE'][0]['value']).'\', \''.addslashes($options['MAXSIZE'][0]['value']).'\')';
    }
    
    public static function get_display_value($field, $indice, $value) {
        global $charset;
        
        $options=$field['OPTIONS'][0];
        return "<input id=\"".$field['NAME'].$indice."\" type=\"text\" size=\"".$options['SIZE'][0]['value']."\" maxlength=\"".$options['MAXSIZE'][0]['value']."\" name=\"".$field['NAME']."[]\" data-form-name='".$field['NAME']."' value=\"".htmlentities($value,ENT_QUOTES,$charset)."\">";
    }
    
    public static function aff_search($field,&$check_scripts,$varname) {
        global $charset;
        
        $options=$field['OPTIONS'][0];
        $values=$field['VALUES'];
        if(!isset($values[0])) {
            $values[0] = '';
        }
        $ret="<input id=\"".$varname."\" type=\"text\" size=\"".$options['SIZE'][0]['value']."\" name=\"".$varname."[]\" value=\"".htmlentities($values[0],ENT_QUOTES,$charset)."\">";
        return $ret;
    }
    
    public static function get_formatted_label_aff_filter($label) {
        return cutlongwords($label);
    }
    
    public static function get_rgaa_label($field, $varname) {
        return $varname;
    }
}