<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: bulletinage_display.class.php,v 1.1.4.2 2025/10/22 07:36:17 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

global $include_path;
require_once($include_path."/notice_categories.inc.php");
require_once($include_path."/explnum.inc.php");

// rcupration des codes de fonction
global $fonction_auteur;
if (!isset($fonction_auteur)) {
	$fonction_auteur = new marc_list('function');
	$fonction_auteur = $fonction_auteur->table;
}

// proprits pour le selecteur de panier (kinda template)
$cart_click = "onClick=\"openPopUp('./cart.php?object_type=NOTI&item=!!item!!&unq=!!unique!!', 'cart')\"";

// -------------------------------------------------------------------
//   classe bulletinage_display : utilise pour le prt de documents
// -------------------------------------------------------------------
class bulletinage_display {
	public $bul_id = 0;		// id du bulletinage  afficher
	public $display = '';		// texte  afficher
	public $parent_title = '';		// titre gnral de la revue  laquelle fait rfrence ce bulletinage
	public $bulletin_titre = '';	// titre de ce bulletin
	public $numerotation = '';		// mention de numrotation sur la revue
	public $periode	  = '';		// mention de date de la revue (txt)
	public $date_date	  = '';		// mention de date de la revue (date)
	public $header	  = '';		// pour affichage rduit
	public $aff_date_date;

	// constructeur
	public function __construct($id=0) {
	    $this->bul_id = intval($id);
		if(!$this->bul_id) {
			$this->display = "Error : bul_id is null";
			return $this->bul_id;
		}
		$this->fetch_bulletinage_data();
		$this->make_display();
		return $this->bul_id;
	}

	// fabrication de la mention  afficher
	public function make_display() {
		if ($this->parent_title) {
			$this->display = $this->parent_title;
		} else {
			$this->display = "error: unknown record";
			return;
		}
		if((!$this->numerotation && !$this->periode && !$this->bulletin_titre && !$this->date_date) || !$this->bul_id) {
			$this->display .= " error : missing information";
		}
		if($this->numerotation) {
			$this->display .= '. '.$this->numerotation;
		}
		$this->header = $this->display;

		// affichage de la mention de date utile : mention_date si existe, sinon date_date
		if ($this->periode) {
			$date_affichee = " (".$this->periode.") ";
		} else {
			$date_affichee = " [".$this->aff_date_date."]";
		}
		$this->display .= $date_affichee;

		if ($date_affichee) {
		    $this->header .= $date_affichee;
		}
	}

	// rcupration des infos bulletinage en base
	public function fetch_bulletinage_data() {
		global $msg;

		$requete = "SELECT bulletins.*, notices.tit1, date_format(date_date, '".$msg["format_date"]."') as aff_date_date FROM bulletins, notices ";
		$requete .= " WHERE bulletins.bulletin_id=".$this->bul_id;
		$requete .= " AND notices.notice_id=bulletins.bulletin_notice";
		$requete .= " AND notices.niveau_biblio='s' AND notices.niveau_hierar='1' LIMIT 1";

		$myQuery = pmb_mysql_query($requete);
		if(pmb_mysql_num_rows($myQuery)) {
			$result = pmb_mysql_fetch_object($myQuery);
			$this->parent_title = $result->tit1;
			$this->bulletin_titre = $result->bulletin_titre;
			$this->numerotation = $result->bulletin_numero;
			$this->periode = $result->mention_date;
			$this->date_date = $result->date_date;
			$this->aff_date_date = $result->aff_date_date;
			$this->bul_id = $result->bulletin_id;
		}
		return;
	}
} // class serial_display