<?php
// +-------------------------------------------------+
// | 2002-2011 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: accounting_invoice.class.php,v 1.1.4.2 2026/02/13 11:33:32 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

global $class_path;
require_once($class_path."/actes.class.php");

class accounting_invoice extends actes {
    
    public function get_form($id_bibli, $id_cde=0) {
        global $msg, $charset;
        global $fact_modif_form, $frame_show, $frame_show_from_cde;
        global $bt_sup, $bt_enr, $bt_pay, $form_search;
        global $pmb_type_audit, $bt_audit;
        
        if(!$this->id_acte) {		//creation de facture
            $cde = new actes($id_cde);
            $this->num_fournisseur = $cde->num_fournisseur;
            $this->num_exercice = $cde->num_exercice;
            $this->date_acte = today();
            $this->devise = $cde->devise;
            $titre = htmlentities($msg['acquisition_fac_cre'], ENT_QUOTES, $charset);
        } else {
            $id_cde = liens_actes::getParent($this->id_acte);
            $cde = new actes($id_cde);
            $titre = htmlentities($msg['acquisition_fac_mod'], ENT_QUOTES, $charset);
        }
        
        $fou = new entites($this->num_fournisseur);
        
        $bibli = new entites($id_bibli);
        $exer = new exercices($this->num_exercice);
        
        $form = $fact_modif_form;
        
        if (!$this->id_acte) {
            $form = str_replace('<!-- frame_show -->', $frame_show_from_cde, $form);
            $form = str_replace('<!-- bouton_enr -->', $bt_enr, $form);
            $form = str_replace('<!-- form_search -->', $form_search, $form);
        } else {
            $form = str_replace('<!-- frame_show -->', $frame_show, $form);
            if( (($this->statut & STA_ACT_PAY) == STA_ACT_PAY) || (($this->statut & STA_ACT_ARC) == STA_ACT_ARC) )  {
                //La facture est paye ou archive, donc non modifiable
            } else {
                $form = str_replace('<!-- bouton_pay -->', $bt_pay, $form);
                $form = str_replace('<!-- bouton_sup -->', $bt_sup, $form);
                $form = str_replace('<!-- bouton_enr -->', $bt_enr, $form);
                $form = str_replace('<!-- form_search -->', $form_search, $form);
            }
        }
        
        $form = str_replace('!!form_title!!', $titre, $form);
        $form = str_replace('!!id_bibli!!', $id_bibli, $form);
        $form = str_replace('!!lib_bibli!!', htmlentities($bibli->raison_sociale, ENT_QUOTES, $charset), $form);
        $form = str_replace('!!id_exer!!', $exer->id_exercice, $form);
        $form = str_replace('!!lib_exer!!', htmlentities($exer->libelle, ENT_QUOTES, $charset), $form);
        
        $form = str_replace('!!id_cde!!', $id_cde, $form);
        $lien_cde = "<a href=\"./acquisition.php?categ=ach&sub=cmde&action=modif&id_bibli=".$id_bibli."&id_cde=".$id_cde."\">".htmlentities($cde->numero, ENT_QUOTES, $charset)."</a>";
        $form = str_replace('!!num_cde!!', $lien_cde, $form);
        $form = str_replace('!!date_cre!!', formatdate($this->date_acte), $form);
        $form = str_replace('!!id_fac!!', $this->id_acte, $form);
        $form = str_replace('!!numero!!', htmlentities($this->numero, ENT_QUOTES, $charset), $form);
        if ($this->date_paiement != '0000-00-00') {
            $form = str_replace('!!date_pay!!', formatdate($this->date_paiement), $form);
        } else {
            $form = str_replace('!!date_pay!!', '', $form);
        }
        if (!$this->num_paiement) {
            $form = str_replace('!!num_pay!!', '', $form);
        } else {
            $form = str_replace('!!num_pay!!', htmlentities($this->num_paiement,ENT_QUOTES, $charset), $form);
        }
        if($cde->date_paiement != '0000-00-00') {
            $form = str_replace('!!date_pay_cde!!', formatdate($cde->date_paiement), $form);
        } else {
            $form = str_replace('!!date_pay_cde!!', '', $form);
        }
        if (!$cde->num_paiement) {
            $form = str_replace('!!num_pay_cde!!', '', $form);
        } else {
            $form = str_replace('!!num_pay_cde!!', htmlentities($cde->num_paiement, ENT_QUOTES, $charset) , $form);
        }
        $form = str_replace('!!id_fou!!', $this->num_fournisseur, $form);
        $form = str_replace('!!lib_fou!!', htmlentities($fou->raison_sociale, ENT_QUOTES, $charset), $form);
        $form = str_replace('!!comment!!', htmlentities($this->commentaires, ENT_QUOTES, $charset), $form);
        $form = str_replace('!!ref!!', htmlentities($this->reference, ENT_QUOTES, $charset), $form);
        $form = str_replace('!!devise!!', htmlentities($this->devise, ENT_QUOTES, $charset), $form );
        
        if ($this->id_acte && $pmb_type_audit) {
            $form = str_replace('<!-- bouton_audit -->', $bt_audit, $form);
        }
        return $form;
    }
    
    
}