<?php
// +-------------------------------------------------+
// | 2002-2011 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: accounting_devis.class.php,v 1.1.4.4 2026/02/13 11:07:29 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

global $class_path;
require_once($class_path."/actes.class.php");

class accounting_devis extends actes {
	
    public $from_sug = false;
    public $sugchk = null;
    
    public function get_form() {
        global $msg, $charset;
        global $modif_dev_form,  $bt_enr, $bt_dup, $bt_sup, $bt_cde, $bt_imp;
    	global $pmb_gestion_devise;
        global $pmb_type_audit, $bt_audit;
        
        $lib_fou = '';
        $id_adr_fou = 0;
        $adr_fou = '';
        $adr_fac = '';
        $adr_liv = '';
        $liens_cde = '';
        if(!$this->id_acte) {	//nouveau devis
            $titre = $msg['acquisition_dev_cre'];
            
            $statut = STA_ACT_ENC;
            $sel_statut = "<input type='hidden' id='statut' name='statut' value='".$statut."' />";
            $sel_statut.=htmlentities($msg['acquisition_dev_enc'], ENT_QUOTES, $charset);
            
            
            if ($this->num_contact_fact) {
                $coord = new coordonnees($this->num_contact_fact);
            } else {
                $coord_fac = entites::get_coordonnees($this->num_entite, '1');
                if (pmb_mysql_num_rows($coord_fac) != 0) {
                    $coord = pmb_mysql_fetch_object($coord_fac);
                    $this->num_contact_fact = $coord->id_contact;
                }
            }
            if ($this->num_contact_fact) {
                $adr_fac = coordonnees::get_formatted_address_form_coord($coord);
            }
            if ($this->num_contact_livr) {
                $coord = new coordonnees($this->num_contact_livr);
            } else {
                $coord_liv = entites::get_coordonnees($this->num_entite, '2');
                if (pmb_mysql_num_rows($coord_liv) != 0) {
                    $coord = pmb_mysql_fetch_object($coord_liv);
                    $this->num_contact_livr = $coord->id_contact;
                }
            }
            if ($this->num_contact_livr) {
                $adr_liv = coordonnees::get_formatted_address_form_coord($coord);
            } else {
                $this->num_contact_livr = $this->num_contact_fact;
                $adr_liv = $adr_fac;
            }
            
            $devise = $pmb_gestion_devise;
            
            
            $bt_dup='';
            $bt_cde='';
            $bt_imp = '';
            $bt_audit = '';
            $bt_sup = '';
            
            if ($this->from_sug) {
//                 $lignes = show_lig_dev_from_sug($this->sugchk);
                $lignes = $this->get_lines_form_from_sug();
            } else {
                $lignes = array(0=>0, 1=>'');
            }
        } else {
            $titre = $msg['acquisition_dev_mod'];
            $statut = $this->statut;
            if (($statut & STA_ACT_ARC) == STA_ACT_ARC) {
                $statut=STA_ACT_ARC;
            }
            //Creation selecteur statut
            $sel_statut = "<select class='saisie-25em' id='statut' name='statut' >";
            $list_statut = actes::getStatelist(TYP_ACT_DEV, false);
            foreach($list_statut as $k=>$v){
                $sel_statut.="<option value='".$k."'>".htmlentities($v, ENT_QUOTES, $charset)."</option>";
            }
            $sel_statut.= "</select>";
            
            $fou = new entites($this->num_fournisseur);
            $lib_fou = $fou->raison_sociale;
            $coord = entites::get_coordonnees($fou->id_entite, '1');
            if (pmb_mysql_num_rows($coord) != 0) {
                $coord = pmb_mysql_fetch_object($coord);
                $id_adr_fou = $coord->id_contact;
                $adr_fou = coordonnees::get_formatted_address_form_coord($coord);
            }
            if ($this->num_contact_fact) {
                $coord_fac = new coordonnees($this->num_contact_fact);
                $adr_fac = $coord_fac->get_formatted_address();
            }
            if ($this->num_contact_livr) {
                $coord_liv = new coordonnees($this->num_contact_livr);
                $adr_liv = $coord_liv->get_formatted_address();
            }
            $tab_liens = liens_actes::getChilds($this->id_acte);
            while (($row_liens = pmb_mysql_fetch_object($tab_liens))) {
                if( ($row_liens->type_acte) == TYP_ACT_CDE ) {
                    $liens_cde.= "<br /><a href=\"./acquisition.php?categ=ach&sub=cmde&action=modif&id_bibli=".$this->num_entite."&id_cde=".$row_liens->num_acte_lie."\">".$row_liens->numero."</a>";
                }
            }
            
            $devise = htmlentities($this->devise, ENT_QUOTES, $charset);
            if (!$pmb_type_audit) {
                $bt_audit = '';
            }
//             $lignes = show_lig_dev($this->id_acte);
            $lignes = $this->get_lines_form();
        }
        $form = $modif_dev_form;
        
        $form = str_replace('<!-- sel_statut -->', $sel_statut, $form);
        $form = str_replace('<!-- bouton_enr -->', $bt_enr, $form);
        $form = str_replace('<!-- bouton_dup -->', $bt_dup, $form);
        $form = str_replace('<!-- bouton_cde -->', $bt_cde, $form);
        $form = str_replace('<!-- bouton_imp -->', $bt_imp, $form);
        $form = str_replace('<!-- bouton_audit -->', $bt_audit, $form);
        $form = str_replace('<!-- bouton_sup -->', $bt_sup, $form);
        $form = str_replace('!!act_nblines!!', $lignes[0], $form);
        $form = str_replace('<!-- lignes -->', $lignes[1], $form);
        
        //Remplissage formulaire
        $form = str_replace('!!form_title!!', htmlentities($titre, ENT_QUOTES, $charset), $form);
        $form = str_replace('!!id_bibli!!', $this->num_entite, $form);
        //Recuperation etablissement
        $bibli = new entites($this->num_entite);
        $form = str_replace('!!lib_bibli!!', htmlentities($bibli->raison_sociale, ENT_QUOTES, $charset), $form);
        $form = str_replace('!!id_dev!!', $this->id_acte, $form);
        $form = str_replace('!!date_cre!!', formatdate($this->date_acte), $form);
        $form = str_replace('!!numero!!', htmlentities($this->numero, ENT_QUOTES, $charset), $form);
        $form = str_replace('!!statut!!', $statut, $form);
        $form = str_replace('!!id_fou!!', $this->num_fournisseur, $form);
        $form = str_replace('!!lib_fou!!', htmlentities($lib_fou, ENT_QUOTES, $charset), $form);
        $form = str_replace('!!id_adr_fou!!', $id_adr_fou, $form);
        $form = str_replace('!!adr_fou!!', $adr_fou, $form);
        $form = str_replace('!!id_adr_liv!!', $this->num_contact_livr, $form);
        $form = str_replace('!!adr_liv!!', $adr_liv, $form);
        $form = str_replace('!!id_adr_fac!!', $this->num_contact_fact, $form);
        $form = str_replace('!!adr_fac!!', $adr_fac, $form);
        $form = str_replace('!!comment!!', htmlentities($this->commentaires, ENT_QUOTES, $charset), $form);
        $form = str_replace('!!comment_i!!', htmlentities($this->commentaires_i, ENT_QUOTES, $charset), $form);
        $form = str_replace('!!ref!!', htmlentities($this->reference, ENT_QUOTES, $charset), $form);
        $form = str_replace('!!devise!!', $devise, $form);
        $form = str_replace('!!liens_cde!!', $liens_cde, $form);
        return $form;
    }
    
    protected function get_line_form($indice, $row) {
        global $charset;
        global $modif_dev_row_form;
        global $acquisition_gestion_tva;
        
        $line_form = $modif_dev_row_form;
        
        $line_form = str_replace('!!no!!', $indice, $line_form);
        $line_form = str_replace('!!code!!', htmlentities($row->code, ENT_QUOTES, $charset), $line_form);
        $line_form = str_replace('!!lib!!', htmlentities($row->libelle, ENT_QUOTES, $charset), $line_form);
        $line_form = str_replace('!!qte!!', $row->nb, $line_form);
        $line_form = str_replace('!!prix!!', $row->prix, $line_form);
        if ($row->num_type) {
            $tp = new types_produits($row->num_type);
            $line_form = str_replace('!!typ!!', $tp->id_produit, $line_form);
            $line_form = str_replace('!!lib_typ!!', htmlentities($tp->libelle, ENT_QUOTES, $charset), $line_form);
        } else {
            $line_form = str_replace('!!typ!!', '0', $line_form);
            $line_form = str_replace('!!lib_typ!!', '', $line_form);
        }
        if ($acquisition_gestion_tva) {
            $line_form = str_replace('!!tva!!', $row->tva , $line_form);
        }
        $line_form = str_replace('!!rem!!', $row->remise, $line_form);
        $line_form = str_replace('!!id_sug!!', $row->num_acquisition, $line_form);
        $line_form = str_replace('!!id_lig!!', $row->id_ligne, $line_form);
        $line_form = str_replace('!!typ_lig!!', $row->type_ligne, $line_form);
        $line_form = str_replace('!!id_prod!!', $row->num_produit, $line_form);
        return $line_form;
    }
    
    public function get_lines_form() {
        $lines_form = "";
        $i=0;
        if (!$this->id_acte) {
            $t = array(0=>$i, $lines_form);
            return $t;
        }
        $lignes = actes::getLignes($this->id_acte);
        while (($row = pmb_mysql_fetch_object($lignes))) {
            $i++;
            $lines_form .= $this->get_line_form($i, $row);
        }
        $t = array(0 => $i, 1=> $lines_form);
        return $t;
    }
    
    public function get_lines_form_from_sug() {
        global $charset;
        
        $lines_form = "";
        $i=0;
        
        $arrchk = unserialize(rawurldecode(stripslashes($this->sugchk)));
        foreach($arrchk as $value) {
            $i++;
            
            $sug = new suggestions($value);
            $row = new stdClass();
            $row->code = "";
            $row->libelle = "";
            $row->prix = '0';
            $row->num_type = 0;
            $nb='none';
            $row->tva = '0.00';
            $row->remise = '0.00';
            $row->num_acquisition = $sug->id_suggestion;
            $row->num_produit = $sug->num_notice;
            $row->id_ligne = 0;
            $row->nb = $sug->nb;
            if ($sug->num_notice) {
                $q = "select niveau_biblio from notices where notice_id='".$sug->num_notice."' ";
                $r = pmb_mysql_query($q);
                if(pmb_mysql_num_rows($r)) {
                    $nb=pmb_mysql_result($r,0,0);
                }
            }
            switch($nb) {
                case 'a' :
                    $typ_lig = 1;
                    $notice = new selector_display_record_analysis($sug->num_notice,'');
                    $notice->getData();
                    $notice->responsabilites = get_notice_authors($sug->num_notice);
                    $notice->doHeader();
                    $row->libelle = $notice->titre;
                    if($notice->auteur1) {
                        $row->libelle .= "\n".$notice->auteur1;
                    }
                    if($notice->in_bull) {
                        $row->libelle .= "\n".$notice->in_bull;
                    }
                    $row->prix = $notice->prix;
                    break;
                case 'm' :
                    $typ_lig = 1;
                    $notice = new selector_display_record($sug->num_notice,'');
                    $notice->getData();
                    $notice->responsabilites = get_notice_authors($sug->num_notice);
                    $notice->doHeader();
                    $row->code = $notice->code;
                    $row->libelle = $notice->titre;
                    if($notice->auteur1) {
                        $row->libelle .= "\n".$notice->auteur1;
                    }
                    if ($notice->editeur1) {
                        $row->libelle .= "\n".$notice->editeur1;
                    }
                    if ($notice->editeur1 && $notice->ed_date) {
                        $row->libelle .= ", ".$notice->ed_date;
                    } elseif ($notice->ed_date){
                        $row->libelle .= $notice->ed_date;
                    }
                    if ($notice->collection) {
                        $row->libelle .= "\n".$notice->collection;
                    }
                    $row->prix = $notice->prix;
                    break;
                default :
                    $typ_lig = 0;
                    $row->code = htmlentities($sug->code, ENT_QUOTES, $charset);
                    $row->libelle= htmlentities($sug->titre,ENT_QUOTES,$charset);
                    if ($sug->auteur!="") $row->libelle.= "\n".htmlentities($sug->auteur,ENT_QUOTES,$charset);
                    if ($sug->editeur != "") $row->libelle.= "\n".htmlentities($sug->editeur,ENT_QUOTES,$charset);
                    $row->prix = htmlentities($sug->prix, ENT_QUOTES, $charset);
                    break;
            }
            $lines_form .= $this->get_line_form($i, $row);
        }
        $t = array(0 => $i, 1=> $lines_form);
        return $t;
    }
}