<?php
// +-------------------------------------------------+
// | 2002-2011 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: accounting_commande.class.php,v 1.1.4.3 2026/02/13 11:15:41 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

global $class_path;
require_once($class_path."/actes.class.php");

class accounting_commande extends actes {
	
    public $from_dev = false;
    public $from_sug = false;
    public $sugchk = null;
    
    protected function get_lien_dev($id_bibli, $id_dev=0) {
        if(!$this->id_acte && $this->duplicate_from_id_acte) {		//creation de commmande
            $id_dev = liens_actes::getDevis($this->duplicate_from_id_acte);
        }
        if ($id_dev) {
            $dev=new actes($id_dev);
            return "<a href=\"./acquisition.php?categ=ach&sub=devi&action=modif&id_bibli=".$id_bibli."&id_dev=".$id_dev."\">".$dev->numero."</a>";
        }
        return "";
    }
    
    public function get_form($id_bibli, $id_exer, $id_dev=0) {
        global $msg, $charset;
        global $modif_cde_form, $valid_cde_form;
        global $bt_enr, $bt_enr_valid, $bt_val, $bt_dup, $bt_rec, $bt_fac, $bt_audit, $bt_sol, $bt_arc, $bt_sup, $bt_imp, $bt_mail;
        global $sel_date_liv_mod, $sel_date_liv_fix, $sel_date_pay_mod;
        global $pmb_gestion_devise;
        global $pmb_type_audit;
        global $modif_cde_sel_typ_for_checked, $modif_cde_sel_rub_for_checked;
        
        //Recuperation etablissement
        $bibli = new entites($id_bibli);
        
        $fou = new entites($this->num_fournisseur);
        
        if(!$this->id_acte) {		//creation de commmande
            //Recuperation exercice
            $exer = new exercices($id_exer);
            $titre = htmlentities($msg['acquisition_cde_cre'], ENT_QUOTES, $charset);
        } else {
            $exer = new exercices($this->num_exercice);
            $titre = htmlentities($msg['acquisition_cde_mod'], ENT_QUOTES, $charset);
        }
        
        if(!$this->id_acte) {		//creation de commmande
            $form = $modif_cde_form;
            $statut = STA_ACT_AVA;
            $sel_statut = "<input type='hidden' id='statut' name='statut' value='".$statut."' />";
            $sel_statut.=htmlentities($msg['acquisition_cde_aval'], ENT_QUOTES, $charset);
            
            if ($this->from_dev) {
                if ($this->num_contact_fact) {
                    $coord_fac = new coordonnees($this->num_contact_fact);
                    $adr_fac = $coord_fac->get_formatted_address();
                } else {
                    $adr_fac = '';
                }
                if ($this->num_contact_livr) {
                    $coord_liv = new coordonnees($this->num_contact_livr);
                    $adr_liv = $coord_liv->get_formatted_address();
                } else {
                    $adr_liv = '';
                }
            } else {
                if ($this->num_contact_fact) {
                    $coord = new coordonnees($this->num_contact_fact);
                } else {
                    if (!$this->duplicate_from_id_acte) {
                        $coord_fac = entites::get_coordonnees($id_bibli, '1');
                        if (pmb_mysql_num_rows($coord_fac) != 0) {
                            $coord = pmb_mysql_fetch_object($coord_fac);
                            $this->num_contact_fact = $coord->id_contact;
                        }
                    }
                }
                if ($this->num_contact_fact) {
                    $adr_fac = coordonnees::get_formatted_address_form_coord($coord);
                } else {
                    $adr_fac = '';
                }
                if ($this->num_contact_livr) {
                    $coord = new coordonnees($this->num_contact_livr);
                } else {
                    if (!$this->duplicate_from_id_acte) {
                        $coord_liv = entites::get_coordonnees($id_bibli, '2');
                        if (pmb_mysql_num_rows($coord_liv) != 0) {
                            $coord = pmb_mysql_fetch_object($coord_liv);
                            $this->num_contact_livr = $coord->id_contact;
                        }
                    }
                }
                if ($this->num_contact_livr) {
                    $adr_liv = coordonnees::get_formatted_address_form_coord($coord);
                } else {
                    $this->num_contact_livr = $this->num_contact_fact;
                    $adr_liv = $adr_fac;
                }
            }
            
            $liens_liv = '';
            $liens_fac = '';
            $sel_date_pay = $sel_date_pay_mod;
            $date_pay = '';
            $date_pay_lib = $msg['parperso_nodate'];
            $num_pay = '';
            $sel_date_liv=$sel_date_liv_mod;
            $date_liv = '';
            $date_liv_lib = $msg['parperso_nodate'];
            if ($this->from_dev) {
                $devise = htmlentities($this->devise, ENT_QUOTES, $charset);
            } else {
                $devise = $pmb_gestion_devise;
            }
        } else {		//visualisation ou modification de commmande
            //elements communs
            if ($this->num_contact_fact) {
                $coord_fac = new coordonnees($this->num_contact_fact);
                $adr_fac = $coord_fac->get_formatted_address();
            } else {
                $adr_fac = '';
            }
            if ($this->num_contact_livr) {
                $coord_liv = new coordonnees($this->num_contact_livr);
                $adr_liv = $coord_liv->get_formatted_address();
            } else {
                $adr_liv = '';
            }
            $id_dev = liens_actes::getDevis($this->id_acte);
            
            $tab_liens = liens_actes::getChilds($this->id_acte);
            $liens_liv = '';
            $liens_fac = '';
            while(($row_liens = pmb_mysql_fetch_object($tab_liens))) {
                if( ($row_liens->type_acte) == TYP_ACT_LIV ) {
                    $liens_liv.= "<br /><a href=\"./acquisition.php?categ=ach&sub=livr&action=modif&id_bibli=".$id_bibli."&id_liv=".$row_liens->num_acte_lie."\">".$row_liens->numero."</a>";
                }
                if( ($row_liens->type_acte) == TYP_ACT_FAC ) {
                    $liens_fac.= "<br /><a href=\"./acquisition.php?categ=ach&sub=fact&action=modif&id_bibli=".$id_bibli."&id_fac=".$row_liens->num_acte_lie."\">".$row_liens->numero."</a>";
                }
            }
            $sel_date_pay = $sel_date_pay_mod;
            if ($this->date_paiement=='0000-00-00') {
                $date_pay = '';
                $date_pay_lib = $msg['parperso_nodate'];
            } else {
                $date_pay = $this->date_paiement;
                $date_pay_lib = formatdate($this->date_paiement);
            }
            $num_pay = htmlentities($this->num_paiement, ENT_QUOTES, $charset);
            
            $devise = htmlentities($this->devise, ENT_QUOTES, $charset);
            
            if ($this->statut != STA_ACT_AVA) {	//Commande non modifiable
                $form = $valid_cde_form;
                $statut = $this->statut;
                $st = ( ($this->statut) & ~(STA_ACT_FAC | STA_ACT_PAY | STA_ACT_ARC) );
                switch ($st) {
                    case STA_ACT_AVA :
                        $sel_statut = htmlentities($msg['acquisition_cde_aval'], ENT_QUOTES, $charset);
                        break;
                    case STA_ACT_ENC :
                        $sel_statut = htmlentities($msg['acquisition_cde_enc'], ENT_QUOTES, $charset);
                        break;
                    case STA_ACT_REC :
                        $sel_statut = htmlentities($msg['acquisition_cde_liv'], ENT_QUOTES, $charset);
                        break;
                    default :
                        $sel_statut = htmlentities($msg['acquisition_cde_enc'], ENT_QUOTES, $charset);
                        break;
                }
                if( ($this->statut & STA_ACT_PAY) == STA_ACT_PAY ) {
                    $statut_fac = htmlentities($msg['acquisition_act_pay'], ENT_QUOTES, $charset);
                } elseif( ($this->statut & STA_ACT_FAC) == STA_ACT_FAC ) {
                    $statut_fac = htmlentities($msg['acquisition_act_fac'], ENT_QUOTES, $charset);
                } else {
                    $statut_fac = '';
                }
                if ($statut_fac) {
                    $sel_statut.='&nbsp;/&nbsp;'.$statut_fac;
                }
                if(($this->statut & STA_ACT_ARC) == STA_ACT_ARC) {
                    $sel_statut = '<s>'.$sel_statut.'</s>';
                }
                $sel_statut.= "<input type='hidden' id='statut' name='statut' value='".$statut."' />";
                
                $sel_date_liv=$sel_date_liv_fix;
                if ($this->date_ech=='0000-00-00') {
                    $date_liv_lib = $msg['parperso_nodate'];
                } else {
                    $date_liv_lib = formatdate($this->date_ech);
                }
                
                if (($this->statut & STA_ACT_ARC) == STA_ACT_ARC ){	//Commande archivee
                    $bt_enr = '';
                    $bt_enr_valid = '';
                    $bt_val = '';
                    $bt_rec = '';
                    $bt_fac = '';
                    $bt_sol = '';
                    $bt_arc = '';
                } else {	//Commande non archivee
                    $bt_enr = '';
                    $bt_val = '';
                    
                    if (($this->statut & STA_ACT_REC) == STA_ACT_REC) {	//Commande soldee
                        $bt_rec = '';
                        $bt_sol = '';
                    }
                    if (($this->statut & STA_ACT_FAC) == STA_ACT_FAC) {	//Commande facturee
                        $bt_fac = '';
                    }
                    if (($this->statut & STA_ACT_REC) != STA_ACT_REC) { //Commande non soldee
                        $bt_arc = '';
                    }
                }
            } else {	//Commande modifiable
                $form = $modif_cde_form;
                
                $statut = STA_ACT_AVA;
                $sel_statut = "<input type='hidden' id='statut' name='statut' value='".$statut."' />";
                $sel_statut.=htmlentities($msg['acquisition_cde_aval'], ENT_QUOTES, $charset);
                
                $sel_date_liv = $sel_date_liv_mod;
                if ($this->date_ech=='0000-00-00') {
                    $date_liv = '';
                    $date_liv_lib = $msg['parperso_nodate'];
                } else {
                    $date_liv = $this->date_ech;
                    $date_liv_lib = formatdate($this->date_ech);
                }
                $bt_enr_valid = '';
                $bt_rec = '';
                $bt_fac = '';
                $bt_sol = '';
            }
        }
        if ($this->num_fournisseur) {
            $fou = new entites($this->num_fournisseur);
            $coord = entites::get_coordonnees($fou->id_entite, '1');
            if (pmb_mysql_num_rows($coord) != 0) {
                $coord = pmb_mysql_fetch_object($coord);
                $id_adr_fou = $coord->id_contact;
                $adr_fou = coordonnees::get_formatted_address_form_coord($coord);
            } else {
                $id_adr_fou = '0';
                $adr_fou = '';
            }
        } else {
            $id_adr_fou = '0';
            $adr_fou = '';
        }
        $lien_dev = $this->get_lien_dev($id_bibli, $id_dev);
        
        //complement formulaire
        $form = str_replace('<!-- sel_statut -->', $sel_statut, $form);
        $form = str_replace('<!-- sel_date_liv -->', $sel_date_liv, $form);
        $form = str_replace('<!-- sel_date_pay -->', $sel_date_pay, $form);
        $form = str_replace('<!-- bouton_enr -->', $bt_enr, $form);
        
        $form = str_replace('<!-- bouton_val -->', $bt_val, $form);
        if($this->id_acte) {		//modification de commmande
            $form = str_replace('<!-- bouton_enr_valid -->', $bt_enr_valid, $form);
            $form = str_replace('<!-- bouton_dup -->', $bt_dup, $form);
            $form = str_replace('<!-- bouton_rec -->', $bt_rec, $form);
            $form = str_replace('<!-- bouton_fac -->', $bt_fac, $form);
            $form = str_replace('<!-- bouton_imp -->', $bt_imp, $form);
            if ($pmb_type_audit) {
                $form = str_replace('<!-- bouton_audit -->', $bt_audit, $form);
            } else {
                $form = str_replace('<!-- bouton_audit -->', '', $form);
            }
            $form = str_replace('<!-- bouton_arc -->', $bt_arc, $form);
            $form = str_replace('<!-- bouton_sol -->', $bt_sol, $form);
            $form = str_replace('<!-- bouton_sup -->', $bt_sup, $form);
        } else {
            $form = str_replace('<!-- bouton_enr_valid -->', '', $form);
            $form = str_replace('<!-- bouton_dup -->', '', $form);
            $form = str_replace('<!-- bouton_rec -->', '', $form);
            $form = str_replace('<!-- bouton_fac -->', '', $form);
            $form = str_replace('<!-- bouton_imp -->', '', $form);
            $form = str_replace('<!-- bouton_audit -->', '', $form);
            $form = str_replace('<!-- bouton_arc -->', '', $form);
            $form = str_replace('<!-- bouton_sol -->', '', $form);
            $form = str_replace('<!-- bouton_sup -->', '', $form);
        }
        
        if ($this->from_dev) {
            $lignes = show_lig_cde_from_dev($id_dev);
        } elseif ($this->from_sug) {
            $lignes = show_lig_cde_from_sug($this->sugchk);
        } elseif ($this->duplicate_from_id_acte) {
            $lignes = show_lig_cde($this->duplicate_from_id_acte);
        } else {
            if(!$this->id_acte) {		//creation de commmande
                $lignes = show_lig_new_cde();
            } else {		//visualisation ou modification de commmande
                //elements communs
                if ($this->statut != STA_ACT_AVA) {	//Commande non modifiable
                    $lignes = show_lig_cde($this->id_acte, false);
                } else {	//Commande modifiable
                    $lignes = show_lig_cde($this->id_acte);
                }
            }
        }
        $form = str_replace('!!act_nblines!!', $lignes[0], $form);
        $form = str_replace('<!-- lignes -->', $lignes[1], $form);
        
        //selecteurs de type de produit et de budget pour affectation aux lignes cochees
        if ($this->statut == STA_ACT_AVA) {
            $form = str_replace('<!-- sel_type_for_checked -->', $modif_cde_sel_typ_for_checked, $form);
            $form = str_replace('<!-- sel_budget_for_checked -->', $modif_cde_sel_rub_for_checked, $form);
        }
        
        //Remplissage formulaire
        $form = str_replace('!!form_title!!', $titre, $form);
        $form = str_replace('!!id_bibli!!', $id_bibli, $form);
        $form = str_replace('!!lib_bibli!!', htmlentities($bibli->raison_sociale, ENT_QUOTES, $charset), $form);
        $form = str_replace('!!id_exer!!', $exer->id_exercice, $form);
        $form = str_replace('!!lib_exer!!', htmlentities($exer->libelle, ENT_QUOTES, $charset), $form);
        $form = str_replace('!!id_cde!!', $this->id_acte, $form);
        $form = str_replace('!!date_cre!!', formatdate(today()), $form);
        $form = str_replace('!!dat_def_lib!!', formatdate(today()), $form);
        $form = str_replace('!!dat_def!!', preg_replace('/-/', '', today()), $form);
        $form = str_replace('!!numero!!', htmlentities($this->numero, ENT_QUOTES, $charset), $form);
        $form = str_replace('!!nom_acte!!', htmlentities($this->nom_acte,ENT_QUOTES,$charset), $form);
        $form = str_replace('!!statut!!', $statut, $form);
        $form = str_replace('!!id_fou!!', $this->num_fournisseur, $form);
        $form = str_replace('!!lib_fou!!', htmlentities($fou->raison_sociale, ENT_QUOTES, $charset), $form);
        $form = str_replace('!!id_adr_fou!!', $id_adr_fou, $form);
        $form = str_replace('!!adr_fou!!', $adr_fou, $form);
        $form = str_replace('!!date_liv!!', $date_liv, $form);
        $form = str_replace('!!date_liv_lib!!', $date_liv_lib, $form);
        $form = str_replace('!!date_pay!!', $date_pay, $form);
        $form = str_replace('!!date_pay_lib!!', $date_pay_lib, $form);
        $form = str_replace('!!num_pay!!', $num_pay, $form);
        $form = str_replace('!!id_adr_liv!!', $this->num_contact_livr, $form);
        $form = str_replace('!!adr_liv!!', $adr_liv, $form);
        $form = str_replace('!!id_adr_fac!!', $this->num_contact_fact, $form);
        $form = str_replace('!!adr_fac!!', $adr_fac, $form);
        $form = str_replace('!!comment!!', htmlentities($this->commentaires, ENT_QUOTES, $charset), $form);
        $form = str_replace('!!comment_i!!', htmlentities($this->commentaires_i, ENT_QUOTES, $charset), $form);
        $form = str_replace('!!ref!!', htmlentities($this->reference, ENT_QUOTES, $charset), $form);
        $form = str_replace('!!id_dev!!', $id_dev, $form);
        $form = str_replace('!!devise!!', $devise, $form);
        $form = str_replace('!!lien_dev!!', $lien_dev, $form);
        $form = str_replace('!!liens_fac!!', $liens_fac, $form);
        $form = str_replace('!!liens_liv!!', $liens_liv, $form);
        
        if ($this->id_acte) {
            //Date validation
            if ($this->date_valid != '0000-00-00') {
                $form = str_replace('!!date_valid_label!!',htmlentities($msg['acquisition_cde_date_val'], ENT_QUOTES, $charset),$form);
                $form = str_replace('!!date_valid!!',formatdate($this->date_valid),$form);
            } else {
                $form = str_replace('!!date_valid_label!!','',$form);
                $form = str_replace('!!date_valid!!','',$form);
            }
        }
        return $form;
    }
}