<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: sudoc.class.php,v 1.9.12.2 2025/08/12 16:24:59 dbellamy Exp $
if (stristr($_SERVER['REQUEST_URI'], ".class.php")) {
    die("no access");
}

global $class_path, $base_path, $include_path;

require_once $class_path . "/connecteurs.class.php";
require_once $class_path . "/curl.class.php";
require_once $class_path . "/parametres_perso.class.php";
require_once $base_path . '/classes/iso2709.class.php';
require_once $include_path . "/parser.inc.php";

class sudoc extends connector
{

    //Variables internes pour la progression de la rcupration des notices
    
    // Supression ou non des notices dej existantes
    public $del_old;

    // Profil Amazon
    public $profile;

    // Tableau des critres UNIMARC / AMAZON
    public $match;

    // Site courant du profile (n)
    public $current_site;

    // Liste des indexes de recherche possibles pour le site
    public $searchindexes;

    // Numro de l'index de recherche de la classe
    public $current_searchindex;

    // Type de recherche (power ou simple)
    public $match_index;

    // Types de documents pour la conversino des notices
    public $types;

    // Y-a-t-il eu une erreur
    public $error;

    // Si oui, message correspondant
    public $error_message;

    /**
     *
     * {@inheritdoc}
     * @see connector::get_id()
     */
    public function get_id()
    {
        return "sudoc";
    }

    /**
     *
     * {@inheritdoc}
     * @see connector::enrichment_is_allow()
     */
    public function enrichment_is_allow()
    {
        return connector::ENRICHMENT_YES;
    }

    public function getEnrichmentHeader()
    {
        $header = array();
        $header[] = "<!-- Script d'enrichissement pour le Sudoc-->";
        return $header;
    }

    public function getTypeOfEnrichment($source_id)
    {
        $type['type'] = array(
            array(
                'code' => "sudoc",
                'label' => $this->msg['sudoc']
            )
        );
        $type['source_id'] = $source_id;
        return $type;
    }

    public function build_error()
    {
        $enrichment = array();
        $enrichment['sudoc']['content'] = $this->msg['sudoc_no_infos'];
        $enrichment['source_label'] = $this->msg['sudoc_enrichment_source'];
        return $enrichment;
    }

    public function getEnrichment($notice_id, $source_id, $type = "", $enrich_params = array())
    {
        global $charset;

        $enrichment = array();
        $this->noticeToEnrich = $notice_id;

        // rcupration du code sudoc (PPN) de la notice stock dans le champ perso de type "resolve" avec pour label "SUDOC"
        $mes_pp = new parametres_perso("notices");
        $mes_pp->get_values($notice_id);
        $values = $mes_pp->values;
		$ppn = '';
        foreach ($values as $field_id => $vals) {
            if ($mes_pp->t_fields[$field_id]['TYPE'] == "resolve") {
                $field_options = $mes_pp->t_fields[$field_id]['OPTIONS'][0];
                foreach ($field_options['RESOLVE'] as $resolve) {
                    if (strtoupper($resolve['LABEL']) == "SUDOC") {
                        $infos = explode('|', $vals[0]);
                        $ppn = $infos[0];
                    }
                }
            }
        }
        if ($ppn == "") {
            return $this->build_error();
        }
        $url = "carmin.sudoc.abes.fr";
        $port = "210";
        $base = "abes-z39-public";
        $format = "unimarc";

        $term = "@attr 1=12 @attr 2=3 \"$ppn\" ";
		$id = yaz_connect("$url:$port/$base", array("piggyback" => false));
        yaz_range($id, 1, 1);
        yaz_syntax($id, strtolower($format));
        yaz_search($id, "rpn", $term);

        $options = array("timeout" => 45);

        // Augmente le timeout du serveur mysql, pour etre sur que le socket dure assez longtemps pour aller jusqu'a l' ajout des resultats dans la base.
        $sql = "set wait_timeout = 120";
        pmb_mysql_query($sql);

        yaz_wait($options);

        $error = yaz_error($id);
        if (! empty($error)) {
            yaz_close($id);
            return $this->build_error();
        } else {
            $hits = yaz_hits($id);
            $hits = intval($hits);
            if ($hits) {
                $rec = yaz_record($id, 1, "raw");
                $record = new iso2709_record($rec);
                if (! $record->valid()) {
                    yaz_close($id);
                    return $this->build_error();
                }

                $lines = "";

                $indicateur = array();

                $cle_list = array();
                for ($i = 0; $i < count($record->inner_directory); $i ++) {
                    $cle = $record->inner_directory[$i]['label'];

                    $indicateur[$cle][] = substr($record->inner_data[$i]['content'], 0, 2);

                    $field_array = $record->get_subfield_array_array($cle);

                    $line = "";
                    if (! $cle_list[$cle]) {
                        foreach ($field_array as $field) {
                            $line .= $cle . "  ";
                            foreach ($field as $ss_field) {
                                $line .= "$" . $ss_field["label"] . $ss_field["content"];
                            }
                            $line .= "<br>";
                        }
                    }
                    $cle_list[$cle] = 1;
                    $lines .= $line;
                }
                if ($lines == "") {
                    yaz_close($id);
                    return $this->build_error();
                }
            } else {
                yaz_close($id);
                return $this->build_error();
            }
        }
        yaz_close($id);

        $enrichment['sudoc']['content'] = $lines;
        $enrichment['source_label'] = $this->msg['sudoc_enrichment_source'];
        return $enrichment;
    }
}
