<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version='1.0'
	xmlns:xsl='http://www.w3.org/1999/XSL/Transform'
	xmlns:marclist="http://www.loc.gov/MARC21/slim"
	xmlns:mxc="info:lc/xmlns/marcxchange-v2"
	xmlns:exsl="http://exslt.org/common" extension-element-prefixes="exsl">

	<xsl:output method="xml" indent='yes' />

	<xsl:template match="/record/mxc:record">
		<unimarc>
			<notice>
				<xsl:element name="rs">*</xsl:element>
				<xsl:element name="ru">*</xsl:element>
				<xsl:element name="el">1</xsl:element>
				<xsl:element name="bl">m</xsl:element>
				<xsl:element name="hl">0</xsl:element>
				<xsl:element name="dt">a</xsl:element>
				<xsl:call-template name="record_identifier" />
				<xsl:call-template name="identifier" />
				<xsl:call-template name="langue" />
				<xsl:call-template name="titre" />
				<xsl:call-template name="mention" />
				<xsl:call-template name="editeur" />
				<xsl:call-template name="physical_description" />
				<xsl:call-template name="series" />
				<xsl:call-template name="contens_note" />
				<xsl:call-template name="summary" />
				<xsl:call-template name="collection" />
				<xsl:call-template name="sous_collection" />
				<xsl:call-template name="num_serie" />
				<xsl:call-template name="descripteurs" />
				<xsl:call-template name="mots_cles" />
				<xsl:call-template name="dewey" />
				<xsl:call-template name="autorite" />
				<xsl:call-template name="autorite_701" />
				<xsl:call-template name="autorite_710" />
				<xsl:call-template name="autorite_711" />
				<xsl:call-template name="electronic_location" />
			</notice>
		</unimarc>
	</xsl:template>

	<xsl:template name="record_identifier">
		<xsl:if test="mxc:controlfield">
			<f c="001">
				<xsl:value-of select="mxc:controlfield" />
			</f>
		</xsl:if>
	</xsl:template>


	<!-- fonction identifier: rcupre ISBN/EAN et Prix -->
	<xsl:template name="identifier">
		<xsl:for-each select="./mxc:datafield[@tag='010']">
			<f c="010">
				<xsl:if test="./mxc:subfield[@code='a']">
					<!-- ISBN 010 a -->
					<s c="a">
						<xsl:choose>
							<xsl:when test="contains(./mxc:subfield[@code='a'],'(')">
								<xsl:value-of
									select="normalize-space(substring-before(./mxc:subfield[@code='a'],'('))" />
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of
									select="normalize-space(./mxc:subfield[@code='a'])" />
							</xsl:otherwise>
						</xsl:choose>
					</s>
				</xsl:if>
				<xsl:if test="./mxc:subfield[@code='d']">
					<!-- Prix: 010 d -->
					<s c="d">
						<xsl:value-of select="./mxc:subfield[@code='d']" />
					</s>
				</xsl:if>
			</f>
		</xsl:for-each>
		<xsl:for-each select="./mxc:datafield[@tag='073']">
			<f c="073">
				<xsl:if test="./mxc:subfield[@code='a']">
					<!-- EAN 073 a -->
					<s c="a">
						<xsl:choose>
							<xsl:when test="contains(./mxc:subfield[@code='a'],'(')">
								<xsl:value-of
									select="normalize-space(substring-before(./mxc:subfield[@code='a'],'('))" />
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of
									select="normalize-space(./mxc:subfield[@code='a'])" />
							</xsl:otherwise>
						</xsl:choose>
					</s>
				</xsl:if>
			</f>
		</xsl:for-each>
	</xsl:template>

	<!-- fonction langue rcupre langue et langue originale -->
	<xsl:template name="langue">
		<xsl:choose>
			<xsl:when test="./mxc:datafield[@tag='101']">
				<xsl:element name="f">
					<xsl:attribute name="c">101</xsl:attribute>
					<xsl:attribute name="ind"><xsl:value-of
						select="./mxc:datafield[@tag='101']/@ind" /></xsl:attribute>
					<xsl:if
						test="./mxc:datafield[@tag='101']/mxc:subfield[@code='a']">
						<!-- langue 101 -->
						<s c="a">
							<xsl:value-of
								select="./mxc:datafield[@tag='101']/mxc:subfield[@code='a']" />
						</s>
					</xsl:if>
					<xsl:if
						test="./mxc:datafield[@tag='101']/mxc:subfield[@code='c']">
						<!-- langue originale: 101 -->
						<s c="c">
							<xsl:value-of
								select="./mxc:datafield[@tag='101']/mxc:subfield[@code='c']" />
						</s>
					</xsl:if>
				</xsl:element>
			</xsl:when>
			<xsl:otherwise>
<!-- 				<xsl:if test="./mxc:datafield[@tag='008']"> -->
<!-- 					<xsl:element name="f"> -->
<!-- 						<xsl:attribute name="c">101</xsl:attribute> -->
<!-- 						<xsl:attribute name="ind">  </xsl:attribute> -->
<!-- 						<s c="a"> -->
<!-- 							<xsl:value-of -->
<!-- 								select="substring(./mxc:datafield[@tag='008'],36,3)" /> -->
<!-- 						</s> -->
<!-- 					</xsl:element> -->
<!-- 				</xsl:if> -->
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>



	<!-- fonction titre -->
	<xsl:template name="titre">
		<xsl:if test="./mxc:datafield[@tag='200']">
			<xsl:element name="f">
				<xsl:attribute name="c">200</xsl:attribute>
				<xsl:attribute name="ind"><xsl:value-of
					select="./mxc:datafield[@tag='200']/@ind" /></xsl:attribute>
				<!-- Title Proper a -->
				<s c="a">
					<xsl:value-of
						select="./mxc:datafield[@tag='200']/mxc:subfield[@code='a']" />
				</s>
				<xsl:if
					test="./mxc:datafield[@tag='200']/mxc:subfield[@code='c']">
					<s c="c">
						<xsl:value-of
							select="./mxc:datafield[@tag='200']/mxc:subfield[@code='c']" />
					</s>
				</xsl:if>
				<!-- Medium -->
				<xsl:for-each
					select="./mxc:datafield[@tag='200']/mxc:subfield[@code='b']">
					<s c="b">
						<xsl:value-of select="." />
					</s>
				</xsl:for-each>
				<xsl:if
					test="./mxc:datafield[@tag='200']/mxc:subfield[@code='e']">
					<s c="e">
						<xsl:value-of
							select="./mxc:datafield[@tag='200']/mxc:subfield[@code='e']" />
					</s>
				</xsl:if>
				<xsl:if
					test="./mxc:datafield[@tag='200']/mxc:subfield[@code='f']">
					<s c="f">
						<xsl:value-of
							select="./mxc:datafield[@tag='200']/mxc:subfield[@code='f']" />
					</s>
				</xsl:if>
				<xsl:if
					test="./mxc:datafield[@tag='200']/mxc:subfield[@code='g']">
					<s c="g">
						<xsl:value-of
							select="./mxc:datafield[@tag='200']/mxc:subfield[@code='g']" />
					</s>
				</xsl:if>
				<xsl:if
					test="./mxc:datafield[@tag='200']/mxc:subfield[@code='h']">
					<s c="h">
						<xsl:value-of
							select="./mxc:datafield[@tag='200']/mxc:subfield[@code='h']" />
					</s>
				</xsl:if>
				<xsl:if
					test="./mxc:datafield[@tag='200']/mxc:subfield[@code='i']">
					<s c="i">
						<xsl:value-of
							select="./mxc:datafield[@tag='200']/mxc:subfield[@code='i']" />
					</s>
				</xsl:if>
			</xsl:element>
		</xsl:if>
	</xsl:template>


	<!-- fonction mention d'dition -->
	<xsl:template name="mention">
		<xsl:for-each select="./mxc:datafield[@tag='205']">
			<f c="205" ind='  '>
				<xsl:if test="./mxc:subfield[@code='a']">
					<s c="a">
						<xsl:value-of select="./mxc:subfield[@code='a']" />
					</s>
				</xsl:if>
				<xsl:if test="./mxc:subfield[@code='b']">
					<s c="b">
						<xsl:value-of select="./mxc:subfield[@code='b']" />
					</s>
				</xsl:if>
			</f>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="editeur">
		<xsl:if test="./mxc:datafield[@tag='210']">
			<f c="210" ind='  '>
				<!-- Place of public./distr -->
				<xsl:for-each
					select="./mxc:datafield[@tag='210']/mxc:subfield[@code='a']">
					<s c="a">
						<xsl:value-of select="." />
					</s>
				</xsl:for-each>
				<!-- Name of publisher/dist. -->
				<xsl:for-each
					select="./mxc:datafield[@tag='210']/mxc:subfield[@code='c']">
					<s c="c">
						<xsl:value-of select="." />
					</s>
				</xsl:for-each>
				<!-- Date of publication -->
				<xsl:for-each
					select="./mxc:datafield[@tag='210']/mxc:subfield[@code='d']">
					<s c="d">
						<xsl:value-of select="." />
					</s>
				</xsl:for-each>

				<!-- Place of manufacture -->
				<xsl:for-each
					select="./mxc:datafield[@tag='210']/mxc:subfield[@code='e']">
					<s c="e">
						<xsl:value-of select="." />
					</s>
				</xsl:for-each>
				<!-- Name of manufacturer -->
				<xsl:for-each
					select="./mxc:datafield[@tag='210']/mxc:subfield[@code='g']">
					<s c="g">
						<xsl:value-of select="." />
					</s>
				</xsl:for-each>
				<!-- Date of manufacture -->
				<xsl:for-each
					select="./mxc:datafield[@tag='210']/mxc:subfield[@code='h']">
					<s c="h">
						<xsl:value-of select="." />
					</s>
				</xsl:for-each>
			</f>
		</xsl:if>
	</xsl:template>

	<xsl:template name="physical_description">
		<xsl:for-each select="./mxc:datafield[@tag='215']">
			<f c="215" ind='  '>
				<xsl:for-each select="./mxc:subfield[@code='a']">
					<s c="a">
						<xsl:value-of select="." />
					</s>
				</xsl:for-each>
				<xsl:for-each select="./mxc:subfield[@code='c']">
					<s c="c">
						<xsl:value-of select="." />
					</s>
				</xsl:for-each>
				<xsl:for-each select="./mxc:subfield[@code='d']">
					<s c="d">
						<xsl:value-of select="." />
					</s>
				</xsl:for-each>
				<xsl:for-each select="./mxc:subfield[@code='e']">
					<s c="e">
						<xsl:value-of select="." />
					</s>
				</xsl:for-each>
			</f>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="series">
		<xsl:for-each select="./mxc:datafield[@tag='225']">
			<xsl:element name="f">
				<xsl:attribute name="c">225</xsl:attribute>
				<xsl:attribute name="ind"><xsl:text>2 </xsl:text></xsl:attribute>
				<xsl:for-each select="./mxc:subfield[@code='a']">
					<s c="a">
						<xsl:value-of select="." />
					</s>
				</xsl:for-each>
				<xsl:for-each select="./mxc:subfield[@code='v']">
					<s c="v">
						<xsl:value-of select="." />
					</s>
				</xsl:for-each>
				<xsl:for-each select="./mxc:subfield[@code='x']">
					<s c="x">
						<xsl:value-of select="." />
					</s>
				</xsl:for-each>
			</xsl:element>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="contens_note">
		<xsl:if test="./mxc:datafield[@tag='327']">
			<xsl:element name="f">
				<xsl:attribute name="c">327</xsl:attribute>
				<xsl:if test="./mxc:datafield[@tag='327']/@ind=0">
					<xsl:attribute name="ind"><xsl:text> 1</xsl:text></xsl:attribute>
				</xsl:if>
				<xsl:if test="./mxc:datafield[@tag='327']/@ind=1">
					<xsl:attribute name="ind"><xsl:text> 0</xsl:text></xsl:attribute>
				</xsl:if>
				<xsl:if
					test="./mxc:datafield[@tag='327']/mxc:subfield[@code='a']">
					<s c="a">
						<xsl:value-of
							select="./mxc:datafield[@tag='327']/mxc:subfield[@code='a']" />
					</s>
				</xsl:if>
			</xsl:element>
		</xsl:if>
	</xsl:template>

	<xsl:template name="summary">
		<xsl:for-each select="./mxc:datafield[@tag='330']">
			<f c="330" ind='  '>
				<xsl:if test="./mxc:subfield[@code='a']">
					<s c="a">
						<xsl:value-of select="./mxc:subfield[@code='a']" />
					</s>
				</xsl:if>
			</f>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="collection">
		<xsl:for-each select="./mxc:datafield[@tag='410']">
			<xsl:element name="f">
				<xsl:attribute name="c">410</xsl:attribute>
				<xsl:if test="./@ind='1 '">
					<xsl:attribute name="ind"><xsl:text> 0</xsl:text></xsl:attribute>
				</xsl:if>
				<xsl:if test="./@ind='0 '">
					<xsl:attribute name="ind"><xsl:text> 1</xsl:text></xsl:attribute>
				</xsl:if>
				<xsl:if test="./mxc:subfield[@code='1']">
					<s c="1">
						<xsl:value-of select="./mxc:subfield[@code='1']" />
					</s>
				</xsl:if>
				<xsl:if test="./mxc:subfield[@code='t']">
					<s c="t">
						<xsl:value-of select="./mxc:subfield[@code='t']" />
					</s>
				</xsl:if>
				<xsl:for-each select="./mxc:subfield[@code='v']">
					<s c="v">
						<xsl:value-of select="." />
					</s>
				</xsl:for-each>
				<!-- ISSN of linked record -->
				<xsl:if test="./mxc:subfield[@code='x']">
					<s c="x">
						<xsl:value-of select="./mxc:subfield[@code='x']" />
					</s>
				</xsl:if>
				<xsl:if test="./mxc:subfield[@code='y']">
					<s c="y">
						<xsl:value-of select="./mxc:subfield[@code='y']" />
					</s>
				</xsl:if>
			</xsl:element>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="sous_collection">
		<xsl:for-each select="./mxc:datafield[@tag='411']">
			<xsl:element name="f">
				<xsl:attribute name="c">411</xsl:attribute>
				<xsl:if test="./@ind='1 '">
					<xsl:attribute name="ind"><xsl:text> 0</xsl:text></xsl:attribute>
				</xsl:if>
				<xsl:if test="./@ind='0 '">
					<xsl:attribute name="ind"><xsl:text> 1</xsl:text></xsl:attribute>
				</xsl:if>
				<xsl:if test="./mxc:subfield[@code='1']">
					<s c="1">
						<xsl:value-of select="./mxc:subfield[@code='1']" />
					</s>
				</xsl:if>
				<xsl:if test="./mxc:subfield[@code='t']">
					<s c="t">
						<xsl:value-of select="./mxc:subfield[@code='t']" />
					</s>
				</xsl:if>
				<xsl:for-each select="./mxc:subfield[@code='v']">
					<s c="v">
						<xsl:value-of select="." />
					</s>
				</xsl:for-each>
				<xsl:if test="./mxc:subfield[@code='x']">
					<s c="x">
						<xsl:value-of select="./mxc:subfield[@code='x']" />
					</s>
				</xsl:if>
				<xsl:if test="./mxc:subfield[@code='y']">
					<s c="y">
						<xsl:value-of select="./mxc:subfield[@code='y']" />
					</s>
				</xsl:if>
			</xsl:element>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="num_serie">
		<xsl:for-each select="./mxc:datafield[@tag='461']">
			<xsl:element name="f">
				<xsl:attribute name="c">461</xsl:attribute>
				<xsl:if test="./@ind='1 '">
					<xsl:attribute name="ind"><xsl:text> 0</xsl:text></xsl:attribute>
				</xsl:if>
				<xsl:if test="./@ind='0 '">
					<xsl:attribute name="ind"><xsl:text> 1</xsl:text></xsl:attribute>
				</xsl:if>
				<xsl:if test="./mxc:subfield[@code='1']">
					<s c="1">
						<xsl:value-of select="./mxc:subfield[@code='1']" />
					</s>
				</xsl:if>
				<!-- Title -->
				<xsl:if test="./mxc:subfield[@code='t']">
					<s c="t">
						<xsl:value-of select="./mxc:subfield[@code='t']" />
					</s>
				</xsl:if>
				<!-- Volume designation -->
				<xsl:for-each select="./mxc:subfield[@code='v']">
					<s c="v">
						<xsl:value-of select="." />
					</s>
				</xsl:for-each>
				<!-- ISSN of linked record -->
				<xsl:if test="./mxc:subfield[@code='x']">
					<s c="x">
						<xsl:value-of select="./mxc:subfield[@code='x']" />
					</s>
				</xsl:if>
				<xsl:if test="./mxc:subfield[@code='y']">
					<s c="y">
						<xsl:value-of select="./mxc:subfield[@code='y']" />
					</s>
				</xsl:if>
			</xsl:element>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="descripteurs">
		<xsl:for-each select="./mxc:datafield[@tag='606']">
			<xsl:element name="f">
				<xsl:attribute name="c">606</xsl:attribute>
				<xsl:attribute name="ind">  </xsl:attribute>
				<xsl:for-each select="./mxc:subfield[@code='a']">
					<s c="a">
						<xsl:value-of select="." />
					</s>
				</xsl:for-each>
				<xsl:for-each select="./mxc:subfield[@code='x']">
					<s c="x">
						<xsl:value-of select="." />
					</s>
				</xsl:for-each>
				<xsl:for-each select="./mxc:subfield[@code='y']">
					<s c="y">
						<xsl:value-of select="." />
					</s>
				</xsl:for-each>
				<xsl:for-each select="./mxc:subfield[@code='z']">
					<s c="z">
						<xsl:value-of select="." />
					</s>
				</xsl:for-each>
			</xsl:element>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="mots_cles">
		<xsl:for-each select="./mxc:datafield[@tag='610']">
			<xsl:element name="f">
				<xsl:attribute name="c">610</xsl:attribute>
				<xsl:attribute name="ind"><xsl:value-of
					select="./@ind" /></xsl:attribute>
				<xsl:for-each select="./mxc:subfield[@code='a']">
					<s c="a">
						<xsl:value-of select="." />
					</s>
				</xsl:for-each>
			</xsl:element>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="dewey">
		<xsl:for-each select="./mxc:datafield[@tag='676']">
			<xsl:element name="f">
				<xsl:attribute name="c">676</xsl:attribute>
				<xsl:attribute name="ind">  </xsl:attribute>
				<xsl:if test="./mxc:subfield[@code='a']">
					<s c="a">
						<xsl:value-of select="./mxc:subfield[@code='a']" />
					</s>
				</xsl:if>
				<xsl:if test="./mxc:subfield[@code='v']">
					<s c="v">
						<xsl:value-of select="./mxc:subfield[@code='v']" />
					</s>
				</xsl:if>
			</xsl:element>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="autorite">
		<xsl:for-each select="./mxc:datafield[@tag='700']">
			<xsl:element name="f">
				<xsl:attribute name="c">700</xsl:attribute>
				<xsl:if test="./@ind='0 '">
					<xsl:attribute name="ind"><xsl:text> 0</xsl:text></xsl:attribute>
				</xsl:if>
				<xsl:if test="./@ind='1 '">
					<xsl:attribute name="ind"><xsl:text> 1</xsl:text></xsl:attribute>
				</xsl:if>
				<xsl:if test="./mxc:subfield[@code='a']">
					<s c="a">
						<xsl:value-of select="./mxc:subfield[@code='a']" />
					</s>
				</xsl:if>
				<xsl:for-each select="./mxc:subfield[@code='c']">
					<s c="c">
						<xsl:value-of select="." />
					</s>
				</xsl:for-each>
				<xsl:if test="./mxc:subfield[@code='g']">
					<s c="g">
						<xsl:value-of select="./mxc:subfield[@code='g']" />
					</s>
				</xsl:if>
				<xsl:if test="./mxc:subfield[@code='p']">
					<s c="p">
						<xsl:value-of select="./mxc:subfield[@code='p']" />
					</s>
				</xsl:if>
				<!-- Relator cod -->
				<xsl:for-each select="./mxc:subfield[@code='4']">
					<s c="4">
						<xsl:value-of select="." />
					</s>
				</xsl:for-each>
			</xsl:element>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="autorite_701">
		<xsl:for-each select="./mxc:datafield[@tag='701']">
			<xsl:element name="f">
				<xsl:attribute name="c">701</xsl:attribute>
				<xsl:if test="./@ind='0 '">
					<xsl:attribute name="ind"><xsl:text> 0</xsl:text></xsl:attribute>
				</xsl:if>
				<xsl:if test="./@ind='1 '">
					<xsl:attribute name="ind"><xsl:text> 1</xsl:text></xsl:attribute>
				</xsl:if>
				<xsl:if test="./mxc:subfield[@code='a']">
					<s c="a">
						<xsl:value-of select="./mxc:subfield[@code='a']" />
					</s>
				</xsl:if>
				<xsl:for-each select="./mxc:subfield[@code='c']">
					<s c="c">
						<xsl:value-of select="." />
					</s>
				</xsl:for-each>
				<xsl:if test="./mxc:subfield[@code='d']">
					<s c="d">
						<xsl:value-of select="./mxc:subfield[@code='d']" />
					</s>
				</xsl:if>
				<xsl:if test="./mxc:subfield[@code='f']">
					<s c="f">
						<xsl:value-of select="./mxc:subfield[@code='f']" />
					</s>
				</xsl:if>
				<xsl:if test="./mxc:subfield[@code='g']">
					<s c="g">
						<xsl:value-of select="./mxc:subfield[@code='g']" />
					</s>
				</xsl:if>
				<xsl:if test="./mxc:subfield[@code='p']">
					<s c="p">
						<xsl:value-of select="./mxc:subfield[@code='p']" />
					</s>
				</xsl:if>
				<xsl:for-each select="./mxc:subfield[@code='4']">
					<s c="4">
						<xsl:value-of select="." />
					</s>
				</xsl:for-each>
			</xsl:element>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="autorite_710">
		<xsl:for-each select="./mxc:datafield[@tag='710']">
			<xsl:element name="f">
				<xsl:attribute name="c">710</xsl:attribute>
				<xsl:if test="./@ind='0 '">
					<xsl:attribute name="ind"><xsl:text> 0</xsl:text></xsl:attribute>
				</xsl:if>
				<xsl:if test="./@ind='1 '">
					<xsl:attribute name="ind"><xsl:text> 1</xsl:text></xsl:attribute>
				</xsl:if>
				<xsl:if test="./@ind='2 '">
					<xsl:attribute name="ind"><xsl:text> 2</xsl:text></xsl:attribute>
				</xsl:if>
				<xsl:if test="./mxc:subfield[@code='a']">
					<s c="a">
						<xsl:value-of select="./mxc:subfield[@code='a']" />
					</s>
				</xsl:if>
				<xsl:for-each select="./mxc:subfield[@code='b']">
					<s c="b">
						<xsl:value-of select="." />
					</s>
				</xsl:for-each>
<!-- 				<xsl:for-each select="./mxc:subfield[@code='e']"> -->
<!-- 					<s c="b"> -->
<!-- 						<xsl:value-of select="." /> -->
<!-- 					</s> -->
<!-- 				</xsl:for-each> -->
				<xsl:if test="./mxc:subfield[@code='d']">
					<s c="d">
						<xsl:value-of select="./mxc:subfield[@code='d']" />
					</s>
				</xsl:if>
				<xsl:if test="./mxc:subfield[@code='e']">
					<s c="e">
						<xsl:value-of select="./mxc:subfield[@code='e']" />
					</s>
				</xsl:if>
				<xsl:if test="./mxc:subfield[@code='f']">
					<s c="f">
						<xsl:value-of select="./mxc:subfield[@code='f']" />
					</s>
				</xsl:if>
				<xsl:if test="./mxc:subfield[@code='p']">
					<s c="p">
						<xsl:value-of select="./mxc:subfield[@code='p']" />
					</s>
				</xsl:if>
				<xsl:for-each select="./mxc:subfield[@code='4']">
					<s c="4">
						<xsl:value-of select="." />
					</s>
				</xsl:for-each>
			</xsl:element>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="autorite_711">
		<xsl:for-each select="./mxc:datafield[@tag='711']">
			<xsl:element name="f">
				<xsl:attribute name="c">711</xsl:attribute>
				<xsl:if test="./@ind='0 '">
					<xsl:attribute name="ind"><xsl:text> 0</xsl:text></xsl:attribute>
				</xsl:if>
				<xsl:if test="./@ind='1 '">
					<xsl:attribute name="ind"><xsl:text> 1</xsl:text></xsl:attribute>
				</xsl:if>
				<xsl:if test="./@ind='2 '">
					<xsl:attribute name="ind"><xsl:text> 2</xsl:text></xsl:attribute>
				</xsl:if>
				<xsl:if test="./mxc:subfield[@code='a']">
					<s c="a">
						<xsl:value-of select="./mxc:subfield[@code='a']" />
					</s>
				</xsl:if>
				<xsl:for-each select="./mxc:subfield[@code='b']">
					<s c="b">
						<xsl:value-of select="." />
					</s>
				</xsl:for-each>
<!-- 				<xsl:for-each select="./mxc:subfield[@code='e']"> -->
<!-- 					<s c="b"> -->
<!-- 						<xsl:value-of select="." /> -->
<!-- 					</s> -->
<!-- 				</xsl:for-each> -->
				<xsl:if test="./mxc:subfield[@code='d']">
					<s c="d">
						<xsl:value-of select="./mxc:subfield[@code='d']" />
					</s>
				</xsl:if>
				<xsl:if test="./mxc:subfield[@code='e']">
					<s c="e">
						<xsl:value-of select="./mxc:subfield[@code='e']" />
					</s>
				</xsl:if>
				<xsl:if test="./mxc:subfield[@code='f']">
					<s c="f">
						<xsl:value-of select="./mxc:subfield[@code='f']" />
					</s>
				</xsl:if>
				<xsl:if test="./mxc:subfield[@code='p']">
					<s c="p">
						<xsl:value-of select="./mxc:subfield[@code='p']" />
					</s>
				</xsl:if>
				<xsl:for-each select="./mxc:subfield[@code='4']">
					<s c="4">
						<xsl:value-of select="." />
					</s>
				</xsl:for-each>
			</xsl:element>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="electronic_location">
		<xsl:for-each select="./mxc:datafield[@tag='856']">
			<xsl:element name="f">
				<xsl:attribute name="c">856</xsl:attribute>
				<xsl:attribute name="ind"><xsl:value-of
					select="./@ind" /></xsl:attribute>
				<xsl:for-each select="./mxc:subfield">
					<xsl:element name="s">
						<xsl:attribute name="c"><xsl:value-of
							select="./@code" /></xsl:attribute>
						<xsl:value-of select="." />
					</xsl:element>
				</xsl:for-each>
			</xsl:element>
		</xsl:for-each>
	</xsl:template>

</xsl:stylesheet>
