<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: selector_display_frais.class.php,v 1.1.2.2 2025/11/05 15:17:33 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

//Classe d'affichage des frais dans un selecteur
class selector_display_frais extends selector_display {
    
    public $id_frais=0;
    public $libelle='';
    public $lib_montant='';
    public $taux_tva = '0.00';
    
    public $typ_lig = 3; //type de ligne

    // constructeur
    public function __construct($id, $base_url, $form_checker='') {
        parent::__construct($id, $base_url, $form_checker);
        $this->id_frais = intval($id);
    }
    
    // creation header
    public function doHeader() {
        global $charset;
        
        $aff = htmlentities($this->libelle, ENT_QUOTES, $charset);
        if ($this->action) {
            $aff= str_replace('!!display!!', "<b>$aff</b>", $this->action);
        }
        if(trim($this->form_checker)){
            $this->result = "<span class='acq_sel_display_middle'>".$this->getCheckbox().$aff."</span>";
        }else{
            $this->result = $aff;
        }
    }
    
    public function doForm(){
        global $acquisition_gestion_tva, $pmb_gestion_devise;
        
        if(!$this->id_frais) return;
        
        $frais = new frais($this->id_frais);
        $this->libelle = $frais->libelle;
        $this->prix = $frais->montant;
        if ($acquisition_gestion_tva && $frais->num_tva_achat) {
            $tva = new tva_achats($frais->num_tva_achat);
            $this->taux_tva = $tva->taux_tva;
        }
        $this->lib_montant = $this->prix.'&nbsp;'.$pmb_gestion_devise;
        parent::doForm();
    }
    
    public function finalize() {
        if ($this->action) {
            if (count($this->action_values)) {
                foreach($this->action_values as $v) {
                    $this->result = str_replace("!!$v!!", addslashes($this->$v), $this->result);
                }
            }
        }
    }
    
    public function getNomActe() {
        return $this->libelle;
    }
}
