<?php
// +-------------------------------------------------+
//  2002-2012 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: cms_module_common_datasource_animations_list.class.php,v 1.2.14.2 2025/08/01 08:14:08 tgoureau Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

class cms_module_common_datasource_animations_list extends cms_module_common_datasource_list
{

	public function __construct($id = 0)
	{
		parent::__construct($id);
		$this->limitable = true;
		$this->sortable = true;
	}

	/*
	 * On dfinit les critres de tri utilisables pour cette source de donnes
	 */
	protected function get_sort_criterias()
	{
		return array(
			'id_animation',
			'name',
			'start_date',
			'end_date'
		);
	}

	protected function sort_animations($animations)
	{
		if (empty($animations) || !is_array($animations)) {
			return false;
		}

		$animations = array_map('intval', $animations);
		$query = "SELECT DISTINCT anim_animations.id_animation FROM anim_animations JOIN anim_events ON anim_events.id_event = anim_animations.num_event
			WHERE anim_animations.id_animation IN ('" . implode("','", $animations) . "')";

		if ((!empty($this->parameters['sort_by'])) && (!empty($this->parameters['sort_order']))) {
			$query .= " ORDER BY " . $this->parameters['sort_by'] . " " . $this->parameters['sort_order'];
		}

		if (!empty($this->parameters['nb_max_elements'])) {
			$query .= " LIMIT " . (int) $this->parameters['nb_max_elements'];
		}

		$result = pmb_mysql_query($query);
		$return = array();
		if (pmb_mysql_num_rows($result)) {
			$return['title'] = "Liste d'animations";
			while ($row = pmb_mysql_fetch_object($result)) {
				$return['animations'][] = $row->id_animation;
			}
		}

		return $return;
	}


	public function get_form()
	{

		if (!isset($this->parameters['old_event'])) {
			$this->parameters['old_event'] = true;
		}
		if (!isset($this->parameters['futur_event'])) {
			$this->parameters['futur_event'] = true;
		}

		$form = parent::get_form();
		$form .= "
		<div class='row'>
			<div class='colonne3'>
				<label for='" . $this->get_form_value_name('old_event') . "'>" . $this->format_text($this->msg['cms_module_common_datasource_animations_list_old_events']) . "</label>
			</div>
			<div class='colonne-suite'>
				<input type='checkbox' name='" . $this->get_form_value_name('old_event') . "' " . ($this->parameters['old_event'] == true ? 'checked' : '') . ">
			</div>
		</div>
		<div class='row'>
			<div class='colonne3'>
				<label for='" . $this->get_form_value_name('futur_event') . "'>" . $this->format_text($this->msg['cms_module_common_datasource_animations_list_futur_events']) . "</label>
			</div>
			<div class='colonne-suite'>
				<input type='checkbox' name='" . $this->get_form_value_name('futur_event') . "' " . ($this->parameters['futur_event'] == true ? 'checked' : '') . ">
			</div>
		</div>";

		return $form;
	}

	public function save_form()
	{
		$old_event_active = $this->get_value_from_form("old_event");
		$this->parameters['old_event'] = $old_event_active == 'on';

		$futur_event_active = $this->get_value_from_form("futur_event");
		$this->parameters['futur_event'] = $futur_event_active == 'on';

		return parent::save_form();
	}

	protected function getDefaultClause()
	{
		return [];
	}

	protected function getDefaultJoin()
	{
		return [];
	}

	protected function buildQuery()
	{
		if (!isset($this->parameters['old_event'])) {
			$this->parameters['old_event'] = true;
		}

		if (!isset($this->parameters['futur_event'])) {
			$this->parameters['futur_event'] = true;
		}

		// On veut toutes les animations
		$clause = $this->getDefaultClause();
		if (!$this->parameters['futur_event'] && !$this->parameters['old_event']) {
			// On veut aucune animation, pourquoi ? (je sais pas)
			return "";
		} elseif ($this->parameters['futur_event'] && !$this->parameters['old_event']) {
			// On veut toutes les animations avenirs
			$clause[] = "((anim_events.during_day = 1 AND anim_events.start_date >= CURRENT_TIMESTAMP) OR anim_events.end_date >= CURRENT_TIMESTAMP)";
		} elseif ($this->parameters['old_event'] && !$this->parameters['futur_event']) {
			// On veut toutes les anciennes animations
			$clause[] = "((anim_events.during_day = 1 AND anim_events.start_date <= CURRENT_TIMESTAMP) OR anim_events.end_date <= CURRENT_TIMESTAMP)";
		}

		$query = "SELECT DISTINCT anim_animations.id_animation FROM anim_animations JOIN anim_events ON anim_events.id_event = anim_animations.num_event";

		$joins = $this->getDefaultJoin();
		if (!empty($joins)) {
			foreach ($joins as $join) {
				$query .= ' ' . $join . ' ';
			}
		}
		if (!empty($clause)) {
			$query .= ' WHERE ' . implode(' AND ', $clause);
		}

		return $query;
	}
}
