<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: notification.class.php,v 1.1.2.6 2025/10/20 12:43:23 dgoron Exp $

class notification {
    
    private $type = '';
    
    private $title = '';
    
    private $message = '';
    
    private $actions = [];
    
    private $icon = true;
    
    private $display_mode = 'all';
    
    /**
     * Constructeur d'une notification
     */
    public function __construct(string $type, string $message)
    {
        $this->type = $type;
        $this->message = $message;
        $this->init_default_title();
    }
    
    protected function init_default_title()
    {
        global $msg;
        
        switch ($this->type) {
            case 'error':
                $this->title = $msg['error'];
                break;
            case 'success':
            case 'warning':
            default: // info
                $this->title = '';
                break;
        }
    }
    
    protected function get_role()
    {
        switch ($this->type) {
            case 'error':
            case 'warning':
                return 'alert'; // Annonce immdiate
            case 'success':
            default: // info
                return 'status'; // Annonce polie
        }
    }
    
    protected function get_aria_live()
    {
        switch ($this->type) {
            case 'error':
            case 'warning':
                return 'assertive';
            case 'success':
            default: // info
                return 'polite';
        }
    }
    
    protected function get_icon_name()
    {
        switch ($this->type) {
            case 'error':
            case 'warning':
                return 'error.gif';
            case 'success':
                return '';
            default: // info
                return 'idea.gif';
        }
    }
    
    /**
     * Retourne le HTML pour le titre de la notification
     */
    protected function get_display_title(): string
    {
        global $charset;
        
        if ($this->title) {
            $title_class = 'notification-title-'.$this->type;
            if ($this->type == 'error') {
                $title_class .= ' erreur';
            }
            return "<div class='".$title_class."'>". htmlentities($this->title, ENT_QUOTES, $charset) ."</div>";
        }
        return "";
    }
    
    /**
     * Retourne le HTML pour le dtail de la notification (icne + message)
     */
    protected function get_display_detail(): string
    {
        $icon_name = $this->get_icon_name();
        if ($this->icon && $icon_name) {
            return "
            <div class='row'>
                <div class='colonne10'>
                    <img src='".get_url_icon($icon_name)."' class='align_left' />
                </div>
                <div class='colonne80'>
                    ". $this->get_display_message() ."
                </div>
            </div>";
        } else {
            return "
            <div class='row'>
                ". $this->get_display_message() ."
            </div>";
        }
    }
    
    /**
     * Retourne le HTML pour le message de la notification
     */
    protected function get_display_message(): string
    {
        //classe CSS erreur : gestion de la rtro-compatibilit
        //ajout de la classe erreur lorsque la mthode est appele par render et qu'il n'y a pas de titre
        
        $html = "<span class='notification-message-".$this->type.($this->display_mode == 'all' && !$this->title ? " erreur" : "")."'>";
        if ($this->type == 'error') {
            $html .= "<strong>". $this->message ."</strong>";
        } else {
            $html .= $this->message;
        }
        $html .= "</span>";
        return $html;
    }
    
    /**
     * Gnre le HTML accessible pour la notification
     */
    public function render(): string
    {
        if (empty($this->message)) {
            return '';
        }
        $html = "
        <div class='notification notification-".$this->type."' role='".$this->get_role()."' aria-live='".$this->get_aria_live()."' aria-atomic='true'>
            ".$this->get_display_title()."
            ".$this->get_display_detail()."
        </div>";
        if (!empty($this->actions)) {
            $html .= "<div class='row'>";
            $html .= $this->render_actions();
            $html .= "</div>";
        }
        return $html;
    }
    
    /**
     * Gnre le HTML accessible pour une notification base sur le message uniquement
     */
    public function render_message($format='block'): string
    {
        $this->display_mode = 'message';
        //classe CSS erreur : gestion de la rtro-compatibilit
        
        if ($format == 'inline') {
            return "
            <span class='notification notification-".$this->type." erreur' role='".$this->get_role()."' aria-live='".$this->get_aria_live()."' aria-atomic='true'>
                ". $this->get_display_message() ."
            </span>";
        } else {
            return "
            <div class='notification notification-".$this->type." erreur' role='".$this->get_role()."' aria-live='".$this->get_aria_live()."' aria-atomic='true'>
                ". $this->get_display_message() ."
            </div>";
        }
    }
    
    /**
     * Gnre le HTML accessible pour le bouton de retour de la notification
     */
    public function render_actions(): string
    {
        global $current_module, $charset;
        
        if (empty($this->actions)) {
            return '';
        }
        $html = "<form class='form-". htmlentities($current_module, ENT_QUOTES, $charset) ."' name='dummy'>";
        foreach ($this->actions as $name=>$action) {
            $html .= "<input
                type='button'
                name='".$name."'
                class='bouton'
                value=' ". htmlentities($action['label'], ENT_QUOTES, $charset) ." '
                onClick='".$action['onClick']."'
            />";
        }
        $html .= "</form>
        <script type='text/javascript'>
            if (document.forms['dummy'].elements['ok']) {
                document.forms['dummy'].elements['ok'].focus();
            }
        </script>";
        return $html;
    }
    
    public function set_title($title)
    {
        $this->title = $title;
    }
    
    public function set_actions($actions)
    {
        $this->actions = $actions;
    }
    
    public function add_action($action)
    {
        
        $this->actions[] = $action;
    }
    
    public function add_back_action($redirect_address='')
    {
        global $msg;
        
        if ($redirect_address) {
            $onClick = "document.location=\"".$redirect_address."\"";
        } else {
            $onClick = "history.go(-1);";
        }
        $this->actions['ok'] = ['label' => $msg[11], 'onClick' => $onClick];
    }
    
    public function hide_icon()
    {
        $this->icon = false;
    }
}

