<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: ajax_contact_form.inc.php,v 1.15.4.1.4.2 2026/01/27 09:06:14 gneveu Exp $

if (stristr($_SERVER['REQUEST_URI'], ".inc.php")) {
    die("no access");
}

use Pmb\Common\Helper\HashModel;
use Pmb\Common\Models\CaptchaModel;

global $base_path, $class_path, $sub, $action, $charset;
global $id, $form_fields, $pmb_logs_activate;

require_once($class_path."/contact_forms/contact_form.class.php");
require_once($class_path."/contact_forms/contact_form_object.class.php");
require_once($class_path."/encoding_normalize.class.php");

switch($sub) {
    case 'form':
        switch ($action) {
            case 'send_attachments':
                $has_errors = 0;
                $errors_messages = [];
                $attachments = [];
                if(!empty($_FILES['contact_form_parameter_attachments']) && is_array($_FILES['contact_form_parameter_attachments']['tmp_name']) && count($_FILES['contact_form_parameter_attachments']['tmp_name'])) {
                    foreach ($_FILES['contact_form_parameter_attachments']['tmp_name'] as $key => $tmp_file) {

                        if(empty($tmp_file)) {
                            continue;
                        }

                        $to_file = '';
                        $from_file = '';
                        $has_error = 0;
                        $error_message = '';
                        if(trim($_FILES['contact_form_parameter_attachments']['name'][$key]) && $_FILES['contact_form_parameter_attachments']['size'][$key]) {
                            $to_file = $base_path.'/temp/'.basename($tmp_file);
                            $from_file = $_FILES['contact_form_parameter_attachments']['name'][$key];
                            if (!@move_uploaded_file($tmp_file, $to_file)) {
                                /* Fail to copy %s, Contact your admin... */
                                $has_error = 1;
                                $error_message = 'Fail to copy';
                            }
                        } elseif(trim($_FILES['contact_form_parameter_attachments']['name'][$key])) {
                            $has_error = 2;
                            $error_message = 'Unknown name';
                        }

                        $hashModel = new HashModel();
                        $hashLocation = $hashModel->generateHash($to_file);
                        if (!isset($_SESSION['contact_form_parameter_attachments'])) {
                            $_SESSION['contact_form_parameter_attachments'] = [];
                        }
                        $_SESSION['contact_form_parameter_attachments'][$hashLocation] = $to_file;

                        $attachments[] = [
                            "name" => $from_file,
                            "hash" => $hashLocation,
                            "has_error" => $has_error,
                            "error_message" => $error_message,
                        ];
                        $has_errors += $has_error;
                        if($error_message) {
                            $errors_messages[] = $error_message;
                        }
                    }
                }
                print encoding_normalize::json_encode(['has_errors' => $has_errors, 'errors_messages' => $errors_messages, 'attachments' => $attachments]);
                break;
            case 'send_mail':
                if(empty($id)) {
                    $id = 1;
                }
                $contact_form = new contact_form($id);

                //domForm.toJson au dpart de l'appel, les donnes sont dj en UTF-8
                $form_fields = json_decode(stripslashes(encoding_normalize::utf8_normalize($form_fields)));
                if($charset != 'utf-8') {
                    $form_fields = (object) encoding_normalize::utf8_decode($form_fields);
                }
                if(!empty($attachments)) {
                    $attachments = json_decode(encoding_normalize::utf8_normalize(stripslashes($attachments)));
                    if($charset != 'utf-8') {
                        $attachments = (object) encoding_normalize::utf8_decode($attachments);
                    }

                    $sessionAttachments = $_SESSION["contact_form_parameter_attachments"] ?? null;
                    $hasValidSession = is_array($sessionAttachments) && !empty($sessionAttachments);
                    $hashModel = $hasValidSession ? new HashModel() : null;

                    foreach($attachments as &$attachment) {
                        $attachment->location = "";

                        // Vrification si la session est valide
                        if (empty($attachment->hash) || !$hasValidSession) {
                            continue;
                        }

                        // Vrification de l'existence du hash dans la session
                        if (!isset($sessionAttachments[$attachment->hash])) {
                            continue;
                        }

                        $sessionLocation = $sessionAttachments[$attachment->hash];

                        // Vrification du hash seulement si ncessaire
                        if ($hashModel->verifeHash($attachment->hash, $sessionLocation)) {
                            $attachment->location = $sessionLocation;
                        }
                    }

                    if(!empty($sessionAttachments)) {
                        unset($_SESSION["contact_form_parameter_attachments"]);
                    }

                    $form_fields->contact_form_parameter_attachments = $attachments;
                }
                $contact_form->set_form_fields($form_fields);
                if(CaptchaModel::verify($form_fields->altcha)) {
                    $contact_form->send_mail();
                } else {
                    $contact_form->set_messages([$msg['captcha_error']]);
                }
                // Log - afin de faire des stats sur les mails envoyes
                if ($pmb_logs_activate && $contact_form->is_sended()) {
                    generate_log('ajax_contact_form', [], true);
                }
                ajax_http_send_response(encoding_normalize::json_encode(['sended' => $contact_form->is_sended(), 'errors_messages' => $contact_form->get_messages(), 'fields_errors' => $contact_form->get_fields_errors()]));
                break;
            default:
                http_response_code(404);
                break;
        }
        break;

    case 'object':
        switch ($action) {
            case 'change':
                $contact_form_object = new contact_form_object($id);
                print encoding_normalize::json_encode(['id' => $id, 'message' => $contact_form_object->get_translated_message()]);
                break;
            default:
                http_response_code(404);
                break;
        }
        break;

    default:
        http_response_code(404);
        break;
}
