<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: 404.php,v 1.1.2.2 2026/01/09 15:15:58 rtigero Exp $
use Pmb\Common\Helper\HTML;

$base_path = '.';

require_once $base_path.'/includes/init.inc.php';
require_once $base_path.'/includes/common_includes.inc.php';
require_once($base_path.'/includes/templates/common.tpl.php');

global $include_path, $css, $opac_default_style_addon, $opac_redirection_url_404;

if(!empty($opac_redirection_url_404)) {
    header("Location: " . $opac_redirection_url_404, true, 302);
    exit;
}

$template = $include_path . '/templates/404.tpl.html';
if (file_exists($include_path.'/templates/404_subst.tpl.html')) {
    $template = $include_path.'/templates/404_subst.tpl.html';
}
$h2o = H2o_collection::get_instance($template);
$html = $h2o->render([
    "opac_style" => HtmlHelper::getInstance()->getStyle($css),
    "default_opac_style" => $opac_default_style_addon ? "<style type='text/css'>{$opac_default_style_addon}</style>" : "",
    "iso_lang_code" => get_iso_lang_code()
]);
print(HTML::cleanHTML($html));