import Vue from "vue";
import loader from "@/common/components/loader.vue"
import docnums from "./components/docnums.vue"
import preview from "./components/preview.vue"

import InitVue from "@/common/helper/InitVue.js";
InitVue(Vue, {
  useLoader: true,
  urlWebservice: $data.urlWebservice,
  webserviceCachingOptions: {
      lifetime: 1000
  }
});

new Vue({
    el: "#docnums-views",
    data: {
      ...$data,
      active: false,
      selectedIdDocnum:0
    },
    components: { loader, docnums, preview },
    created() {
      const showDocnumsBtn = document.getElementById('bt_show_docnums');
      if (showDocnumsBtn) {
        showDocnumsBtn.addEventListener('click', (e) => this.swhitchShowDocnums(e));
      }
    },
    methods: {
      swhitchShowDocnums: function (_) {
        this.active = !this.active;

        const noticeFormContainer = document.getElementById('notice-form-container');
        const showDocnumsBtn = document.getElementById('bt_show_docnums');

        if (this.active) {
          noticeFormContainer.classList.add('show_docnums');
          showDocnumsBtn.setAttribute('value', this.hideMessage);
        } else {
          noticeFormContainer.classList.remove('show_docnums');
          showDocnumsBtn.setAttribute('value', this.showMessage);
        }

        this.selectedIdDocnum = 0;
      },
      selectDocnum(idDocnum) {
        this.selectedIdDocnum = idDocnum;
      }
    }
});