# AiIndexationDocnumCli.php

Script CLI pour l'indexation AI des documents numeriques (explnum) dans PMB.

## Description

Ce script permet d'indexer automatiquement les documents numeriques de votre base PMB en utilisant l'intelligence artificielle configuree dans l'administration.

Il s'agit d'une version CLI du script web `AiIndexationDocnum.php`, optimisee pour une execution en ligne de commande, notamment via cron ou pour des traitements par lots.

## Prerequis

- PHP 8.1+ (compatible PHP 8.3+)
- PMB 8.1.0+ avec le module AI actif
- Une configuration AI active dans l'administration PMB
- Acces en ligne de commande au serveur

## Installation

1. Le script est situe dans le repertoire `devel/` de votre installation PMB
2. Rendre le script executable (optionnel) :

```bash
chmod +x devel/AiIndexationDocnumCli.php
```

## Utilisation

### Syntaxe de base

```bash
php devel/AiIndexationDocnumCli.php [options]
```

Ou si executable :

```bash
./devel/AiIndexationDocnumCli.php [options]
```

### Options disponibles

| Option | Alias | Description |
|--------|-------|-------------|
| `--help` | `-h` | Affiche l'aide du script |
| `--verbose` | `-v` | Mode verbeux (affiche tous les details) |
| `--batch-size <n>` | - | Nombre d'elements par lot (defaut: defini dans config AI) |
| `--clean` | - | Nettoie l'indexation existante avant de recommencer |

## Exemples d'utilisation

### Execution simple

Indexation avec les parametres par defaut :

```bash
php devel/AiIndexationDocnumCli.php
```

### Mode verbeux

Affiche tous les details de l'indexation :

```bash
php devel/AiIndexationDocnumCli.php --verbose
```

### Nettoyage et reindexation

Nettoie l'indexation existante puis reindexe :

```bash
php devel/AiIndexationDocnumCli.php --clean --verbose
```

### Personnaliser la taille des lots

Traiter 100 elements par lot au lieu de la valeur par defaut :

```bash
php devel/AiIndexationDocnumCli.php --batch-size 100 --verbose
```

### Execution via cron

Pour automatiser l'indexation, ajoutez une tache cron :

```bash
# Indexation quotidienne a 2h du matin
0 2 * * * cd /home/gneveu/public_html/pmb_810 && php devel/AiIndexationDocnumCli.php --verbose >> /var/log/pmb_ai_indexation.log 2>&1
```

## Fonctionnement

### Processus d'indexation

1. **Initialisation** : Recuperation de la configuration AI active
2. **Nettoyage** (optionnel) : Suppression de l'indexation existante si `--clean`
3. **Indexation par lots** : Traitement des documents numeriques par paquets
4. **Progression** : Affichage d'une barre de progression en temps reel
5. **Finalisation** : Resume du nombre d'elements indexes

### Barre de progression

En mode normal (sans `--verbose`), une barre de progression s'affiche :

```
[==========================------------------------] 52.50% (105/200)
```

En mode `--verbose`, des messages detailles sont affiches :

```
[2025-12-16 14:30:45] === Script d'indexation AI des documents numeriques ===
[2025-12-16 14:30:45] Demarrage: 2025-12-16 14:30:45
[2025-12-16 14:30:45] === Initialisation de l'indexation AI ===
[2025-12-16 14:30:45] Configuration AI active: ID 1
[2025-12-16 14:30:45] Debut de l'indexation (lots de 20 elements)...
[2025-12-16 14:30:46] Iteration 1...
...
```

## Configuration

### Configuration AI dans PMB

Avant d'utiliser ce script, assurez-vous qu'une configuration AI est active dans PMB :

1. Administration > Outils > Intelligence Artificielle
2. Activer une configuration AI
3. Configurer les parametres d'indexation

### Taille des lots

La taille des lots par defaut est definie par la variable globale `$ai_index_nb_elements` dans la configuration PMB.

Vous pouvez la surcharger avec l'option `--batch-size`.

## Codes de sortie

| Code | Signification |
|------|---------------|
| 0 | Succes |
| 1 | Erreur (pas de configuration AI, erreur critique, etc.) |

## Gestion des erreurs

### Aucune configuration AI active

```
ERREUR: Aucune configuration AI active trouvee
Veuillez activer une configuration AI dans l'administration PMB
```

**Solution** : Activer une configuration AI dans l'administration PMB.

### Erreur critique

```
ERREUR CRITIQUE: [message d'erreur]
Trace: [stack trace]
```

**Solution** : Verifier les logs et la configuration PMB.

## Remarques techniques

- Le script utilise les classes PMB : `AISettingsOrm` et `Semantic`
- L'indexation se fait par lots pour eviter une surcharge memoire
- Une pause de 0.1 seconde est appliquee entre chaque lot
- Le script est compatible avec l'architecture PMB existante

## Differences avec la version web

| Caracteristique | Version Web | Version CLI |
|----------------|-------------|-------------|
| Interface | HTML avec netbase | Ligne de commande |
| Progression | Refresh HTTP | Barre de progression |
| Execution | Via navigateur | Via terminal/cron |
| Arguments | GET/POST | Arguments CLI |
| Logs | Interface web | stdout/stderr |

## Licence

© 2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)

## Support

Pour toute question ou probleme :
- Documentation PMB : https://www.sigb.net
- Forum PMB : https://www.sigb.net/forum
