<?php
// +-------------------------------------------------+
//  2002-2012 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: cms_module_musicme_view_musicme.class.php,v 1.2.4.2 2025/10/30 08:23:57 gneveu Exp $

use Pmb\Common\Orm\EmprOrm;

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) {
    die("no access");
}

class cms_module_musicme_view_musicme extends cms_module_common_view_django
{
    public function __construct($id = 0)
    {
        global $msg, $charset;

        parent::__construct($id);
        $this->default_template = '
<div class="musicme">
    <img
        src="./images/connecteurs/musicme.png"
        alt="{{ msg.musicme }}"
    />
    <a
        class="bouton"
        href="{{ connector.url_connexion_cas }}"
        aria-label="{{ msg.musicme }}"
    >
        {{ msg.musicme_access }}
    </a>
</div>';
    }

    /**
     * Renvoie les structures de donnes du module
     *
     * @return array
     */
    public function get_format_data_structure()
    {
        return array_merge(
            parent::get_format_data_structure(),
            [
                [
                    'var' => 'connector',
                    'desc' => $this->msg['connector_vars_view_desc'],
                    'children' => [
                        [
                            'var' => 'connector.url_connexion_cas',
                            'desc' => $this->msg['connector_url_connexion_cas_vars_view_desc'],
                        ],
                    ]
                ]
            ]
        );
    }

    /**
     * Rendu du module
     *
     * @param false|array{connector: int} $data
     * @return string
     */
	public function render($data)
    {
        // Enrichissement des donnees avec les informations du connecteur
        if (!empty($data['connector'])) {
            $connector_id = intval($data['connector']);

            // Recuperation de l'URL du connecteur depuis la base
            $query = "SELECT PARAMETERS FROM connectors_sources WHERE id_connector = 'musicme' AND source_id = " . $connector_id;
            $result = pmb_mysql_query($query);

            if ($result && pmb_mysql_num_rows($result)) {
                $row = pmb_mysql_fetch_assoc($result);
                $params = unserialize($row['PARAMETERS']);

                $musicme_url = $params['musicme_url'] ?? 'https://app.mt.musicme.com';
                $musicme_url_server_cas = $params['musicme_url_server_cas'] ?? '';
                $url = $this->build_musicme_link($musicme_url, $musicme_url_server_cas);

                // Preparation des donnees pour le template
                $data['connector'] = [
                    'url_connexion_cas' => $url,
                ];
            }
        }
        return parent::render($data);
    }

    protected function build_musicme_link($musicme_url, $musicme_url_server_cas)
    {
        return $musicme_url_server_cas . '?service=' . urlencode($musicme_url);
    }
}
