<?php
/***********************************************************************************************
 Ce fichier fait partie du projet voxilabPHP, implmentation PHP de
 l'API Voxilab (https://github.com/voxilab)

 Cette  implmentation dveloppe par  2013- PMB Services.

 Ce programme est rgi par la licence CeCILL soumise au droit franais et
 respectant les principes de diffusion des logiciels libres. Vous pouvez
 utiliser, modifier et/ou redistribuer ce programme sous les conditions
 de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA
 sur le site "http://www.cecill.info".

 En contrepartie de l'accessibilit au code source et des droits de copie,
 de modification et de redistribution accords par cette licence, il n'est
 offert aux utilisateurs qu'une garantie limite.  Pour les mmes raisons,
 seule une responsabilit restreinte pse sur l'auteur du programme,  le
 titulaire des droits patrimoniaux et les concdants successifs.

 A cet gard  l'attention de l'utilisateur est attire sur les risques
 associs au chargement,   l'utilisation,   la modification et/ou au
 dveloppement et  la reproduction du logiciel par l'utilisateur tant
 donn sa spcificit de logiciel libre, qui peut le rendre complexe 
 manipuler et qui le rserve donc  des dveloppeurs et des professionnels
 avertis possdant  des  connaissances  informatiques approfondies.  Les
 utilisateurs sont donc invits  charger  et  tester  l'adquation  du
 logiciel  leurs besoins dans des conditions permettant d'assurer la
 scurit de leurs systmes et ou de leurs donnes et, plus gnralement,
  l'utiliser et l'exploiter dans les mmes conditions de scurit.

 Le fait que vous puissiez accder  cet en-tte signifie que vous avez
 pris connaissance de la licence CeCILL, et que vous en avez accept les
 termes.
 ***********************************************************************************************/

/*
 * A speaker : a distinct person identified in the speech. A speaker is always associated with segments.
 *
 * $Id: voxilabSpeaker.class.php,v 1.1.30.1 2025/08/14 07:51:02 dbellamy Exp $
 */

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) {
    die("no access");
}

require_once 'voxilabSegment.class.php';

class voxilabSpeaker
{

    /**
     * Speaker identifier
     */
    private $id;

    /**
     * Speaker gender
     */
    private $gender;

    /**
     * Speaker segments
     *
     * @var array
     */
    private $segments = array();

    /**
     *
     * @param int id Speaker identifier
     * @param char gender Speaker gender
     *
     * @return void
     */
    public function __construct($id, $gender)
    {
        $this->id = $id;
        $this->gender = $gender;
    }

    public function __toString()
    {
        return "Speaker " . $this->id . ". Gender : " . $this->gender . "<br />";
    }

    public function getID()
    {
        return $this->id;
    }

    public function getGender()
    {
        return $this->gender;
    }

    /**
     * Add a segment to the speaker
     *
     * @param voxilabSegment segment New segment
     */
    public function addSegment($segment)
    {
        $this->segments[] = $segment;
    }

    /**
     * Encode the segment into Json
     *
     * @return string
     */
    public function toJson()
    {
        $segments = array();
        foreach ($this->segments as $segment) {
            $segments[] = array(
                'start' => $segment->getStart(),
                'duration' => $segment->getDuration()
            );
        }
        $array = array(
            'id' => $this->id,
            'gender' => $this->gender,
            'segments' => $segments
        );
        return json_encode($array);
    }

    public function getSegments()
    {
        return $this->segments;
    }
}

