<?php
// +-------------------------------------------------+
// | 2002-2011 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: list_resa_planning_catalog_ui.class.php,v 1.1.2.2 2025/07/01 12:29:16 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

class list_resa_planning_catalog_ui extends list_resa_planning_ui {
    
    protected function init_location_filters() {
        global $pmb_location_resa_planning;
        //Vide pour outrepasser la restriction faite plus haut
        $this->filters['empr_location'] = '';
        if($pmb_location_resa_planning) {
            $this->filters['resa_loc_retrait'] = '';
        }
    }
    
	protected function init_default_columns() {
	    global $pmb_lecteurs_localises;
		
		$this->add_column('empr');
		if($pmb_lecteurs_localises) {
		    $this->add_column('empr_location');
		}
		$this->add_column('resa_date');
		$this->add_column('resa_date_debut');
		$this->add_column('resa_date_fin');
	}
	
	protected function init_default_settings() {
	    parent::init_default_settings();
	    $this->set_setting_display('search_form', 'visible', false);
	    $this->set_setting_display('search_form', 'export_icons', false);
	    $this->set_setting_display('query', 'human', false);
	    $this->set_setting_display('pager', 'visible', false);
	    $this->set_setting_column('empr', 'align', 'left');
	    $this->set_setting_column('empr_location', 'align', 'left');
	    
	    //Oublions le deffered pour l'instant
	    $this->set_setting_display('objects_list', 'deffered_load', false);
	}
	
	protected function init_default_applied_sort() {
	    $this->add_applied_sort('empr');
	    $this->add_applied_sort('record');
	    $this->add_applied_sort('resa_date');
	}
	
	protected function init_default_pager() {
	    parent::init_default_pager();
	    $this->pager['all_on_page'] = true;
	}
}