<?php
// +-------------------------------------------------+
// | 2002-2011 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: list_abts_abts_ui.class.php,v 1.1.2.2 2025/10/21 14:14:45 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

class list_abts_abts_ui extends list_abts_ui {
	
	protected function _get_query_base() {
		return 'SELECT abt_id FROM abts_abts';
	}
	
	protected function get_object_instance($row) {
	    $abts_abonnement = new abts_abonnement($row->abt_id);
	    if (!$abts_abonnement->error) {
	        return $abts_abonnement;
	    }
	    return null;
	}
	
	/**
	 * Initialisation des filtres de recherche
	 */
	public function init_filters($filters=array()) {
	
		$this->filters = array(
			'location' => 0,
			'serial_id' => 0
		);
		parent::init_filters($filters);
	}
	
	protected function init_default_applied_group() {
        $this->applied_group = array(0 => 'abt_name');
	}
	
	/**
	 * Initialisation des colonnes disponibles
	 */
	protected function init_available_columns() {
		$this->available_columns = 
		array('main_fields' =>
			array(
                    'abt_name' => 'abonnements_nom_abonnement',
					'modele_lie' => 'abonnements_modele_lie',
				    'duree_abonnement' => 'abonnements_duree_abonnement',
					'date_debut' => 'abonnements_date_debut',
					'date_fin' => 'abonnements_date_fin',
					'nombre_de_series' => 'abonnements_nombre_de_series',
					'nombre_de_horsseries' => 'abonnements_nombre_de_horsseries',
                    'prix' => '4050',
                    'fournisseur' => 'abonnements_fournisseur'
			)
		);
	}
	
	protected function init_default_selected_filters() {
	    $this->add_selected_filter('location');
	}
	
	/**
	 * Initialisation du tri par dfaut appliqu
	 */
	protected function init_default_applied_sort() {
	    $this->add_applied_sort('abt_name');
	}
	
	/**
	 * Retourne le template du formulaire de recherche
	 */
	public function get_search_form_tpl() {
	    global $current_module;
	    
	    return "
        <form class='form-".$current_module."' id='!!form_name!!' name='!!form_name!!' method='post' action=\"!!action!!\" >
        	<!--    Contenu du form    -->
        	<div class='form-contenu'>
        		<div id='!!objects_type!!_search_content' class='list_ui_search_content !!objects_type!!_search_content' style='display:!!unfolded_filters!!;'>
        			!!list_search_content_form_tpl!!
                    <input type='hidden' name='location' value='".$this->filters['location']."'/>
        		</div>
        	</div>
        </form>
        ";
	}
	
	protected function get_search_filter_location() {
	    // 		global $msg;
	    //AUTO SUBMIT
	    $onchange = "document.".$this->objects_type."_search_form.location.value=this.options[this.selectedIndex].value;";
	    $onchange .= "document.".$this->objects_type."_search_form.submit();";
	    return docs_location::gen_combo_box_empr($this->filters['location'],1,$onchange);
// 		return $this->get_search_filter_simple_selection($this->get_selection_query('locations'), 'location', $msg["all_location"]);
	}
	
	protected function _cell_is_sortable($name) {
	    return false;
	}
	
	/**
	 * Champ(s) du tri SQL
	 */
	protected function _get_query_field_order($sort_by) {
	    switch($sort_by) {
	        case 'abt_name':
	            return $sort_by;
	        default :
	            return parent::_get_query_field_order($sort_by);
	    }
	}
	
	protected function init_default_columns() {
	    $this->add_column('modele_lie');
	    $this->add_column('duree_abonnement');
	    $this->add_column('date_debut');
	    $this->add_column('date_fin');
	    $this->add_column('nombre_de_series');
	    $this->add_column('nombre_de_horsseries');
	    $this->add_column('prix');
	}
	
	protected function _add_query_filters() {
	    parent::_add_query_filters();
	    $this->_add_query_filter_simple_restriction('location', 'location_id', 'integer');
	}
	
	protected function _get_object_property_modele_lie($object) {
	    $modele_list="";
	    $requete="select modele_id from abts_abts_modeles where abt_id='$object->abt_id'";
	    $resultat=pmb_mysql_query($requete);
	    while ($r_a=pmb_mysql_fetch_object($resultat)) {
	        $modele_id=$r_a->modele_id;
	        $modele_name=pmb_sql_value("select modele_name from abts_modeles where modele_id='$modele_id'");
	        $num_periodicite=pmb_sql_value("select num_periodicite from abts_modeles where modele_id='$modele_id'");
	        $periodicite=pmb_sql_value("SELECT libelle from abts_periodicites where periodicite_id='".$num_periodicite."'");
	        if ($modele_list) {
	            $modele_list.=",";
	        }
	        $modele_list.=" $modele_name";
	        if($periodicite) {
	            $modele_list.=" ($periodicite)";
	        }
	    }
	    
	    return $modele_list;
	}
	
	protected function _get_object_property_abt_name($object) {
	    $href = "catalog.php?categ=serials&sub=abon&serial_id=".$object->num_notice."&abt_id=".$object->abt_id;
	    return  abts_status::get_display($object->abt_status)."<a href='".$href."'>".$object->abt_name."</a>";
	}
	
	protected function _get_object_property_nombre_de_series($object) {
	    return pmb_sql_value("SELECT SUM(nombre) FROM abts_grille_abt WHERE num_abt='$object->abt_id' AND type ='1'") ?? 0;
	}
	
	protected function _get_object_property_nombre_de_horsseries($object) {
	    return pmb_sql_value("SELECT SUM(nombre) FROM abts_grille_abt WHERE num_abt='$object->abt_id' AND type ='2'") ?? 0;
	}
	
	protected function _get_object_property_fournisseur($object) {
	    global $msg;
	    if($object->fournisseur) {
	        $raison_sociale = pmb_sql_value("SELECT raison_sociale from entites where id_entite = '".$object->fournisseur."' ");
	        return $msg["abonnements_fournisseur"].": ".$raison_sociale;
	    }
	    return '';
	}
	
	/**
	 * Construction de la fonction JS pour l'expand/collapse
	 */
	public function get_js_sort_expandable_list() {
	    global $msg, $charset;
	    $display = "
			<div class='row'>
				<a href='javascript:expandAll(document.getElementById(\"abonnement_list_content\"))' title='".htmlentities($msg['expandall'], ENT_QUOTES, $charset)."'><img src='".get_url_icon('expand_all.gif')."' id='expandall'></a>
				<a href='javascript:collapseAll(document.getElementById(\"abonnement_list_content\"))' title='".htmlentities($msg['collapseall'], ENT_QUOTES, $charset)."'><img src='".get_url_icon('collapse_all.gif')."' id='collapseall'></a>
				".(!empty($this->expandable_title) ? $this->expandable_title : '')."
			</div>";
	    return $display;
	}
	
	protected function get_cell_content($object, $property) {
	    global $pmb_gestion_devise;
	    
	    $content = '';
	    switch($property) {
	        case 'prix':
	            if ($object->prix != '') {
	                $content .= $object->prix.'&nbsp'.$pmb_gestion_devise;
	            }
	            break;
	        default :
	            $content .= parent::get_cell_content($object, $property);
	            break;
	    }
	    return $content;
	}
	
	protected function get_display_group_label($group_label, $counter=0) {
	    $group_label = parent::get_display_group_label($group_label, $counter);
	    return "
        <span class='notice-heada'>
        	".$group_label."
        </span>";
	}
	
	/**
	 * Header de la liste
	 */
	public function get_display_header_list() {
	    return '';
	}
	
	/**
	 * Affichage des colonnes
	 * @param object $object
	 * @param string $property
	 */
	protected function get_display_cells($object) {
	    global $msg;
	    global $abonnement_view;
	    global $pmb_serialcirc_active;
	    
	    $r = $abonnement_view;
	    
	    $r = str_replace("!!modele_lie!!", $this->_get_object_property_modele_lie($object), $r);
	    $r = str_replace("!!duree_abonnement!!", $this->get_cell_content($object, 'duree_abonnement'), $r);
	    $r = str_replace("!!date_debut!!", $this->get_cell_content($object, 'date_debut'), $r);
	    $r = str_replace("!!date_fin!!", $this->get_cell_content($object, 'date_fin'), $r);
	    
	    $r = str_replace("!!nombre_de_series!!", $this->_get_object_property_nombre_de_series($object), $r);
	    $r = str_replace("!!nombre_de_horsseries!!", $this->_get_object_property_nombre_de_horsseries($object), $r);
	    
	    $r=str_replace("!!prix!!", $this->get_cell_content($object, 'prix'), $r);
	    
	    $r = str_replace("!!fournisseur!!", $this->_get_object_property_fournisseur($object), $r);
	    
	    $aff_destinataire="";
	    if ($object->destinataire){
	        $aff_destinataire="<tr>
				<td colspan='2'>".$object->destinataire."</td>
			</tr>";
	    }
	    $r=str_replace("!!commentaire!!",$aff_destinataire,$r);
	    
	    //Liste des destinataires
	    $tpl_empr_list = $object->get_tpl_empr_list();
	    $aff_empr_list="";
	    if($tpl_empr_list){
	        $aff_empr_list="
			<tr>
				<td colspan='2'>
					<h3>".$msg["serialcirc_diff_empr_list_title"]."</h3>
					$tpl_empr_list
				</td>
			</tr>";
	    }
	    
// 	    $r=str_replace("!!serial_id!!", $serial_id, $r);
	    $r = str_replace("!!serialcirc_empr_list!!", $aff_empr_list, $r);
	    
	    if ($pmb_serialcirc_active) {
	        $r .= "<input type='button' class='bouton' value='".$msg["serialcirc_diffusion_gestion_button"]."' onClick=\"document.location='./catalog.php?categ=serialcirc_diff&sub=view&num_abt=".$object->abt_id."';\"/>&nbsp;";
	    }
	    $r .= "<input type='button' class='bouton' value='".$msg["serialcirc_export_list"]."'
				onClick=\"document.location='./edit.php?dest=TABLEAU&categ=serialcirc_diff&sub=export_empr&&num_abt=".$object->abt_id."'\"/>&nbsp;";
	    return $r;
	}
	
	/**
	 * Affichage de la liste des objets
	 * @return string
	 */
	public function get_display_objects_list() {
	    $display = "<script type='text/javascript' src='./javascript/tablist.js'></script>
        <div class='form-contenu' id='abonnement_list_content'>";
	    $display .= parent::get_display_objects_list();
	    $display .= "</div>";
	    return $display;
	    
	}
	
	protected function get_button_add() {
	    global $msg;
	    global $serial_id;
	    
	    $result = pmb_mysql_query("select modele_id,modele_name from abts_modeles where num_notice='$serial_id'");
	    if ($result && pmb_mysql_num_rows($result)) {
            return "<input type='button' class='bouton' value='".$msg["abts_abonnements_add_button"]."' onClick='document.location=\"catalog.php?categ=serials&sub=abon&serial_id=$serial_id\"'/>";
	    }
	    return "";
	}
	
	protected function get_display_left_actions() {
	    return $this->get_button_add();
	}
	
	public function get_error_message_empty_list() {
	    global $msg;
	    
	    return $msg["abts_modeles_no_modele"];
	}
	
	public static function get_controller_url_base() {
	    global $base_path, $serial_id;
	    
	    return $base_path.'/catalog.php?categ=serials&sub=view&serial_id='.$serial_id.'&view=abon';
	}
}