<?php
// +-------------------------------------------------+
// | 2002-2011 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: interface_entity_record_element.class.php,v 1.1.2.2.4.4 2025/12/09 10:56:28 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

class interface_entity_record_element extends interface_entity_element {
	
	public function add_authority_node($value='', $completion='') {
	    $node = parent::add_authority_node($value, $completion);
	    $node->set_openPopUpFunction('openPopUpSelector');
	    return $node;
	}
	
	public function get_display() {
	    global $msg, $charset;
	    
	    $display = '';
		switch ($this->display_type) {
			case 'flat':
				$display .= "
				<div id='".$this->uid."' ".(!empty($this->class) ? "class='".$this->class."'" : "")." ".(!empty($this->movable) ? "movable='yes'" : '')." title=\"".htmlentities($this->label, ENT_QUOTES, $charset)."\">
					".$this->get_display_label()."
					".$this->get_display_nodes()."
				</div>";
				break;
			case 'fieldset':
			    $display .= "
				<div id='".$this->uid."' class='".(!empty($this->class) ? $this->class : 'row')."' ".(!empty($this->movable) ? "movable='yes'" : '')." title=\"".htmlentities($this->label, ENT_QUOTES, $charset)."\">
                    <fieldset>
                        <legend>".$this->label."</legend>
                        ".$this->get_display_nodes()."
    				</fieldset>
                </div>";
			    break;
			default:
			    $display .= "<div id='".$this->uid."' ".(!empty($this->class) ? "class='".$this->class."'" : "")." ".(!empty($this->movable) ? "movable='yes'" : '')." title=\"".htmlentities($this->label, ENT_QUOTES, $charset)."\">";
				if(!empty($this->label)) {
				    if ($this->required) {
				        $display .= "
    					<div id='".$this->uid."a' class='row'>
    						<label class='etiquette' for='".$this->name."' title='".htmlentities($msg['is_required'], ENT_QUOTES, $charset)."'>".$this->label." <sup>*</sup></label>
    					</div>";
				    } else {
				        $display .= "
    					<div id='".$this->uid."a' class='row'>
    						".$this->get_display_label()."
    					</div>";
				    }
				}
				if($this->hidden_nodes) {
					$display .= $this->get_display_nodes();
				} else {
					$display .= "
					<div id='".$this->uid."b' class='row'>
						".$this->get_display_nodes()."
					</div>";
				}
				$display .= "</div>";
				break;
		}
		return $display;
	}
	
}