<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// functions for conversion of SUTRS record
// authors: Marco Vaninetti, Massimo Mancini
// state: experimental ;-)
// +-------------------------------------------------+
// $Id: z3950_sutrs.inc.php,v 1.11.16.2 2025/04/04 08:56:04 dgoron Exp $


if (stristr($_SERVER['REQUEST_URI'], ".inc.php")) die("no access");

global $class_path, $include_path, $lang;

//require_once ("$include_path/parser.inc.php");
require_once ("$include_path/parser.inc.php");
require_once("$class_path/XMLlist.class.php");

$clang = new XMLlist("$include_path/marc_tables/$lang/lang.xml", 0);
$clang->analyser();
$codelang = $clang->table;
foreach ($codelang as $l => $d) $codelang[$l]=strtolower($d);

function _item_($param) {
	global $import_type;
	global $i;
	global $param_path;
	global $import_type_l;

	if ($i == $import_type) {
		$param_path = $param['PATH'];
		$import_type_l = $param['NAME'];
	}
	$i ++;
}

//Rcupration du nom de l'import
function _import_name_($param) {
	global $import_name;

	$import_name = $param['value'];
}

//Rcupration du nombre de notices  traiter par passe
function _n_per_pass_($param) {
	global $n_per_pass;

	$n_per_pass = $param['value'];
}

//Rcupration du type d'entre
function _input_($param) {
	global $input_type;
	global $input_params;

	$input_type = $param['TYPE'];
	$input_params = $param;
}

//Rcupration des tapes de conversion
function _step_($param) {
	global $step;

	$step[] = $param;
}

//Rcupration du paramtre d'import
function _output_($param) {
	global $output;
	global $output_type;
	global $output_params;

	$output = $param['IMPORTABLE'];
	$output_type = $param['TYPE'];
	$output_params=$param;
}

function convert_notice($notice) {
	global $step;
	global $param_path;
	global $n_errors;
	global $message_convert;
	global $n_current;

			
	$r = texttoxml($notice, $step[0], "0", "1", $param_path);
	if (!$r['VALID']) {
		$n_errors ++;
		$message_convert.= "<b>Notice ". ($n_current)." : </b>".$r['ERROR']."<br />\n";
		$notice = "";
	} else {
		$notice = $r['DATA'];
	}
	$r = toiso($notice, $step[1], "1","0", $param_path);
	if (!$r['VALID']) {
		$n_errors ++;
		$message_convert.= "<b>Notice ". ($n_current)." : </b>".$r['ERROR']."<br />\n";
		$notice = "";
	} else {
		$notice = $r['DATA'];
		if($r['WARNING']){
			$n_errors ++;
			$message_convert.= "<b>Notice ". ($n_current)." : </b>".$r['WARNING']."<br />\n";
		}
	}

	return $notice;
}

function sutrs_record($ss,$sutrs_lang) {
	$base_path = "../..";
	//global $class_path;
	global $lang;
	global $include_path;
	global $charset;
	global $campi,$sep,$fun,$codelang;

//	require_once ("$include_path/parser.inc.php");
//	require_once("$class_path/XMLlist.class.php");

	if (!empty($sutrs_lang)) {
    	// functions server specific
    	require_once("$include_path/sutrs_zserver/$sutrs_lang/sutrs_func.php");
    
    	// localisation (fichier XML) (valeur par dfaut)
    	$labels = new XMLlist("$include_path/sutrs_zserver/$sutrs_lang/sutrs.xml", 0);
    	$labels->analyser();
    	$campo = $labels->table;
    
    	//global $fun;
    	// resp.functions (fichier XML) (valeur par dfaut)
    	$funcs = new XMLlist("$include_path/sutrs_zserver/$sutrs_lang/sutrs_authfun.xml", 0);
    	$funcs->analyser();
    	$fun = $funcs->table;
	}
	if (function_exists('from_sutrs')) {
    	$notice=from_sutrs($ss,$campo);
    	return $notice;
	}
	return '';
}