<?php

// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: ai_clusters.inc.php,v 1.1.2.1 2025/04/03 09:01:51 qvarin Exp $

use Pmb\AI\Library\Clusters\Clusters;

if (stristr($_SERVER['REQUEST_URI'], ".inc.php")) {
    die("no access");
}

global $class_path, $msg, $charset;
global $start, $current_module, $v_state;

// initialisation de la borne de dpart
if (!isset($start)) {
    $start = 0;
}

$v_state = urldecode($v_state ?? '');

print netbase::get_display_progress_title($msg["nettoyage_operations_ia"]);
print netbase::get_display_progress_subtitle($msg["admin_netbase_ai_clusters"]);

if ($start) {
    showProgressAI();
} else {
    startIndexationAI();
}

function startIndexationAI()
{
    global $spec, $v_state;

    print netbase::build_display_progress(0);
    print netbase::get_current_state_form($v_state, $spec, 'ai_clusters', 1);
}

function showProgressAI()
{
    global $v_state, $spec, $msg;
    global $ai_nb_clusters, $ai_nb_epoch;

    $ai_nb_clusters = intval($ai_nb_clusters);
    $ai_nb_epoch = intval($ai_nb_epoch);

    @set_time_limit(0);

    $clusters = new Clusters();
    $clusters->cleanClusters();
    $clusters->createClusters($ai_nb_clusters, $ai_nb_epoch);

    $spec = $spec - AI_CLUSTERS;
    $v_state .= netbase::get_display_progress_v_state($msg["nettoyage_operations_ia"], $msg['netbase_ai_clusters']);

    print netbase::build_display_progress(100);
    print netbase::get_current_state_form($v_state, $spec);
}
