<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: UsersAPIController.php,v 1.1.2.4.6.3 2025/09/05 09:03:55 dgoron Exp $
namespace Pmb\Users\Controller;

use Pmb\Common\Controller\Controller;
use Pmb\Users\Models\RoleModel;

class UsersAPIController extends Controller
{
    protected $tabs = [];
    
    protected $subTabs = [];
    
    protected $forms = [];
    
    public function getMembersList() : void
    {
        $this->ajaxJsonResponse([
            'users' => \list_users_ui::get_instance()->get_objects_data(),
            'groups' => \list_configuration_users_groups_ui::get_instance()->get_objects_data()
        ]);
    }
    
    public function getModulesList() : void
    {
        \list_modules_ui::set_no_check_rights(true);
        $this->ajaxJsonResponse([
            'modules' => \list_modules_ui::get_instance([], [], ['by' => 'label'])->get_objects_data()
        ]);
    }
    
    /**
     * 
     * @param string $moduleName
     */
    public function getTabsList(string $moduleName)
    {
        if (!isset($this->tabs[$moduleName])) {
            $this->tabs[$moduleName] = [];
            $list_tabs_class_name = "\list_tabs_".$moduleName."_ui";
            if (class_exists($list_tabs_class_name)) {
                $list_tabs_class_name::set_no_check_rights(true);
                $this->tabs[$moduleName] = $list_tabs_class_name::get_instance()->get_objects_data();
            }
        }
        return $this->tabs[$moduleName];
    }
    
    /**
     *
     * @param string $moduleName
     */
    public function getSubTabsList(string $moduleName)
    {
        if (!isset($this->subTabs[$moduleName])) {
            $this->subTabs[$moduleName] = array();
            $list_subtabs_class_name = "\list_subtabs_".$moduleName."_ui";
            if (class_exists($list_subtabs_class_name)) {
                $list_subtabs_class_name::set_no_check_rights(true);
                $list_subtabs_ui = $list_subtabs_class_name::get_instance();
                
                $tabs = $this->getTabsList($moduleName);
                foreach ($tabs as $objects) {
                    foreach($objects as $object) {
                        $list_subtabs_class_name::set_categ($object['categ']);
                        $list_subtabs_class_name::set_sub($object['sub']);
                        $list_subtabs_ui->reload_data();
                        $this->subTabs[$moduleName][$object['label_code']] = $list_subtabs_ui->get_objects_data();
                    }
                }
            }
        }
        return $this->subTabs[$moduleName];
    }
    
    /**
     *
     * @param string $moduleName
     */
    public function getActionsList(string $moduleName) : void
    {
        $actions = array();
        
//         $file = __DIR__ . "/../Models/Actions/manifest.xml";
//         if (is_file($file)) {
//             $manifest = new RolesParserManifest($file);
//         }
        $this->ajaxJsonResponse([
            'actions' => $actions
        ]);
    }
    
    /**
     *
     * @param string $moduleName
     */
    public function getFormsList(string $moduleName)
    {
        if (!isset($this->forms[$moduleName])) {
            $list_forms_ui = new \list_forms_ui(['modules' => [$moduleName]]);
            $list_forms_ui->set_applied_group(['categ', 'sub', 'url_extra']);
            $this->forms[$moduleName] = $list_forms_ui->get_objects_data();
        }
        return $this->forms[$moduleName];
    }
    
    /**
     * 
     * @param array $forms
     * @return array
     */
    public function getActionsFormsRightsList($forms)
    {
        $actions = [];
        foreach ($forms as $form) {
            $actions_buttons = $form['object']->get_actions_buttons();
            foreach ($actions_buttons as $action_button) {
                $form['button'] = $action_button;
                $actions[] = $form;
            }
        }
        return $actions;
    }
    
    /**
     *
     * @param string $moduleName
     */
    public function getRightsList(string $moduleName) : void
    {
        $rights = [];
        \list_role_rights_ui::set_module_name($moduleName);
        $list_role_rights_tabs_subtabs_ui = new \list_role_rights_tabs_subtabs_ui();
        $list_role_rights_tabs_subtabs_ui->set_applied_group([0 => 'section_label']);
        $rights['tabs_subtabs'] = $list_role_rights_tabs_subtabs_ui->get_objects_data();
        
        $list_role_rights_actions_ui = new \list_role_rights_actions_ui();
        $list_role_rights_actions_ui->set_applied_group([0 => 'section_label']);
        $rights['actions'] = $list_role_rights_actions_ui->get_objects_data();

        $this->ajaxJsonResponse([
            'rights' => $rights
        ]);
    }
    
    /**
     * enregistrement d'un rle
     */
    public function saveRole() : void
    {
        global $msg;
        
        $roleModel = new RoleModel($this->data->id);
        $roleModel->setPropertiesFromForm($this->data);
        $succes = $roleModel->save();
        
        if ($succes) {
            $this->ajaxJsonResponse([
                'succes' => true
            ]);
        }
        $this->ajaxError($msg['common_failed_save']);
    }
    
    /**
     * suppresion d'un rle
     */
    public function deleteRole() : void
    {
        global $msg;

        $roleModel = new RoleModel($this->data->id);
        $succes = $roleModel->delete();
        if ($succes) {
            $this->ajaxJsonResponse([
                'succes' => true
            ]);
        }
        $this->ajaxError($msg['common_failed_save']);
    }
}