<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: SEOSitemapController.php,v 1.5.2.2 2026/01/09 15:16:01 rtigero Exp $
namespace Pmb\SEO\Controller;

use Pmb\Common\Views\VueJsView;
use Pmb\SEO\Models\SEOSitemapEntry;

class SEOSitemapController extends SEOController
{
    /**
     * {@inheritDoc}
     * @see \Pmb\SEO\Controller\SEOController::defaultAction()
     */
    protected function defaultAction()
    {
        $viewData = $this->getViewBaseData();
        $view = new VueJsView("seo/sitemap", $viewData);
        print $view->render();
    }

    protected function getViewBaseData(): array
    {
        return array_merge(parent::getViewBaseData(), $this->getSitemapData());
    }

    private function getSitemapData(): array
    {
        return array(
            'sitemap_entries' => SEOSitemapEntry::getSitemapEntries()
        );
    }

    private function getEntryClassname(string $type): string
    {
        $classname = "Pmb\\SEO\\Models\\Entries\\SEOSitemapEntry" . ucfirst($type);
        if (class_exists($classname)) {
            return $classname;
        }
        return '';
    }

    public function getData(string $type)
    {
        $classname = $this->getEntryClassname($type);
        if ($classname && method_exists($classname, 'getData')) {
            $this->ajaxJsonResponse($classname::getData($type));
            return;
        }
        $this->ajaxError("Unknown type: " . $type);
    }

    public function save(string $type)
    {
        $classname = $this->getEntryClassname($type);
        if ($classname) {
            $this->data->id = intval($this->data->id);
            $entry = new $classname($this->data->id);
            $result = $entry->check($this->data);
            if ($result['error']) {
                $this->ajaxError($result['errorMessage']);
                exit();
            }

            $entry->setFromForm($this->data);
            if (0 == $this->data->id) {
                $entry->create();
            } else {
                $entry->update();
            }
            $this->ajaxJsonResponse($entry);
        }
    }
    public function getChildren(string $type, int $id)
    {
        $classname = $this->getEntryClassname($type);
        if ($classname) {
            $entry = new $classname($id);
            $entry->initChildren();
            $this->ajaxJsonResponse($entry->childs);
        }
    }

    public function deleteChildren(string $type, int $id)
    {
        $classname = $this->getEntryClassname($type);
        if ($classname) {
            $entry = new $classname($id);
            $entry->clearChildren();
        }
        $this->ajaxJsonResponse(array("success" => true));
    }

    public function delete(string $type, int $id)
    {
        $classname = $this->getEntryClassname($type);
        if ($classname) {
            $entry = new $classname($id);
            $entry->delete();
        }
        $this->ajaxJsonResponse(array("success" => true));
    }

    public function reset()
    {
        SEOSitemapEntry::resetHierarchy();
        $this->ajaxJsonResponse($this->getViewBaseData());
    }
}
