<?php

// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: ConfigController.php,v 1.1.2.1 2025/10/21 08:22:46 qvarin Exp $

namespace Pmb\Ocr\Controller;

use Pmb\Common\Controller\Controller;
use Pmb\Ocr\Library\Ocr\OCRMyPdf;
use Pmb\Ocr\Library\Server\OcrServer;
use Pmb\Ocr\Views\OcrView;

class ConfigController extends Controller
{
    public function proceed($action = "")
    {
        switch ($action) {
            default:
                $this->showForm();
                break;
        }
    }

    protected function showForm()
    {
        global $pmb_url_base, $pmb_ocr_active;

        if ($pmb_ocr_active) {
            $ocrMyPdf = new OCRMyPdf();
            $ocrView = new OcrView("Ocr/config", [
                'url_webservice' => $pmb_url_base . "rest.php/ocr/",
                'ocr_config' => $ocrMyPdf->getConfig()
            ]);
            print $ocrView->render();
        }
    }
}