<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: ChunkCSV.php,v 1.9.2.2 2025/06/27 14:20:54 rtigero Exp $

namespace Pmb\ImportExport\Models\Chunks\ChunkCSV;

use encoding_normalize;
use Pmb\ImportExport\Models\Chunks\Chunk;

class ChunkCSV extends Chunk
{

    protected $headerLine = 0;
    protected $startLine = 0;
    protected $headers = [];

    protected function initialize()
    {
        if (!$this->isInitialized) {
            $this->isInitialized = true;

            $this->initializeStream();

            $this->headerLine = intval($this->parameters["headerline"] ?? 0);
            $this->startLine = intval($this->parameters["startline"] ?? 0);
        }
    }


    public function next()
    {
        $this->initialize();

        $resource = fopen($this->uri, $this->mode, false, $this->context);
        if (!$resource) {
            yield null;
        }

        // Construction de l'entete si on a un numero de ligne pour le header
        if($this->headerLine) {
            $hl = max(0, $this->headerLine - 1);
            while (!feof($resource) &&  $hl) {
                fgetcsv($resource, null, $this->parameters["separator"], $this->parameters["enclosure"]);
                $hl--;
            }

            if(!feof($resource)) {
                $row = fgetcsv($resource, null, $this->parameters["separator"], $this->parameters["enclosure"]);
                if(is_array($row)) {
                    array_walk($row, function (&$value, $key) {
                        $value = encoding_normalize::charset_normalize($value, encoding_normalize::detect_encoding($value, ["UTF-8", "ISO-8859-1", "ISO-8859-15", "cp1252"]));
                        $value = strip_empty_chars($value);
                        $value = preg_replace("/\s/", "_", $value);
                        if ($value == "") {
                            $value = "col_" . (intval($key) + 1);
                        }
                    });
                    $this->headers = $row;
                }
            }
        }

        // Placement sur la ligne de debut
        if ($this->startLine && ($this->startLine > $this->headerLine)) {

            $sl = max(0, $this->startLine - $this->headerLine -1);
            while (!feof($resource) &&  $sl) {
                fgetcsv($resource, null, $this->parameters["separator"], $this->parameters["enclosure"]);
                $sl--;
            }
        }

        $currentContent = '';
        $enclosure = $this->parameters['enclosure'] ?? '';
        $separator = $this->parameters['separator'] ?? ',';
        $glue = $enclosure . $separator . $enclosure;

        while (! feof($resource)) {
            $row = fgetcsv($resource, null, $this->parameters["separator"], $this->parameters["enclosure"]);
            if ($row !== false) {
                if (count($this->headers)) {
                    $currentContent = $enclosure . implode($glue, $this->headers) . $enclosure . "\r\n";
                }
                $currentContent .= $enclosure . implode($glue, $row) . $enclosure. "\r\n";

                yield $currentContent;
                $currentContent = '';
            }

        }

        fclose($resource);
    }

}
