<?php
// +-------------------------------------------------+
// | 2002-2007 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: HelperImportExport.php,v 1.1.2.2 2025/06/27 14:21:03 rtigero Exp $
namespace Pmb\ImportExport\Helper;

class HelperImportExport
{
    public static function isURI(string $value, array $namespaces = []): bool
    {
        //Trouve t-on un des namespaces du store ?

        foreach ($namespaces as $namespace) {
            if (strpos($value, $namespace) !== false) {
                return true;
            }
        }

        //On explose sur le "#" et si la partie gauche est une URL et la partie droite un numerique
        //On considre que c'est une URI
        if (strpos($value, "#") !== false) {
            $parts = explode("#", $value);
            if (filter_var($parts[0], FILTER_VALIDATE_URL) && is_numeric($parts[1])) {
                return true;
            }
            //Petit cas particulier pour les URI temporaires
            if (strpos($parts[1], "_temp_") !== false) {
                return true;
            }
        }

        return false;
    }

    /**
     * Indique si la valeur passe en paramtre corresponsa  un des namespaces
     * @param string $value
     * @param array $namespaces
     *
     * @return bool
     */
    public static function isNamespace(string $value, array $namespaces = []): bool
    {
        foreach ($namespaces as $namespace) {
            if (strpos($value . ":", $namespace) === 0) {
                return true;
            }
        }
        return false;
    }
}
