<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: Collection.php,v 1.7.2.2 2025/06/12 09:13:52 rtigero Exp $

namespace Pmb\Docnums\Models;

use Pmb\Common\Helper\Helper;
use Pmb\Common\Models\Model;
use Pmb\Docnums\Orm\ExplnumCollectionsExplnumsOrm;

class Collection extends Model
{
    protected $ormName = "Pmb\Docnums\Orm\ExplnumCollectionsOrm";

    public $id = 0;
    public $idExplnumCollection = 0;
    public $name = "";
    public $uploadFolderId = 0;
    public $explnums = array();

    public function __construct($id = 0)
    {
        parent::__construct($id);
    }

    public function setFromForm($data)
    {
        $this->id = $data->id ?? 0;
        $this->name = $data->name;
        $this->uploadFolderId = $data->uploadFolderId;
    }

    public function save()
    {
        $orm = new $this->ormName($this->id);
        $orm->name = $this->name;
        $orm->upload_folder_id = $this->uploadFolderId;
        $orm->save();

        $this->id = $orm->{$this->ormName::$idTableName};
        $this->{Helper::camelize($this->ormName::$idTableName)} = $orm->{$this->ormName::$idTableName};
    }

    public function delete()
    {
        $this->fetchExplnums();
        //On supprime les exemplaires de la collection
        foreach ($this->explnums as $explnum) {
            $explnum->delete();
        }

        if ($this->ormName::exist($this->id)) {
            $orm = new $this->ormName($this->id);
            $orm->delete();
            return true;
        }
        return false;
    }

    public function fetchExplnums()
    {
        if ($this->id) {
            $explnums = ExplnumCollectionsExplnumsOrm::find("explnum_collections_explnums_num_collection", $this->id);
            foreach ($explnums as $explnum) {
                $expl = new Explnum($explnum->{ExplnumCollectionsExplnumsOrm::$idTableName});

                // On vide les props avec des blob pour viter les soucis de caractre et on en a pas besoin
                $expl->explnum_vignette = "";
                $expl->explnum_data = "";
                $expl->explnumCollections->explnumCollectionsExplnumsData = "";
                $expl->explnumCollections->explnumCollectionsExplnumsVignette = "";

                $this->explnums[] = $expl;
            }
        }
    }
}
