<?php

// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: RecordRMCSelector.php,v 1.15.2.2.4.1.2.2 2025/09/17 13:46:36 rtigero Exp $

namespace Pmb\DSI\Models\Selector\Item\Entities\Record\RMC;

use Pmb\DSI\Models\Selector\SubSelector;
use search;
use notice;

class RecordRMCSelector extends SubSelector
{
	public const CONTENT_NOTICE_TITLE = 0;

	public const CONTENT_NOTICE_DETAIL = 1;

	public const NB_NOTICES_THRESHOLD = 500;

	public $selector = null;

	public $data = [];

	public function __construct($selectors = null)
	{
		if (!empty($selectors)) {
			$this->data = $selectors->data ?? [];
		}

		parent::__construct($selectors);
	}

	public function getResults(): array
	{
		if (empty($this->data->search_serialize)) {
			return [];
		}

		if (isset($this->results)) {
			return $this->results;
		}

		$search = new search();
		$search->unserialize_search($this->data->search_serialize);
		$tempTable = $search->make_search();

		$query = "SELECT * FROM " . $tempTable . " JOIN notices ON $tempTable.notice_id = notices.notice_id";

		$this->results = $this->getFormatedResults($query, 'notice_id');

		// Souci de table tempo pas encore supprimee -> on force donc la suppression
		if (! empty($tempTable)) {
			$query = "DROP TABLE IF EXISTS " . $tempTable;
			pmb_mysql_query($query);
		}

		return $this->results;
	}

	public function getData($short = false): array
	{
		if (empty($this->data) && !empty($this->selector)) {
			return $this->selector->getData($short);
		}

		return $this->sortResults($this->getRMCResult($short ? RecordRMCSelector::CONTENT_NOTICE_TITLE : RecordRMCSelector::CONTENT_NOTICE_DETAIL));
	}

	protected function getRMCResult(int $contentType = RecordRMCSelector::CONTENT_NOTICE_TITLE): array
	{
		$records = [];
		if (!isset($this->data->search_serialize)) {
			return $records;
		}

		$results = $this->getResults();
		//Si on a plus de 500 notices on force le titre sinon ca prend trop de memoire
		if (count($results) > static::NB_NOTICES_THRESHOLD) {
			$contentType = RecordRMCSelector::CONTENT_NOTICE_TITLE;
		}
		$ids = array_keys($results);
		switch ($contentType) {
			case RecordRMCSelector::CONTENT_NOTICE_TITLE:
				foreach ($ids as $id) {
					$records[$id] = notice::get_notice_title($id);
				}
				break;
			case RecordRMCSelector::CONTENT_NOTICE_DETAIL:
				foreach ($ids as $id) {
					$notice = new notice($id);
					$records[$id] = gen_plus($id, notice::get_notice_title($id), $notice->get_detail());
				}
				break;
			default:
				break;
		}
		return $records;
	}

	/**
	 * Retourne la recherche effectuer pour l'affichage.
	 *
	 * @return string
	 */
	public function getSearchInput(): string
	{
		if (isset($this->searchInput)) {
			return $this->searchInput;
		}

		$this->searchInput = $this->data->human_query ?? "";
		return $this->searchInput;
	}

	/**
	 * Retourne la recherche effectuer pour l'affichage avec la vue en dtail de chaque elements.
	 *
	 * @return array
	 */
	public function trySearch()
	{
		return $this->getRMCResult(RecordRMCSelector::CONTENT_NOTICE_DETAIL);
	}
}
