<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: Event.php,v 1.2.12.1 2025/11/04 15:07:47 qvarin Exp $
namespace Pmb\Common\Event;

global $class_path;
require_once $class_path . '/event/event.class.php';

class Event extends \event
{

    public const EMPTY_VALUE = null;

    protected $context = array();

    protected $data = self::EMPTY_VALUE;

    public function setData($data)
    {
        $this->data = $data;
    }

    public function getData()
    {
        return $this->data ?? self::EMPTY_VALUE;
    }

    public function setContext(array $context)
    {
        $this->context = $context;
    }

    public function getContext()
    {
        return $this->context;
    }

    public function dispatch()
    {
        $evth = \events_handler::get_instance();
        $evth->send($this);
    }
}