<?php

// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: Agent.php,v 1.1.2.6 2025/04/11 07:36:26 qvarin Exp $

namespace Pmb\AI\Library\Services;

if (stristr($_SERVER['REQUEST_URI'], '/'.basename(__FILE__))) {
    die("no access");
}

interface Agent
{
    /**
     * Set parameters
     *
     * @param array $parameters
     * @return void
     */
    public function setParameters(array $parameters): void;

    /**
     * Get parameters
     *
     * @return array
     */
    public function getParameters(): array;

    /**
     * Convert text to embeddings
     *
     * @param string|array $text
     * @return array
     */
    public function textToEmbeddings(string|array $text): array;

    /**
     * Chat
     *
     * @param string $promptSystem
     * @param string $promptUser
     * @return string
     */
    public function chat(string $promptSystem, string $promptUser): string;

    /**
     * Check parameters
     *
     * @param array $parameters
     * @return boolean
     */
    public function checkParameters(array $parameters): bool;
}
