<?php

// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: AiParserManifest.php,v 1.1.2.5 2025/04/11 08:58:47 qvarin Exp $

namespace Pmb\AI\Library\Parser;

if (stristr($_SERVER['REQUEST_URI'], '/'.basename(__FILE__))) {
    die("no access");
}

class AiParserManifest
{
    public const XML_LIST_MANIFEST = __DIR__ . "/../Services/manifest.xml";

    /**
     * Retourne la liste des services
     * @return array
     */
    public static function parseServicesList(): array
    {
        $xml = simplexml_load_file(self::XML_LIST_MANIFEST);
        $services = array();
        foreach ($xml->services->service as $service) {
            $services[intval((int) $service->attributes()->id)]["name"] = get_msg_to_display((string) $service->attributes()->name);
            $services[intval((int) $service->attributes()->id)]["component"] = (string) $service->attributes()->component;
            $services[intval((int) $service->attributes()->id)]["namespace"] = (string) $service->attributes()->namespace;
        }
        return $services;
    }
}
