<?php

// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: AiSearcherFacetsCompare.php,v 1.1.2.1 2026/01/29 14:42:23 qvarin Exp $

namespace Pmb\AI\Library;

if (stristr($_SERVER['REQUEST_URI'], '/'.basename(__FILE__))) {
    die("no access");
}

use facette_search_compare;

class AiSearcherFacetsCompare extends facette_search_compare {

    /**
     * @return string les script js utile pour le comparateur
     */
    public static function get_compare_wrapper(){
        global $base_path;

        $script="
            function valid_facettes_compare(){

                var form = document.facettes_multi;
                if(form.elements.length>0){

                    var form_values_compare_input_array=new Array();

                    for(var i=0; i<form.elements.length;i++){

                        if(form.elements[i].name=='check_facette[]' && form.elements[i].checked){
                            //on transforme les case  coch en element du tableau des facettes
                            //on ajoute dans le tableau des facettes
                            var value=form.elements[i].value;
                            var jsonArray=JSON.parse(value);

                            //On ajoute dans le formulaire de postage gnral
                            var form_values_compare_input=document.createElement('input');
                            form_values_compare_input.setAttribute('name','check_facette_compare[]');
                            form_values_compare_input.setAttribute('type','hidden');
                            form_values_compare_input.setAttribute('value',value);
                            form_values_compare_input_array.push(form_values_compare_input);
                        }
                    }

                    var post=false;
                    var form_values=document.form_values;
                    for(var i=0;i<form_values_compare_input_array.length;i++) {
                        form_values.appendChild(form_values_compare_input_array[i]);
                    }

                    for(var i=0; i<form_values.elements.length;i++){
                        if(form_values.elements[i].name=='check_facette_compare[]' && form_values.elements[i].value!=''){
                            if(document.getElementById('filtre_compare_facette')) {
                                document.getElementById('filtre_compare_facette').value='compare';
                            }
                            if(document.getElementById('filtre_compare_form_values')) {
                                document.getElementById('filtre_compare_form_values').value='compare';
                            }
                            form_values.submit();
                            post=true;
                        }
                    }
                    if(post == false){
                        alert(pmbDojo.messages.getMessage('facettes', 'facette_compare_not_selected'));
                    }
                }else{
                    alert(pmbDojo.messages.getMessage('facettes', 'facette_compare_not_selected'));
                }
            }

            function valid_compare(){
                var form_values=document.form_values;
                var post=false;

                for(var i=0; i<form_values.elements.length;i++){
                    if(form_values.elements[i].name=='check_facette_compare[]' && form_values.elements[i].value!=''){
                        if(document.getElementById('filtre_compare_facette')) {
                            document.getElementById('filtre_compare_facette').value='compare';
                        }
                        if(document.getElementById('filtre_compare_form_values')) {
                            document.getElementById('filtre_compare_form_values').value='compare';
                        }
                        form_values.submit();
                        post=true;
                    }
                }
                if(post == false){
                    alert(pmbDojo.messages.getMessage('facettes', 'facette_compare_not_selected'));
                }
            }

            function remove_compare_facette(value){

                var jsonArray = JSON.parse(value);

                //on supprime l'lement du tableau des facettes
                elem=document.getElementById('compare_facette_'+jsonArray[4]);
                elem.parentNode.removeChild(elem);

                //on supprime l'lment du formulaire gnral aussi
                var form_values=document.form_values;
                for(var i in form_values.elements){
                    if(form_values.elements[i] && form_values.elements[i].value && form_values.elements[i].name=='check_facette_compare[]'){
                        form_values_json_array=JSON.parse(form_values.elements[i].value);

                        if(form_values_json_array[4]==jsonArray[4]){
                            elem=form_values.elements[i];
                            elem.parentNode.removeChild(elem);
                        }
                    }
                }
                var post=true;
                for(var i in form_values.elements){
                    if(form_values.elements[i] && form_values.elements[i].value && form_values.elements[i].name=='check_facette_compare[]'){
                        valid_facettes_compare();
                        post=false;
                    }
                }

                if (post) {
                    document.location.href='".$base_path."/index.php?lvl=search_result&search_type_asked=ai_search&get_last_query=1&reinit_compare=1';
                }
            }

            function group_by(groupBy){

                var jsonArray=JSON.parse(groupBy);

                //on vide les elements group_by
                var group_by_elements=document.getElementsByName('check_facette_groupby[]');

                var nodes_to_remove;

                for(var i in group_by_elements){
                    if(group_by_elements[i].nodeName=='INPUT'){
                        if(group_by_elements[i].getAttribute('id')!='facette_groupby_'+jsonArray[3]){

                            if(group_by_elements[i].parentNode.getAttribute('name')!='form_values' && group_by_elements[i].parentNode.getAttribute('name')!='cart_values'){
                                var group_by_elements_img=group_by_elements[i].previousElementSibling.firstChild;

                                group_by_elements_img.setAttribute('src','".get_url_icon('group_by_grey.png')."');
                                group_by_elements[i].setAttribute('value','');

                            }else{
                                nodes_to_remove=[i=[group_by_elements[i],group_by_elements[i].parentNode]];
                            }
                        }
                    }
                }

                if(nodes_to_remove && nodes_to_remove.length>0){
                    for(var i in nodes_to_remove){
                        nodes_to_remove[i][1].removeChild(nodes_to_remove[i][0]);
                    }
                }

                element=document.getElementById('facette_groupby_'+jsonArray[3]);
                var img=element.previousElementSibling.firstChild;

                var table_groupby=document.getElementById('facette_groupby');

                if(element.getAttribute('value')==''){
                    element.setAttribute('value',JSON.stringify(groupBy));

                    //On ajoute dans le formulaire de postage gnral
                    var form_values=document.form_values;
                    var form_values_groupby_input=document.createElement('input');
                    form_values_groupby_input.setAttribute('name','check_facette_groupby[]');
                    form_values_groupby_input.setAttribute('type','hidden');
                    form_values_groupby_input.setAttribute('value',groupBy);
                    form_values.appendChild(form_values_groupby_input);


                }
                valid_facettes_compare();
            }
        ";

        return $script;
    }

}