<?php

// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: musicme.class.php,v 1.3.2.4 2025/11/28 09:50:51 dbellamy Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) {
    die("no access");
}

global $class_path, $base_path;
require_once $class_path . '/connecteurs.class.php';
require_once $class_path . '/curl.class.php';
require_once $base_path . '/admin/connecteurs/in/musicme/MusicMeApiClient.php';
/**
 * Connecteur MusicMe
 * Permet l'enrichissement des notices avec des liens vers le streaming MusicMe
 */
class musicme extends connector
{
    /**
     * URL de connexion MusicMe
     */
    public const MUSICME_BASE_URL = "https://app.mt.musicme.com";

    /**
     * URL des pochettes d'albums
     */
    public const COVER_BASE_URL = "https://covers.hosting-media.net";

    /**
     * Recherche MusicMe
     */
    public const MUSICME_SEARCH_FIELDS = [
        'XXX'   => "Tous les champs",
        '010$a' => "EAN",
        '200$a' => "album",
        '7XX'   => "artistes",
        '210$c214$c219$c' => 'label',
        '650$a' => "genre",
        '260$c' => "date"
    ];

    /**
     * Type de document
     */
    public const MUSICME_TYPE_DOC = "j";

    /**
     * Client MusicMe
     */
    protected $musicme_client = null;

    /**
     * Buffer
     */
    protected $buffer = [];

    /**
     * Nombre max de resultats
     */
    protected $musicme_max_results = 100;

    /**
     * Configuration MusicMe
     */
    protected $config = null;
    /**
     * {@inheritDoc}
     */
    public function get_id()
    {
        return "musicme";
    }

    /**
     * Recupere les proprietes de la source
     *
     * @param int $source_id
     * @return array
     */
    protected function fetch_parameters($source_id)
    {
        $params = $this->get_source_params($source_id);
        if (empty($params['PARAMETERS'])) {
            return [];
        }
        return unserialize($params['PARAMETERS']);
    }

    /**
     * Formulaire pour les proprietes de la source
     *
     * @param int $source_id
     * @return string
     */
    public function source_get_property_form($source_id)
    {
        global $charset;

        $parameters = $this->fetch_parameters($source_id);

        $musicme_url = $parameters['musicme_url'] ?? 'https://app.mt.musicme.com';

        return '
        <div class="row">
            <div class="colonne3">
                <label for="musicme_url">'.htmlentities($this->msg['musicme_url'], ENT_QUOTES, $charset).'</label>
            </div>
            <div class="colonne_suite">
                <input type="text" required class="saisie-30em" name="musicme_url" id="musicme_url" placeholder="https://app.mt.musicme.com" value="'. htmlentities($musicme_url, ENT_QUOTES, $charset) .'">
            </div>
        </div>
        <div class="row">
            <div class="colonne3">
                <label for="musicme_url_server_cas">'.htmlentities($this->msg['musicme_url_server_cas'], ENT_QUOTES, $charset).'</label>
            </div>
            <div class="colonne_suite">
                <input type="text" class="saisie-50em" name="musicme_url_server_cas" id="musicme_url_server_cas" value="'.htmlentities($parameters['musicme_url_server_cas'] ?? '', ENT_QUOTES, $charset).'">
            </div>
        </div>
        <div class="row">
            <div class="colonne3">&nbsp;</div>
            <div class="colonne_suite">
                <small>'.htmlentities($this->msg['musicme_url_help'], ENT_QUOTES, $charset).'</small>
            </div>
        </div>
        <div class="row">
            <div class="colonne3">
                <label for="musicme_api_url_server">'.htmlentities($this->msg['musicme_api_url_server'], ENT_QUOTES, $charset).'</label>
            </div>
            <div class="colonne_suite">
                <input type="text" class="saisie-50em" name="musicme_api_url_server" id="musicme_api_url_server" value="'.htmlentities($parameters['musicme_api_url_server'] ?? '', ENT_QUOTES, $charset).'">
            </div>
        </div>
        <div class="row">
            <div class="colonne3">
                <label for="musicme_api_salt_key">'.htmlentities($this->msg['musicme_api_salt_key'], ENT_QUOTES, $charset).'</label>
            </div>
            <div class="colonne_suite">
                <input type="password" class="saisie-50em" name="musicme_api_salt_key" id="musicme_api_salt_key" value="'.htmlentities($parameters['musicme_api_salt_key'] ?? '', ENT_QUOTES, $charset).'">
                <span class="fa fa-eye" onclick="toggle_password(this, \'musicme_api_salt_key\');"></span>
            </div>
        </div>
        <div class="row">
            <div class="colonne3">
                <label for="musicme_api_token_key">'.htmlentities($this->msg['musicme_api_token_key'], ENT_QUOTES, $charset).'</label>
            </div>
            <div class="colonne_suite">
                <input type="password" class="saisie-50em" name="musicme_api_token_key" id="musicme_api_token_key" value="'.htmlentities($parameters['musicme_api_token_key'] ?? '', ENT_QUOTES, $charset).'">
                <span class="fa fa-eye" onclick="toggle_password(this, \'musicme_api_token_key\');"></span>
            </div>
        </div>
        <div class="row">&nbsp;</div>
        <h3>' . htmlentities($this->msg['musicme_search_params'], ENT_QUOTES, $charset) . '</h3>
        <div class="row">&nbsp;</div>
        <div class="row">
            <div class="colonne3">
                <label for="musicme_max_results" >' . htmlentities($this->msg['musicme_max_results'], ENT_QUOTES, $charset) . '</label>
            </div>
            <div class="colonne_suite">
                <input type="number" step="1" min="0" name="musicme_max_results" id="musicme_max_results" class="saisie-10em" value="' . $parameters['musicme_max_results'] . '" />
            </div>
        </div>
    ';
    }

    /**
     * Recupere les proprietes de la source
     *
     * @param int $source_id
     * @return void
     */
    public function make_serialized_source_properties($source_id)
    {
        global $musicme_url, $musicme_max_results, $musicme_api_url_server, $musicme_api_salt_key, $musicme_api_token_key, $musicme_url_server_cas;

        $params = [
            'musicme_url' => trim($musicme_url),
            'musicme_max_results' => intval($musicme_max_results),
            'musicme_api_url_server' => trim($musicme_api_url_server),
            'musicme_api_salt_key' => trim($musicme_api_salt_key),
            'musicme_api_token_key' => trim($musicme_api_token_key),
            'musicme_url_server_cas' => trim($musicme_url_server_cas),
        ];

        $this->sources[$source_id]['PARAMETERS'] = serialize($params);
    }

    /**
     * Formulaire pour les proprietes globales du connecteur
     *
     * @return string
     */
    public function get_property_form()
    {
        return '';
    }

    /**
     * Recherche
     *
     * @param int $source_id : Id source
     * @param array $query : Tableau parametres recherche
     * @param string $search_id : Id recherche
     */
    public function search($source_id, $query, $search_id)
    {
        $this->get_musicme_config();

        // check parametres
        $source_id = intval($source_id);
        if (!$source_id) {
            return;
        }
        if (!is_array($query) || empty($query)) {
            return;
        }

        // instanciation client
        $client = $this->get_client($source_id);

        // construction recherche
        for ($i = 0 ; $i < count($query) ; $i++) {

            $done = false;
            $j = 0;
            $search_mapping = $this->getSearchMapping($query[$i]->ufield, $query[$i]->values[0] ?? "");

            while (!$done) {
                if (!isset($search_mapping['query_params']['offset'])) {
                    $search_mapping['query_params']['offset'] = 0;
                } else {
                    $search_mapping['query_params']['offset'] += 100;
                }
                $search_results = $client->search($search_mapping['query_params']);
                if (empty($search_results['data'])) {
                    break;
                }
                $this->prepare_records($source_id, $search_id, $search_results);
                $this->rec_records($source_id, $search_id);

                if ($search_results['offset'] + $search_results['limit'] >= $search_results['total']) {
                    $done = true;
                }
                if ($search_results['offset'] + $search_results['limit'] >= $this->musicme_max_results) {
                    $done = true;
                }
                $j++;
                if ($j > 10) {
                    $done = true;
                }
            }
        }
    }

    /**
     * Instanciation client API
     *
     * @param int $source_id
     */
    protected function get_client(int $source_id)
    {
        if (null === $this->musicme_client) {
            $params = $this->unserialize_source_params($source_id);

            $this->musicme_client = new MusicMeApiClient(
                $params['PARAMETERS']['musicme_api_url_server'],
                $params['PARAMETERS']['musicme_api_salt_key'],
                $params['PARAMETERS']['musicme_api_token_key'],
            );
        }
        return $this->musicme_client;
    }

    protected function getSearchMapping($field, $value)
    {
        $search_mapping = [
        'query_params' => [],
        'method' => 'search'
        ];
        // Map field codes to MusicMe API query parameters
        switch ($field) {
            case 'XXX': // Tous les champs - general search
            case '010$a': // barcode
                $search_mapping['query_params'] = [
                    'scope' => 'barcode',
                    'q' => $value
                ];
                break;
            case '200$a': // Album
                $search_mapping['query_params'] = [
                    'scope' => 'title',
                    'q' => $value
                ];
                break;
            case '7XX': // Artistes
                $search_mapping['query_params'] = [
                    'scope' => 'artists',
                    'q' => $value
                ];
                break;
            case '210$c214$c219$c': // Label
                $search_mapping['query_params'] = [
                    'scope' => 'label_name',
                    'q' => $value
                ];
                break;
            case '650$a': // Style
                $search_mapping['query_params'] = [
                    'scope' => 'styles',
                    'q' => $value
                ];
                break;
            case '210$d': // Date
                $search_mapping['query_params']['filters'][] = [
                    'date_release' => $value
                ];
                break;
            case 'XXX': // Tous les champs - general search
            default:
                // Default to general search
                $search_mapping['query_params'] = [
                    'scope' => 'all',
                    'q' => $value
                ];
                break;
        }
        return $search_mapping;
    }

    protected function format_query($query)
    {
        $query_return = [];
        foreach ($query as $key => $value) {
            $query_return[$key] = $value;
        }
        return $query_return;
    }

    /**
     * Mise en forme des resultats
     *
     * @param int $source_id : Id source
     * @param string $search_id : Id recherche
     * @param array $search_results
     *
     */
    protected function prepare_records($source_id, $search_id, $search_results = [])
    {
        if (empty($search_results['data']) || !is_array($search_results['data'])) {
            return;
        }

        // Traitement des notices
        $records = $search_results['data']['data'];
        foreach ($records as $record) {
            $this->prepare_record($source_id, $search_id, $record);
        }
    }

    protected function prepare_record($source_id, $search_id, $record = [])
    {
        if (empty($record) || !is_array($record)) {
            return;
        }

        // noticeId
        $ref = $record['barcode'];

        // Id deja existant
        if ($this->has_ref($source_id, $ref)) {
            return;
        }

        if (empty($support['typdoc'])) {
            $support['typdoc'] = $this->config['type_doc'] ?? 'j';
        }


        $unimarc_headers = [
            "rs" => "*",
            "ru" => "*",
            "el" => "*",
            "bl" => "m",
            "hl" => "0",
            "dt" => $support['typdoc'],
        ];

        $unimarc_record = [];
        $fo = 0;
        $so = 0;

        // Barcode
        if (!empty($record['barcode'])) {
            $unimarc_record[] = [
                'ufield' => '001',
                'usubfield' => '',
                'value' => $record['barcode'],
                'field_order' => $fo++,
                'subfield_order' => $so,
            ];
        }

        if (!empty($record['barcode'])) {
            $unimarc_record[] = [
                'ufield' => '010',
                'usubfield' => 'a',
                'value' => $record['barcode'],
                'field_order' => $fo++,
                'subfield_order' => $so,
            ];
        }

        // Title
        if (!empty($record['title'])) {
            $unimarc_record[] = [
                'ufield' => '200',
                'usubfield' => 'a',
                'value' => $record['title'],
                'field_order' => $fo++,
                'subfield_order' => $so,
            ];
        }

        // Artists
        if (!empty($record['artists'])) {
            $artists = explode(',', $record['artists']);
            $first = true;
            foreach ($artists as $artist) {
                $unimarc_record[] = [
                    'ufield' => $first ? '700' : '701',
                    'usubfield' => 'a',
                    'value' => $artist,
                    'field_order' => $fo++,
                    'subfield_order' => $so,
                ];
                $first = false;
            }
        }

        // Styles
        if (!empty($record['styles'])) {
            $unimarc_record[] = [
                'ufield' => '610',
                'usubfield' => 'a',
                'value' => $record['styles'],
                'field_order' => $fo++,
                'subfield_order' => $so,
                ];
        }

        //label
        if (!empty($record['label_name'])) {
            $unimarc_record[] = [
                'ufield' => '210',
                'usubfield' => 'c',
                'value' => $record['label_name'],
                'field_order' => $fo++,
                'subfield_order' => $so,
            ];
        }

        //date
        if (!empty($record['date_release'])) {
            $date = \DateTime::createFromFormat("U", $record['date_release']);
            $unimarc_record[] = [
                'ufield' => '210',
                'usubfield' => 'd',
                'value' => $date->format("Y-m-d"),
                'field_order' => $fo++,
                'subfield_order' => $so,
            ];
        }

        // url
        if (!empty($record['url'])) {
            $unimarc_record[] = [
                'ufield' => '856',
                'usubfield' => 'u',
                'value' => $record['url'],
                'field_order' => $fo++,
                'subfield_order' => $so,
            ];
        }

        $this->buffer['records'][$ref]['header'] = $unimarc_headers;
        $this->buffer['records'][$ref]['content'] = $unimarc_record;
    }

    protected function get_musicme_config()
    {
        if (isset($this->config)) {
            return $this->config;
        }
        $contents = [];
        $search_fields_file = __DIR__.'/musicme.json';
        if (is_readable($search_fields_file)) {
            $contents = file_get_contents($search_fields_file);
            $this->config = encoding_normalize::json_decode($contents, true);
        }
        return $this->config;
    }

    /**
     * Enregistrement des notices dans l'entrepot
     */
    protected function rec_records($source_id, $search_id)
    {
        if (empty($this->buffer['records'])) {
            return;
        }
        $this->buffer['source_id'] = $source_id;
        $this->buffer['search_id'] = $search_id;
        $date_import = date("Y-m-d H:i:s", time());
        $this->buffer['date_import'] = $date_import;

        foreach ($this->buffer['records'] as $ref => $record) {
            $this->buffer['records'][$ref]['recid'] = $this->insert_into_external_count($this->buffer['source_id'], $ref);
        }

        $this->insert_records_into_entrepot($this->buffer);
    }

    /**
     * Gnration du lien de la notice
     */
    public static function get_resource_link($ref, $params)
    {
        if (empty($params['source_id']) || empty($params['empr_id']) || empty($params['link']) || empty($params['link'])) {
            return "";
        }
        $musicme = new self();
        $musicme_params = $musicme->unserialize_source_params($params['source_id']);
        $link = str_replace("http://www.musicme.com", "https://pmb.mt.musicme.com", $params['link']);
        return $musicme_params['PARAMETERS']['musicme_url_server_cas'] . "?service=" . urlencode($link . "?service=ml-pmb&mode=cas");
    }
}
