<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: ajax_main.inc.php,v 1.7.10.1 2025/12/03 07:33:11 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".inc.php")) die("no access");

global $class_path, $categ, $sub, $action, $object_type;

$prefix = "gestfic0";
switch($categ){
	case 'fiche':
		include('./fichier/ajax/fiche_ajax.inc.php');
		break;
	case 'dashboard' :
		include("./dashboard/ajax_main.inc.php");
		break;
	case 'plugin' :
		$plugins = plugins::get_instance();
		$file = $plugins->proceed_ajax("fichier",$plugin,$sub);
		if($file){
			include $file;
		}
		break;
	case 'extended_search' :
		require_once($class_path."/search.class.php");
		if(!isset($search_xml_file)) $search_xml_file = '';
		if(!isset($search_xml_file_full_path)) $search_xml_file_full_path = '';
	
		$sc=new search(true, $search_xml_file, $search_xml_file_full_path);
		$sc->proceed_ajax();
		break;
	case 'search':
	case 'search_advanced':
		switch($action) {
			case "list":
				if(isset($object_type) && $object_type) {
					$class_name = 'list_'.$object_type;
					$filters = (!empty($filters) ? encoding_normalize::json_decode(stripslashes($filters),true) : array());
					$pager = (!empty($pager) ? encoding_normalize::json_decode(stripslashes($pager),true) : array());
					$instance_class_name = new $class_name($filters, $pager, array('by' => $sort_by, 'asc_desc' => (isset($sort_asc_desc) ? $sort_asc_desc : '')));
					print encoding_normalize::utf8_normalize($instance_class_name->get_display_header_list());
					print encoding_normalize::utf8_normalize($instance_class_name->get_display_content_list());
				}
				break;
		}
		break;
	case 'custom_fields':
	    switch($sub) {
	        case 'perso':
	            switch($action) {
	                case "list":
	                    require_once "$class_path/custom_fields/custom_fields_controller.class.php";
	                    custom_fields_controller::proceed_ajax($object_type);
	                    break;
	            }
	            break;
	    }
	    break;
}