<?php
// +-------------------------------------------------+
// | 2002-2011 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: resa_planning_circ_controller.class.php,v 1.1.4.6 2025/12/30 09:16:53 gneveu Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

use Pmb\Common\Models\EmprModel;

global $class_path;
require_once($class_path."/resa_planning/resa_planning_controller.class.php");

class resa_planning_circ_controller extends resa_planning_controller {
	
	protected static $list_ui_class_name = 'list_resa_planning_circ_ui';
	
	protected static $resa_check;
	
	protected static $id_empr = 0;
	protected static $id_notice = 0;
	protected static $id_bulletin = 0;
	
	public static function proceed_search_resa() {
	    //TODO : à intégrer plus tard car cela est actuellement difficile avec les require des require..
	}
	
	//Affichage des réservations planifiées sur le document courant par le lecteur courant
	public static function doc_planning_list() {
	    global $msg;
	    
	    $query = "SELECT id_resa, resa_idempr, resa_idnotice, resa_date, resa_date_debut, resa_date_fin, resa_validee, IF(resa_date_fin>=sysdate() or resa_date_fin='0000-00-00',0,1) as perimee ";
	    $query.= "FROM resa_planning ";
	    $query.= "WHERE resa_idempr='".static::$id_empr."' and resa_idnotice='".static::$id_notice."' ";
	    $result = pmb_mysql_query($query);
	    
	    $message_resa = '';
	    if (pmb_mysql_num_rows($result)) {
	        $message_resa .= '<br /><b>'.$msg['resa_planning_enc'].'</b>';
	        while ($resa = pmb_mysql_fetch_array($result)) {
	            $resa_date_debut = $resa['resa_date_debut'];
	            $resa_date_fin = $resa['resa_date_fin'];
	            $message_resa.= "<blockquote><b>".$msg['resa_planning_date_debut']."</b> ".formatdate($resa_date_debut)."&nbsp;<b>".$msg['resa_planning_date_fin']."</b> ".formatdate($resa_date_fin)."&nbsp;" ;
	            if (!$resa['perimee']) {
	                if ($resa['resa_validee']) {
	                    $message_resa.= " ".$msg['resa_validee'] ;
	                } else {
	                    $message_resa.= " ".$msg['resa_attente_validation']." " ;
	                }
	            } else {
	                $message_resa.= " ".$msg['resa_overtime']." " ;
	            }
	            $message_resa.= "</blockquote>" ;
	        }
	    }
	    return $message_resa;
	}
	
	public static function get_display_available_locations() {
	    global $msg, $charset;
	    
	    $display = '';
	    $tab_loc_retrait = resa_planning::get_available_locations(static::$id_empr,static::$id_notice,static::$id_bulletin);
	    if (is_countable($tab_loc_retrait) && count($tab_loc_retrait)) {
	        $display = '<table><tbody><tr><th>'.$msg['resa_planning_loc_retrait'].'</th><th>'.$msg['resa_planning_qty_requested'].'</th></tr>';
	        foreach($tab_loc_retrait as $v) {
	            $display.= '<tr><td style="width:50%">'.htmlentities($v['location_libelle'],ENT_QUOTES,$charset).'</td>';
	            $display.= '<td><select name="location['.$v['location_id'].']">';
	            $v['location_nb'] = intval($v['location_nb']);
	            if(count($tab_loc_retrait) > 1) {
	                for($i=0;$i<$v['location_nb']+1;$i++) {
	                    $display.= '<option value='.$i.' '.($i == 1 ? 'selected="selected"' : '').'>'.$i.'</option>';
	                }
	            } else {
	                for($i=1;$i<$v['location_nb']+1;$i++) {
	                    $display.= '<option value='.$i.'>'.$i.'</option>';
	                }
	            }
	            $display.= '</select></td>';
	            $display.='</tr>';
	        }
	        $display.= '</tbody></table>';
	    }
	    return $display;
	}
	
	public static function proceed_add_resa() {
	    global $msg;
	    global $form_resa_dates, $groupID;
	    
	    $groupID = intval($groupID);
	    
	    if(static::$id_notice) {
	        $display = new mono_display(static::$id_notice, 6, '', 0, '', '', '', 0, 1, 1, 1);
	        print ($display->result);
	    } else if (static::$id_bulletin) {
	        $bull = new bulletinage(static::$id_bulletin);
	        $bull->make_display();
	        print $bull->display;
	    }
	    print "<script type='text/javascript' src='./javascript/tablist.js'></script>\n";
	    
	    // calcul de la date de fin de la prévision à partir du calcul d'une résa
	    $resa_nb_days = reservation::get_time(static::$id_empr, static::$id_notice, static::$id_bulletin);
	    if($resa_nb_days) {
	        $resa_date_fin = date('Y-m-d', strtotime(today(). ' + '.$resa_nb_days.' days'));
	    } else {
	        $resa_date_fin = today();
	    }
	    $form_resa_dates = str_replace('!!resa_date_debut!!', formatdate(today()), $form_resa_dates);
	    $form_resa_dates = str_replace('!!resa_date_fin!!', formatdate($resa_date_fin), $form_resa_dates);
	    $form_resa_dates = str_replace('!!resa_deb!!', today(), $form_resa_dates);
	    $form_resa_dates = str_replace('!!resa_fin!!', $resa_date_fin, $form_resa_dates);
	    
	    $form_loc_retrait = static::get_display_available_locations();
	    if (empty($form_loc_retrait)) {
	        error_message($msg[350], $msg['resa_planning_no_item_available'], 1 , "./circ.php?categ=resa_planning&resa_action=search_resa&mode=0&id_empr=".static::$id_empr."&groupID=$groupID");
	        return;
	    }
	    $form_resa_dates = str_replace ('!!resa_loc_retrait!!', $form_loc_retrait,$form_resa_dates);
	    print $form_resa_dates;
	    
	    //Affichage des previsions sur le document courant par le lecteur courant
	    print static::doc_planning_list();
	}
	
	public static function proceed_add_resa_suite() {
	    global $msg;
	    global $location, $resa_deb, $resa_fin, $empr_cb;
	    
	    $check_qty=0;
	    if(isset($location) && is_array($location)) {
	        foreach($location as $v) {
	            $check_qty+= intval($v);
	        }
	    }
	    if($check_qty==0) {
	        error_message($msg[350], $msg['resa_planning_alert_qty'], 1 );
	        return;
	    }
	    
	    //On vérifie les dates
	    $query="SELECT DATEDIFF('$resa_fin', '$resa_deb') AS diff";
	    
	    $resultatdate=pmb_mysql_query($query);
	    if( pmb_mysql_num_rows($resultatdate) ) {
	        $resdate=pmb_mysql_fetch_object($resultatdate);
	        if($resdate->diff > 0 ) {
	            foreach($location as $resa_loc_retrait=>$resa_qty) {
	                $resa_qty = intval($resa_qty);
	                if($resa_qty) {
	                    $r = new resa_planning();
	                    $r->resa_idempr = static::$id_empr;
	                    $r->resa_idnotice = static::$id_notice;
	                    $r->resa_idbulletin = static::$id_bulletin;
	                    $r->resa_date_debut = $resa_deb;
	                    $r->resa_date_fin = $resa_fin;
	                    $r->resa_qty = $resa_qty;
	                    $r->resa_remaining_qty = $resa_qty;
	                    $r->resa_loc_retrait = $resa_loc_retrait;
	                    $r->save();
	                }
	            }

				// Si le code-barre n'est pas fourni, on le recupere
				if(!isset($empr_cb)) {
					$empr_cb = EmprModel::getBarcode(static::$id_empr);
				}
	            print "<script type='text/javascript'>document.location='./circ.php?categ=pret&form_cb=".rawurlencode(intval($empr_cb))."'</script>";
	            
	        } else {
	            error_message($msg[350], $msg['resa_planning_alert_date'], 1 );
	            return;
	        }
	    }
	}
	
	public static function has_resa_check() {
	    if(!empty(static::$resa_check) && is_countable(static::$resa_check) && count(static::$resa_check)) {
	        return true;
	    }
	    return false;
	}
	
	public static function proceed_val_resa() {
	    global $resa_date_debut, $resa_date_fin;
	    
	    if (static::has_resa_check()) {
	        foreach (static::$resa_check as $id_resa) {
	            //On vérifie les dates
	            if(!empty($resa_date_debut[$id_resa]) && !empty($resa_date_fin[$id_resa])) {
	                $tresa_date_debut = explode('-', $resa_date_debut[$id_resa]);
	                if (strlen($tresa_date_debut[2])==1) $tresa_date_debut[2] = '0'.$tresa_date_debut[2];
	                if (strlen($tresa_date_debut[1])==1) $tresa_date_debut[1] = '0'.$tresa_date_debut[1];
	                $r_date_debut = implode('', $tresa_date_debut);
	                
	                $tresa_date_fin = explode('-', $resa_date_fin[$id_resa]);
	                if (strlen($tresa_date_fin[2])==1) $tresa_date_fin[2] = '0'.$tresa_date_fin[2];
	                if (strlen($tresa_date_fin[1])==1) $tresa_date_fin[1] = '0'.$tresa_date_fin[1];
	                $r_date_fin = implode('', $tresa_date_fin);
	                
	                if ( (checkdate($tresa_date_debut[1], $tresa_date_debut[2], $tresa_date_debut[0]))
	                    && (checkdate($tresa_date_fin[1], $tresa_date_fin[2], $tresa_date_fin[0]))
	                    && (strlen($r_date_debut)==8) && (strlen($r_date_fin)==8)
	                    && ($r_date_debut < $r_date_fin) ) {
	                        $r = new resa_planning($id_resa);
	                        $r->resa_date_debut=implode('-', $tresa_date_debut);
	                        $r->resa_date_fin=implode('-', $tresa_date_fin);
	                        $r->resa_validee='1';
	                        $r->save();
	                        
	                    }
	            }
	        }
	    }
	}
	
	public static function proceed_raz_val_resa() {
	    global $empr_ids, $id_empr;
	    
	    if (static::has_resa_check()) {
	        //Pour la rétro-compatibilité
	        if(empty($empr_ids) && (!empty($id_empr) && is_array($id_empr))) {
	            $empr_ids = $id_empr;
	        }
	        foreach (static::$resa_check as $id_resa) {
	            $rqt_maj = 'update resa_planning set resa_validee=0 where id_resa in ('.$id_resa.')' ;
	            if ($empr_ids[$id_resa]) {
	                $rqt_maj .= ' and resa_idempr='.$empr_ids[$id_resa];
	            }
	            pmb_mysql_query($rqt_maj);
	        }
	    }
	}
	
	public static function proceed_suppr_val_resa() {
	    if (static::has_resa_check()) {
	        foreach (static::$resa_check as $id_resa) {
	            if (resa_planning::exists($id_resa)) {
	                resa_planning::delete($id_resa);
	                
	                //Notification de la suppression
	                $reader = resa_planning::get_reader_to_alert($id_resa);
	                if (!empty($reader)) {
	                    if ($reader['type'] == 'mail') {
	                        resa_planning::send_mail($reader['data'], 'suppr_val_resa');
	                    }
	                }
	            }
	        }
	    }
	}
	
	public static function proceed_conf_resa() {
	    global $pdflettreresa_priorite_email_manuel;
	    
	    $res_envoi = false;
	    if (static::has_resa_check()) {
	        $readers = resa_planning::get_readers_to_alert(static::$resa_check);
	        if (!empty($readers)) {
	            $tmp_id_resa =implode(",",static::$resa_check);
	            foreach ($readers as $reader) {
	                if ($reader['type'] == 'mail') {
	                    $res_envoi = resa_planning::send_mail($reader['data'], 'conf_resa');
	                    if (!$res_envoi || $pdflettreresa_priorite_email_manuel==2) {
	                        $reader['type'] = 'pdf';
	                    }
	                }
	                // Generation du PDF
	                if ($reader['type'] == 'pdf') {
	                    resa_planning::open_pdf($tmp_id_resa);
	                }
	                $rqt_maj = "update resa_planning set resa_confirmee=1 where id_resa in (".$tmp_id_resa.") and resa_validee=1 " ;
	                pmb_mysql_query($rqt_maj);
	            }
	        }
	    }
	}
	
	public static function proceed_raz_conf_resa() {
	    global $empr_ids, $id_empr;
	    
	    if (static::has_resa_check()) {
	        //Pour la rétro-compatibilité
	        if(empty($empr_ids) && (!empty($id_empr) && is_array($id_empr))) {
	            $empr_ids = $id_empr;
	        }
	        foreach (static::$resa_check as $id_resa) {
	            $rqt_maj = 'update resa_planning set resa_confirmee=0 where id_resa in ('.$id_resa.')' ;
	            if ($empr_ids[$id_resa]) {
	                $rqt_maj .= ' and resa_idempr='.$empr_ids[$id_resa];
	            }
	            pmb_mysql_query($rqt_maj);
	            
	            //Notification de l'effacement de la confirmation
	            $reader = resa_planning::get_reader_to_alert($id_resa);
	            if (!empty($reader)) {
	                if ($reader['type'] == 'mail') {
	                    resa_planning::send_mail($reader['data'], 'raz_conf_resa');
	                }
	            }
	        }
	    }
	}
	
	public static function proceed_to_resa() {
	    if (static::has_resa_check()) {
	        foreach(static::$resa_check as $id_resa) {
	            $resa_planning = new resa_planning($id_resa);
	            $resa_planning->to_resa();
	        }
	    }
	}
	
	//Generation entete réservation avec verification numero lecteur
	public static function aff_entete(&$layout_begin='',&$empr_cb=0) {
	    global $charset;
	    
	    if(static::$id_empr) {
	        // récupération nom emprunteur
	        $query = "SELECT empr_nom, empr_prenom, empr_cb FROM empr WHERE id_empr=".static::$id_empr." LIMIT 1";
	        $result = pmb_mysql_query($query);
	        if(pmb_mysql_num_rows($result)) {
	            $o = pmb_mysql_fetch_object($result);
	            $name = $o->empr_prenom;
	            if ($name) {
	                $name .= ' '.$o->empr_nom;
	            } else {
	                $name = $o->empr_nom;
	            }
	            $layout_begin = str_replace('!!nom_lecteur!!', htmlentities($name,ENT_QUOTES,$charset), $layout_begin);
	            $layout_begin = str_replace('!!cb_lecteur!!', htmlentities($o->empr_cb,ENT_QUOTES,$charset), $layout_begin);
	            $empr_cb=$o->empr_cb;
	            return true;
	        }
	    }
	    return false;
	}
	
	public static function check_record() {
	    if(static::$id_notice || static::$id_bulletin) {
	        $query = "SELECT expl_id FROM exemplaires where expl_notice=".static::$id_notice." and expl_bulletin=".static::$id_bulletin." LIMIT 1";
	        $result = pmb_mysql_query($query);
	        if(pmb_mysql_num_rows($result)) {
	            return true;
	        }
	    }
	    return false;
	}
	
	public static function proceed($id=0) {
	    global $msg, $resa_action;
	    global $layout_begin;
	    
	    
	    $id = intval($id);
	    
	    switch($resa_action) {
	        case 'search_resa' : //Recherche pour prévision
	            if (!static::aff_entete($layout_begin)) {
	                error_message($msg[350], $msg[54], 1 , './circ.php');
	                return;
	            }
	            print $layout_begin;
// 	            static::proceed_search_resa();
	            break;
	        case 'add_resa' : //Ajout d'une prévision depuis une recherche catalogue
	            if (!static::aff_entete($layout_begin)) {
	                error_message($msg[350], $msg[54], 1 , './circ.php');
	                return;
	            }
	            print $layout_begin;
	            if(!static::check_record()) {
	                error_message($msg[350], $msg['resa_unknown_record'], 1 , './circ.php?');
	                return;
	            }
	            static::proceed_add_resa();
	            break;
	            
	        case 'add_resa_suite' :	//Enregistrement prévision depuis fiche
	            $empr_cb=0;
	            if(!static::aff_entete($layout_begin,$empr_cb)) {
	                error_message($msg[350], $msg[54], 1 );
	                return;
	            }
	            if(!static::check_record()) {
	                error_message($msg[350], $msg['resa_planning_unknown_record'], 1 );
	                return;
	            }
	            static::proceed_add_resa_suite();
	            break;
	        case 'val_resa':	//Validation réservation depuis liste
	            static::proceed_val_resa();
	            static::redirect_display_list();
	            break;
	        case 'raz_val_resa':
	            static::proceed_raz_val_resa();
	            static::redirect_display_list();
	            break;
	        case 'suppr_resa':	//Suppression réservation depuis liste
	            static::proceed_suppr_val_resa();
	            static::redirect_display_list();
	            break;
	        case 'conf_resa':
	            static::proceed_conf_resa();
	            
	            //La redirection n'est pas possible à cause de la generation des PDF
// 	            static::redirect_display_list();
	            $list_ui_instance = static::get_list_ui_instance();
	            print $list_ui_instance->get_display_list();
	            
	            break;
	        case 'raz_conf_resa':
	            static::proceed_raz_conf_resa();
	            static::redirect_display_list();
	            break;
	        case 'to_resa' :
	            static::proceed_to_resa();
	            static::redirect_display_list();
	            break;
	        default :
	            $list_ui_instance = static::get_list_ui_instance();
	            print $list_ui_instance->get_display_list();
	            break;
	    }
	}
	
	public static function set_resa_check($resa_check) {
	    static::$resa_check = $resa_check;
	}
	
	public static function set_id_empr($id_empr) {
	    static::$id_empr = intval($id_empr);
	}
	
	public static function set_id_notice($id_notice) {
	    static::$id_notice = intval($id_notice);
	}
	
	public static function set_id_bulletin($id_bulletin) {
	    static::$id_bulletin = intval($id_bulletin);
	}
}