<?php
// +-------------------------------------------------+
// | 2002-2011 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: interface_fiches_form.class.php,v 1.1.4.2 2025/12/03 07:33:11 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

global $class_path;
require_once($class_path.'/interface/interface_form.class.php');

class interface_fiches_form extends interface_form {
	
    protected function get_cancel_action() {
        return $this->get_url_base()."&action=view&idfiche=".$this->object_id;
    }
	
    protected function get_display_cancel_action() {
        if (!$this->object_id) {
            return "";
        }
        return parent::get_display_cancel_action();
    }
    
    protected function get_action_save_label() {
        global $msg;
        if (!$this->object_id) {
            return $msg['fiche_save_and_new'];
        }
        return parent::get_action_save_label();
    }
    
	protected function get_submit_action() {
	    if ($this->object_id) {
	        return $this->get_url_base()."&action=update&idfiche=".$this->object_id;
	    } else {
	        return $this->get_url_base()."&action=save_and_new&idfiche=".$this->object_id;
	    }
	}
	
	protected function get_delete_action() {
        return $this->get_url_base()."&action=delete&idfiche=".$this->object_id;
	}
	
	protected function get_js_script() {
	    return "
		<script src='javascript/ajax.js'></script>
		<script type='text/javascript'>
			ajax_parse_dom();
		</script>
		".parent::get_js_script();
	}
	
    public function get_url_base() {
		global $base_path, $current_module, $categ;
		if(empty($this->url_base)) {
		    if ($this->object_id) {
    			$this->url_base = $base_path.'/'.$current_module.'.php?categ=search';
		    } else {
		        $this->url_base = $base_path.'/'.$current_module.'.php?categ=saisie';
		    }
		}
		return $this->url_base;
	}
}