<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: RootSelector.php,v 1.9.4.2 2026/01/28 07:59:52 rtigero Exp $
namespace Pmb\DSI\Models\Selector;

use Pmb\DSI\Models\Root;
use Pmb\DSI\Models\Sort\RootSort;

class RootSelector extends Root
{

	public const IGNORE_PROPS_TOARRAY = [
		"data"
	];

	/**
	 * Chaine de caractere qui contient la recherche a effectuer.
	 * Utilise la methode getSearchInput()
	 *
	 * @var null|string
	 */
	public $searchInput = null;

	protected $sort;

	protected $results = null;

	public function __construct($selectors = null)
	{
		if (! empty($selectors->sort) && class_exists($selectors->sort->namespace)) {
			$namespace = $selectors->sort->namespace;
			$this->sort = new $namespace($selectors->sort->data);
		}
	}

	/**
	 * Cette methode doit etre remplacee dans les sous-classes.
	 * Retourne la recherche effectuer pour l'affichage.
	 *
	 * @return string
	 */
	public function getSearchInput(): string
	{
		return "";
	}

	/**
	 * Cette methode doit etre remplacee dans les sous-classes.
	 * Retourne la recherche effectuer pour l'affichage avec la vue en dtail de chaque elements.
	 *
	 * @return array
	 */
	public function trySearch()
	{
		return [];
	}

	protected function getSelectorQuery($query, $limit = 0)
	{
		$result = $query;
		if (! empty($this->sort)) {
			$count = 0;
			$join = $this->sort->getJoinClause();
			$result = str_ireplace("where", $join . " WHERE", $result, $count);
			if ($count == 0) {
				$result .= " " . $join;
			}
			$result .= " " . $this->sort->getSortQuery();
		}

		if ($limit && ! empty($this->limit)) {
			$limit = $this->limit <= $limit ? $this->limit : $limit;
		}

		if ($limit != 0) {
			$result .= " LIMIT " . intval($limit);
		}
		return $result;
	}

	protected function sortResults($results = array())
	{
		if (! empty($this->sort)) {
			return $this->sort->getSortOther($results);
		}

		return $results;
	}

	/**
	 * Permet de surcharger la limite dans la requte
	 *
	 * @param int $limit
	 */
	public function setLimit($limit = 0)
	{
		$this->limit = intval($limit);
	}

	/**
	 * Construit la requte finale et retourne les rsultats
	 *
	 * @param string $query
	 * @param string $idKey
	 * @return array
	 */
	final protected function getFormatedResults(string $query, string $idKey): array
	{
		if (! is_null($this->results)) {
			return $this->results;
		}

		$this->results = array();

		$fullQuery = $this->getSelectorQuery($query, $this->getMaxLimit());

		$result = pmb_mysql_query($fullQuery);
		if (pmb_mysql_num_rows($result)) {
			while ($row = pmb_mysql_fetch_assoc($result)) {
				$this->results[$row[$idKey]] = $row[$idKey];
			}
		}
		pmb_mysql_free_result($result);

		return $this->results;
	}

	/**
	 * Vrifie si le selector a un tri de type "other"
	 *
	 * @return bool
	 */
	protected function hasSortOther(): bool
	{
		if ($this->sort instanceof RootSort) {
			if ($this->sort->getType() == RootSort::TYPE_OTHER) {
				return true;
			}
		}
		return false;
	}

	protected function getMaxLimit(): int
	{
		if ($this->hasSortOther()) {
			//Si on a un tri de type autre on a besoin de conserver tous les rsultats pour les trier ensuite
			return 0;
		}
		//Sinon on peut limiter la requte pour gagner un peu de perfs et de mmoire
		global $max_diffusion_sending_limit;

		return intval($max_diffusion_sending_limit);
	}
}
