<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: AllSectionSelector.php,v 1.1.4.3 2025/09/17 13:48:48 rtigero Exp $

namespace Pmb\DSI\Models\Selector\Item\Entities\Section\All;

use Pmb\DSI\Models\Selector\SubSelector;

class AllSectionSelector extends SubSelector
{
    // Ne pas enlever le CONSTRUCTEUR !
    public function __construct($selectors = null) {
        parent::__construct($selectors);
    }

    public function getResults(): array
    {
        $query = "SELECT id_section FROM cms_sections";
        return $this->getFormatedResults($query, 'id_section');
    }

    public function getData(): array
    {
        $sections = [];
        foreach ($this->getResults() as $id) {
            $id = intval($id);
            $query = "SELECT section_title FROM cms_sections WHERE id_section = '{$id}'";
            $result = pmb_mysql_query($query);
            if (pmb_mysql_num_rows($result)) {
                $sections[$id] = pmb_mysql_result($result, 0);
            }
        }
        return $this->sortResults($sections);
    }

    /**
     * Retourne la recherche effectuer pour l'affichage.
     *
     * @return string
     */
    public function getSearchInput(): string
    {
        if (isset($this->searchInput)) {
            return $this->searchInput;
        }
        $this->searchInput = "";
        $messages = $this->getMessages();
        if(! empty($messages['search_input'])) {
            $this->searchInput = $messages['search_input'];
        }
        return $this->searchInput;
    }

    /**
     * Retourne la recherche effectuer pour l'affichage avec la vue en dtail de chaque elements.
     *
     * @return array
     */
    public function trySearch()
    {
        $data = $this->getData();
        array_walk($data, function (&$item, $key) {
            $section = new \cms_section($key);
            $item = gen_plus($key, $section->title, $section->get_detail());
        });
        return $data;
    }
}
