<?php

/**
 * Test class for PHPRtfLite_Image.
 * Generated by PHPUnit on 2010-04-26 at 22:17:43.
 */
class PHPRtfLite_ImageTest extends PHPUnit_Framework_TestCase
{
    /**
     * @var PHPRtfLite
     */
    private $_rtf;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp()
    {
        $this->_rtf = new PHPRtfLite();
        $writer = new PHPRtfLite_Writer_String();
        $this->_rtf->setWriter($writer);
    }

    /**
     *
     */
    public function testRenderImageResizedBigger()
    {
        $source = dirname(__FILE__) . '/../../samples/sources/rtf_thumb.jpg';

        if (!is_file($source)) {
            $this->markTestSkipped('Source image file could not be found!');
            return;
        }
        $image = PHPRtfLite_Image::createFromFile($this->_rtf, $source);
        $image->setHeight(5);
        $image->setWidth(5);
        $image->render();
        $expected = self::getRtfThumbHexCode(2835, 2835);

        $this->assertEquals($expected, $this->_rtf->getWriter()->getContent());
    }

    /**
     *
     */
    public function testRenderImageResizedSmallers()
    {
        $source = dirname(__FILE__) . '/../../samples/sources/rtf_thumb.jpg';

        if (!is_file($source)) {
            $this->markTestSkipped('Source image file could not be found!');
            return;
        }
        $image = PHPRtfLite_Image::createFromFile($this->_rtf, $source);
        $image->setHeight(0.1);
        $image->setWidth(0.1);
        $image->render();
        $expected = self::getRtfThumbHexCode(57, 57);

        $this->assertEquals($expected, $this->_rtf->getWriter()->getContent());
    }

    /**
     *
     */
    public function testRenderImageUnresized()
    {
        $source = dirname(__FILE__) . '/../../samples/sources/rtf_thumb.jpg';

        if (!is_file($source)) {
            $this->markTestSkipped('Source image file could not be found!');
            return;
        }
        $image = PHPRtfLite_Image::createFromFile($this->_rtf, $source);
        $image->render();
        $expected = self::getRtfThumbHexCode(510, 510);

        $this->assertEquals($expected, $this->_rtf->getWriter()->getContent());
    }


    /**
     *
     */
    public function testRenderMissingImageFile()
    {
        $image = PHPRtfLite_Image::createFromFile($this->_rtf, '');
        $this->assertTrue($image->isMissing());
    }


    public static function getRtfThumbHexCode($widthInTwips, $heightInTwips)
    {
        return '{\*\shppict {\pict\jpegblip\picscalex100\picscaley100'
             . '\picwgoal' . $widthInTwips . '\pichgoal' . $heightInTwips . ' '
             . 'ffd8ffe000104a46494600010100000100010000ffdb004300090607080706090807080a0a090b0d160f0d0c'
             . '0c0d1b14151016201d2222201d1f1f2428342c242631271f1f2d3d2d3135373a3a3a232b3f443f384334393a'
             . '37ffdb0043010a0a0a0d0c0d1a0f0f1a37251f25373737373737373737373737373737373737373737373737'
             . '3737373737373737373737373737373737373737373737373737ffc000110800220022030122000211010311'
             . '01ffc4001a000003010003000000000000000000000000050604010207ffc400381000020103030201070909'
             . '000000000000010203040511000612132131071522354174b225435155638194b1d1143252616292a1a3e3ff'
             . 'c40017010101010100000000000000000000000000020403ffc4002011010001030305000000000000000000'
             . '0000010311121341811421223151ffda000c03010002110311003f00a16dedb8e49ae269e3a45869ee953431'
             . 'c82db24b142b115c3d44a26511ae1f25b89c05638ed8d425bf76ce76bcb5f5171ae7aaa568e9dd0cf5a43cae'
             . 'b21425c56a8c1e99e4420c13d948d5f557931ac9aead5b0df6148c5caa6bd6192decc1bae579c6e44a39a154'
             . '0a460643303e381116cf26777a9daf070badb520b98a6aee2cac244c23f11dc818c4ad9fe6063dbad94fa5c7'
             . 'cfdf6fbca672d9c6e0dcf73b2dbe867635cd2d5c11ce8659ae11c0caf1abb0493f6c25ca96553e88ef9f0f6d'
             . '1d15c3776ddbf555de3a3acaddaef4a9512c53d7190c51ac6acef1999cbf2525bb783787f0b2a3b8f92abbdc'
             . 'a4ebcf78b5a3241140157b6563458d4fef1efc5013dfc738fa35e8d7d474d8d7685c47ca9ec13c2ccb22b648'
             . '8b07c3be320f8ff8d73ab34a2da7c917dd671cb14b1ac91c8ac8e032b2be4107da346b26def505b3dd22f806'
             . '8d675186a4b6d394da7b7c7538fc974ddba9c7e6c7f5afe5f7eab7509b4f72ed98f6a5921a9dc36d86686df0'
             . '47244d714464608a082398c10720e7be81ff005fedff00ddff005d2bdd3217d9fb8875397c9353dba9cbe6db'
             . 'ed1bf2fbf5a9b73ed3c1e3ba2d60e3b13755233fdfa4bbaf726df7da77d862dcb6a9e59adb5091c51d6ab333'
             . '18d8000176c927b600cf7d0586def505b3dd22f8068d1b7bd416cf748be01a340c34be6b5dbaa6a5e5a9a0a5'
             . '9a46232f242ac4fa3f491a34683af98ed1f5550fe193f4d1e63b47d5543f864fd3468d06d8228d208d123455'
             . '550028500018f0d1a34683ffd9}}';
    }
}