<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: selector_searcher_abt.class.php,v 1.1.2.5 2025/11/28 15:59:14 dbellamy Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

//Classe de recherche pour selecteurs
global $class_path;
require_once("$class_path/sel_searcher.class.php");

class selector_searcher_abt extends sel_searcher {

	public $cur_typ_query='abt';
	public $has_filters = true;

	public function make_first_search() {

		global $msg;
		global $elt_query;
		global $location_query, $date_ech_query;
		global $results_show_all;
		global $specific_order;

		$restrict = "1 ";
		if ($location_query!='-1') {
			$restrict.= "and location_id='".$location_query."' ";
		}
		$restrict.= "and notice_id=num_notice ";

		if ($date_ech_query!='-1') {
			$restrict.= "and date_fin < '".$date_ech_query."' ";
		}

		$suite_rqt="or code='".$elt_query."' ";

		$issn_verif=traite_code_ISSN(stripslashes($elt_query));
		if (isISSN(stripslashes($elt_query))) {
			$suite_rqt.=" or code='".$issn_verif."' ";
			$q_count = "select count(abt_id) from notices, abts_abts where ".$restrict." and (0 ".$suite_rqt.")";
			$r_count = pmb_mysql_query($q_count);
			$n_count = pmb_mysql_result($r_count,0,0);
			$this->nbresults = $n_count;

			if ((!$specific_order) || ($specific_order==1)) {
				$order_by = " ORDER BY 1,3";
			} elseif($specific_order==2){
				$order_by = " ORDER BY 1 DESC,3 DESC";
			} elseif ($specific_order == 3) {
				$order_by = " ORDER BY date_fin";
			} elseif ($specific_order == 4) {
				$order_by = " ORDER BY date_fin DESC";
			}

			$q_list = "select tit1, abt_id, abt_name from notices, abts_abts where ".$restrict." and (0 ".$suite_rqt.")".$order_by;
			if(!$results_show_all){
			    $q_list .= $this->get_query_limit();
			}
			$r_list = pmb_mysql_query($q_list);
			$this->t_query=$r_list;
			if(!$results_show_all){
			    $this->nbepage=ceil($this->nbresults/$this->get_nb_per_page());
			}else{
				$this->nbepage=1;
			}

		}else{
			$aq=new analyse_query(stripslashes($elt_query));
			if ($aq->error) {
				$this->show_form();
				error_message($msg["searcher_syntax_error"],sprintf($msg["searcher_syntax_error_desc"],$aq->current_car,$aq->input_html,$aq->error_message));
				return ;
			} else {
				$q_members = $aq->get_query_members("notices","index_wew","index_sew","abt_id");
				$q_count = "select count(abt_id) from notices, abts_abts where ".$restrict." and (".$q_members["where"]." ".$suite_rqt.")";
				$r_count = pmb_mysql_query($q_count);
				$n_count = pmb_mysql_result($r_count,0,0);
				$this->nbresults = $n_count;

				$q_list = "select abt_id, ".$q_members['select']." as pert from notices, abts_abts where ".$restrict." and (".$q_members["where"]." ".$suite_rqt.") ".$q_members['post'];
				//Comportement d'origine
				if (!$specific_order) {
					//On filtre sur la pertinence
					if(!$results_show_all){
					    $q_list.= $this->get_query_limit();
					}
					//on surcharge la requte d'origine pour ajouter trier sur titre de priodique
					$new_q_list="
							SELECT tit1, a.abt_id, a.abt_name, pert
							FROM notices n, abts_abts a, (".$q_list.") as q
							WHERE q.abt_id=a.abt_id AND a.num_notice=n.notice_id
							ORDER BY 1 ASC,3 DESC";
				} elseif ($specific_order==1) { //Tri notice/abo croissant sans pertinence
					$q_list = "select abt_id, ".$q_members['select']." as pert from notices, abts_abts where ".$restrict." and (".$q_members["where"]." ".$suite_rqt.") ".$q_members['post'];
					//on surcharge la requte d'origine pour ajouter trier sur titre de priodique
					$new_q_list="
							SELECT tit1, a.abt_id, a.abt_name, pert
							FROM notices n, abts_abts a, (".$q_list.") as q
							WHERE q.abt_id=a.abt_id AND a.num_notice=n.notice_id
							ORDER BY 1 ASC,3 DESC";
					if(!$results_show_all){
					    $new_q_list.= $this->get_query_limit();
					}
				} elseif ($specific_order==2) { //Tri notice/abo dcroissant sans pertinence
					$new_q_list="
							SELECT tit1, a.abt_id, a.abt_name, pert
							FROM notices n, abts_abts a, (".$q_list.") as q
							WHERE q.abt_id=a.abt_id AND a.num_notice=n.notice_id
							ORDER BY 1 DESC,3 ASC";
					if(!$results_show_all){
					    $new_q_list.= $this->get_query_limit();
					}
				} elseif ($specific_order == 3) { //Date chance croissante
					$new_q_list="
							SELECT tit1, a.abt_id, a.abt_name, pert
							FROM notices n, abts_abts a, (".$q_list.") as q
							WHERE q.abt_id=a.abt_id AND a.num_notice=n.notice_id
							ORDER BY a.date_fin";
					if(!$results_show_all){
					    $new_q_list.= $this->get_query_limit();
					}
				} elseif ($specific_order == 4) { //Date chance dcroissante
					$new_q_list="
							SELECT tit1, a.abt_id, a.abt_name, pert
							FROM notices n, abts_abts a, (".$q_list.") as q
							WHERE q.abt_id=a.abt_id AND a.num_notice=n.notice_id
							ORDER BY a.date_fin DESC";
					if(!$results_show_all){
					    $new_q_list.= $this->get_query_limit();
					}
				}
				$r_list = pmb_mysql_query($new_q_list);
				$this->t_query=$r_list;
				if(!$results_show_all){
				    $this->nbepage=ceil($this->nbresults/$this->get_nb_per_page());
				}else{
					$this->nbepage=1;
				}
			}
		}
		return ELT_LIST;
	}

	public function store_search() {

		global $elt_query;
		global $location_query, $date_ech_query;
		global $charset;
		global $specific_order;

		if (!isset($location_query)) $location_query = '';
		if (!isset($date_ech_query)) $date_ech_query = '';
		if (!isset($specific_order)) $specific_order = '';
		$champs="<input type='hidden' name='elt_query' value='".htmlentities(stripslashes($elt_query),ENT_QUOTES,$charset)."'/>";
		$champs.="<input type='hidden' name='location_query' value='".htmlentities(stripslashes($location_query),ENT_QUOTES,$charset)."'/>";
		$champs.="<input type='hidden' name='date_ech_query' value='".htmlentities(stripslashes($date_ech_query),ENT_QUOTES,$charset)."'/>";
		$champs.="<input type='hidden' name='specific_order' value='".htmlentities(stripslashes($specific_order),ENT_QUOTES,$charset)."'/>";
		$this->store_form=str_replace("!!first_search_variables!!",$champs,$this->store_form);
		print $this->store_form;
	}

	public function get_title_elt_list() {
	    global $msg;

	    return $msg['selector_lib_abt'];
	}

	public function get_display_sort_elt_list() {
	    global $msg, $charset;
	    global $specific_order;
	    global $pmb_serialcirc_active;

	    $display = "<div class='row' style='margin-left:5px;'>";
	    if ($specific_order==1) {
	        $specific_order_new = 2;
	    } else {
	        $specific_order_new = 1;
	    }
	    $display .= "<div class='colonne80'>
						<div class='notice-parent'>
							<b><a href='javascript:specific_order(".$specific_order_new.")'>".htmlentities($msg['selector_lib_abt'],ENT_QUOTES,$charset)."</a></b>
						</div>
				   </div>";
	    if ($specific_order==3) {
	        $specific_order_new = 4;
	    } else {
	        $specific_order_new = 3;
	    }
	    $display .= "<div class='colonne10'>
						<div class='notice-parent'>
							<b><a href='javascript:specific_order(".$specific_order_new.")'>".htmlentities($msg['acquisition_abt_ech'],ENT_QUOTES,$charset)."</a></b>
						</div>
					</div>";
	    if($pmb_serialcirc_active) {
	        $display .= "<div class='colonne10'>
    						<div class='notice-parent'>
    							<b>".htmlentities($msg['acquisition_nb_recipients'],ENT_QUOTES,$charset)."</b>
    						</div>
    					</div>";
	    } else {
	        $display .= "<div class='colonne10'>&nbsp;</div>";
	    }
	    $display .= "</div>";
	    $display .= $this->back_script_order;
	    return $display;
	}

	public function get_instance_sel_display($row) {
	    return new selector_display_abt($row->abt_id, $this->base_url,'sel_searcher_select_');
	}

	/**
	 * extension de la recherche
	 * {@inheritDoc}
	 * @see sel_searcher::get_extended_search_form()
	 */
	public function get_extended_search_form() {
	    global $msg;
	    global $location_query, $deflt_bulletinage_location;
	    global $date_ech_query, $pmb_abt_end_delay;
	    global $specific_order;

	    //localisation
	    $q ="select distinct idlocation, location_libelle from docs_location, docsloc_section where num_location=idlocation order by 2 " ;
	    if (!isset($location_query) || !$location_query) {
	        $location_query=$deflt_bulletinage_location;
	    }
	    $location_form = gen_liste($q, "idlocation", "location_libelle", 'location_query', "", $location_query, "", "", '-1', $msg['all_location'] , 0);
	    $extended_search_form = $this->get_extended_search_filter_form('location_query', $msg['localisation_sort'], $location_form);
	    //echeance
	    if (isset($date_ech_query) && $date_ech_query=='-1') {
	        $date_ech_query_lib=$msg['parperso_nodate'];
	    } elseif (empty($date_ech_query)) {
	        $q = "select date_add(curdate(), interval ".$pmb_abt_end_delay." day) ";
	        $r = pmb_mysql_query($q);
	        $date_ech_query=pmb_mysql_result($r, 0, 0);
	        $date_ech_query_lib=format_date($date_ech_query);
	    } else {
	        $date_ech_query_lib=format_date($date_ech_query);
	    }

	    $date_ech_form = "&lt;<input type='hidden' id='date_ech_query' name='date_ech_query' value='".$date_ech_query."' />
			<input type='button' id='date_ech_query_lib' class='bouton_small' value='".$date_ech_query_lib."' onclick=\"var date_c='';if (this.form.elements['date_ech_query'].value!='-1') date_c=this.form.elements['date_ech_query'].value; openPopUp('./select.php?what=calendrier&caller='+this.form.name+'&date_caller='+date_c+'&param1=date_ech_query&param2=date_ech_query_lib&auto_submit=NO&date_anterieure=YES', 'calendar')\" />
			<input type='button' class='bouton_small' style='width:25px;' value='".$msg['raz']."' onclick=\"this.form.elements['date_ech_query_lib'].value='".$msg['parperso_nodate']."'; this.form.elements['date_ech_query'].value='-1';\" />";
	    $extended_search_form .= $this->get_extended_search_filter_form('date_ech_query_lib', $msg['acquisition_abt_ech'], $date_ech_form);
	    if (empty($specific_order)) {
	        $specific_order = 0;
	    }
	    $extended_search_form .= "<input type='hidden' name='specific_order' id='specific_order' value='".$specific_order."'/>";
	    $extended_search_form .= parent::get_extended_search_form();
	    return $extended_search_form;
	}
}
