<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: selector_display_record_serial.class.php,v 1.1.2.3 2025/11/05 15:17:33 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

// dfinition de la classe d'affichage des priodiques en liste pour selecteur
class selector_display_record_serial extends selector_display_record {

	public $level = 1;					// niveau d'affichage
	public $nb_bull = 0;				// nombre de bulletins
	public $nb_art = 0;				// nombre d'articles
	public $show_statut = 1;
	public $aff_statut = '' ; 			// carr de couleur pour signaler le statut de la notice

	// creation header
	public function doHeader() {
		global $charset;

		if ($this->notice->statut) {
			$rqt_st = "SELECT class_html , gestion_libelle FROM notice_statut WHERE id_notice_statut='".$this->notice->statut."' ";
			$res_st = pmb_mysql_query($rqt_st);
			$class_html = " class='".pmb_mysql_result($res_st, 0, 0)."' ";
			$txt = pmb_mysql_result($res_st, 0, 1);
		} else {
			$class_html = " class='statutnot1' " ;
			$txt = '' ;
		}
		if ($this->notice->commentaire_gestion) {
		    if ($txt) {
		        $txt .= ":\r\n".$this->notice->commentaire_gestion;
		    } else {
		        $txt = $this->notice->commentaire_gestion;
		    }
		}
		if ($txt) {
			$statut = "<small><span $class_html style='margin-right: 3px;'><a href=# onmouseover=\"z=document.getElementById('zoom_statut".$this->notice_id."'); z.style.display=''; \" onmouseout=\"z=document.getElementById('zoom_statut".$this->notice_id."'); z.style.display='none'; \"><img src='".get_url_icon('spacer.gif')."' width='10' height='10' /></a></span></small>";
			$statut .= "<div id='zoom_statut".$this->notice_id."' style='border: solid 2px #555555; background-color: #FFFFFF; position: absolute; display:none; z-index: 2000;'><b>".nl2br(htmlentities($txt,ENT_QUOTES, $charset))."</b></div>" ;
		} else {
		    $statut = "<small><span $class_html style='margin-right: 3px;'><img src='".get_url_icon('spacer.gif')."' width='10' height='10' /></span></small>";
		}
		$this->aff_statut = $statut;

		$this->header = htmlentities($this->notice->tit1,ENT_QUOTES, $charset);

		//$this->responsabilites
		$aut1_libelle = array() ;
		$lib_auteur='';
		$as = array_search ("0", $this->responsabilites["responsabilites"]);
		if ($as!== FALSE && $as!== NULL) {
			$auteur_0 = $this->responsabilites["auteurs"][$as] ;
			$auteur = new auteur($auteur_0["id"]);
			if ($auteur->get_isbd()) {
				$lib_auteur=$auteur->get_isbd();
			}
		} else {
			$as = array_keys ($this->responsabilites["responsabilites"], "1" );
			for ($i = 0 ; $i < count($as) ; $i++) {
				$indice = $as[$i] ;
				$auteur_1 = $this->responsabilites["auteurs"][$indice];
				$auteur = new auteur($auteur_1["id"]);
				$aut1_libelle[]= $auteur->get_isbd();
			}
			$auteurs_liste = implode ("; ",$aut1_libelle) ;
			if ($auteurs_liste) {
				$this->header .= ' / '. $auteurs_liste;
				$lib_auteur=$auteurs_liste;
			}
		}
		if ($lib_auteur!='') {
			$this->header .= ' / '. $lib_auteur;
		}

		if ($this->action) {
			$this->header = str_replace('!!display!!', $this->header, $this->action);
			$this->header = str_replace('!!aut_id!!', $this->notice_id, $this->header);
		}

		if ($this->show_statut) {
			$this->header = $this->aff_statut.$this->header ;
		}
	}

	// creation contenu
	public function doContent() {
		global $msg;
		global $fonction_auteur;
		global $pmb_etat_collections_localise, $pmb_droits_explr_localises, $explr_visible_mod;

		$this->isbd = $this->notice->tit1;

		// constitution de la mention de titre
		$tit3 = $this->notice->tit3;
		$tit4 = $this->notice->tit4;
		if($tit3) $this->isbd .= "&nbsp;= $tit3";
		if($tit4) $this->isbd .= "&nbsp;: $tit4";

		// constitution de la mention de responsabilit
		//$this->responsabilites
		$mention_resp = array() ;
		$as = array_search ("0", $this->responsabilites["responsabilites"]);
		if ($as!== FALSE && $as!== NULL) {
			$auteur_0 = $this->responsabilites["auteurs"][$as] ;
			$auteur = new auteur($auteur_0["id"]);
			$mention_resp_lib = $auteur->get_isbd();
			if ($auteur_0["fonction"]) {
				$mention_resp_lib .= ", ".$fonction_auteur[$auteur_0["fonction"]];
			}
			$mention_resp[] = $mention_resp_lib ;
		}
		$as = array_keys ($this->responsabilites["responsabilites"], "1" );
		for ($i = 0 ; $i < count($as) ; $i++) {
			$indice = $as[$i] ;
			$auteur_1 = $this->responsabilites["auteurs"][$indice] ;
			$auteur = new auteur($auteur_1["id"]);
			$mention_resp_lib = $auteur->get_isbd();
			if ($auteur_1["fonction"]) {
				$mention_resp_lib .= ", ".$fonction_auteur[$auteur_1["fonction"]];
			}
			$mention_resp[] = $mention_resp_lib ;
		}
		$as = array_keys ($this->responsabilites["responsabilites"], "2" ) ;
		for ($i = 0 ; $i < count($as) ; $i++) {
			$indice = $as[$i] ;
			$auteur_2 = $this->responsabilites["auteurs"][$indice] ;
			$auteur = new auteur($auteur_2["id"]);
			$mention_resp_lib = $auteur->get_isbd();
			if ($auteur_2["fonction"]) {
				$mention_resp_lib .= ", ".$fonction_auteur[$auteur_2["fonction"]];
			}
			$mention_resp[] = $mention_resp_lib ;
		}
		$libelle_mention_resp = implode ("; ",$mention_resp) ;
		if($libelle_mention_resp) {
			$this->isbd .= "&nbsp;/ ". $libelle_mention_resp ." ";
		}

		// zone de l'adresse
		$editeurs = '';
		if($this->notice->ed1_id) {
			$editeur = new editeur($this->notice->ed1_id);
			$editeurs .= $editeur->get_isbd();
		}
		if($this->notice->ed2_id) {
			$editeur = new editeur($this->notice->ed2_id);
			$ed_isbd=$editeur->get_isbd();
			if (!empty($editeurs)) {
				$editeurs .= '&nbsp;; '.$ed_isbd;
			} else {
				$editeurs = $ed_isbd;
			}
		}
		if($this->notice->year) {
		    if (!empty($editeurs)) {
		        $editeurs .= ', '.$this->notice->year;
		    } else {
		        $editeurs = $this->notice->year;
		    }
		}
		if (!empty($editeurs)) {
			$this->isbd .= ".&nbsp;-&nbsp;$editeurs";
		}

		//code (ISSN,...)
		if ($this->notice->code) $this->isbd .="<br /><b>{$msg[165]}</b>&nbsp;: ".$this->notice->code;

		//Indexation dcimale
		if($this->notice->indexint) {
			$indexint = new indexint($this->notice->indexint);
			$indexint_isbd=$indexint->display;
			$this->isbd .= "<br /><b>".$msg['indexint_catal_title']."</b>&nbsp;: ".$indexint_isbd;
		}

		// Si notice-mre alors on compte le nombre de numros (bulletins)
		if($this->notice->niveau_biblio=="s") {
			$requete = "SELECT * FROM bulletins WHERE bulletin_notice=".$this->notice_id;
			$Query = pmb_mysql_query($requete);
			$this->nb_bull=pmb_mysql_num_rows($Query);
			while (($row = pmb_mysql_fetch_array($Query))) {
				$requete2 = "SELECT count( * )  AS nb_art FROM  analysis WHERE analysis_bulletin =".$row['bulletin_id'];
				$Query2 = pmb_mysql_query($requete2);
				$analysis_array=pmb_mysql_fetch_array($Query2);
				$this->nb_art+=$analysis_array['nb_art'];
				$requete3 = "SELECT count( expL_id ) AS nb_expl FROM  exemplaires WHERE expl_bulletin =".$row['bulletin_id'];
				$Query3 = pmb_mysql_query($requete3);
				$expl_array=pmb_mysql_fetch_array($Query3);
				$this->nb_expl+=$expl_array['nb_expl'];
			}

			// Cas gnral : au moins un bulletin
			if (pmb_mysql_num_rows($Query)>0)
				{$this->isbd .="<br /><br />\n
				<b>".$msg["serial_bulletinage_etat"]."</b>
				<table style='border:0px' class='expl-list' role='presentation'>
				    <tr>
                        <td>
                            <strong>$this->nb_bull</strong> ".$msg["serial_nb_bulletin"]."
            				<strong>$this->nb_expl</strong> ".$msg["bulletin_nb_ex"]."
            				<strong>$this->nb_art</strong> ".$msg["serial_nb_articles"]."
				        </td>
				    </tr>
                </table>";
			} else { // 0 bulletin
				$this->isbd .="<br /><br />\n
				<b>".$msg["serial_bulletinage_etat"]."</b>
				<table style='border:0px' class='expl-list' role='presentation'>
    				<tr>
                        <td>
                            <strong>$this->nb_bull</strong>
            				".$msg["serial_nb_bulletin"]." : <strong>".$msg["bull_no_expl"]."</strong>
                        </td>
    				</tr>
                </table>";
			}

			//tat des collections
			if ($pmb_etat_collections_localise&&$pmb_droits_explr_localises&&$explr_visible_mod) {
				$restrict_location=" and location_id in (".$explr_visible_mod.") and idlocation=location_id";
				$table_location=",docs_location";
				$select_location=",location_libelle";
			} else {
				$restrict_location = " group by id_serial";
				$select_location = "";
				$table_location = "";
			}
			$rqt="select state_collections$select_location from collections_state$table_location where id_serial=".$this->notice_id.$restrict_location;
			$execute_query=pmb_mysql_query($rqt);
			if ($execute_query) {
				if (pmb_mysql_num_rows($execute_query)) {
					$bool = false;
					$affichage = "<br /><strong>".$msg["4001"]."</strong><br />";
					while ($r = pmb_mysql_fetch_object($execute_query)) {
						if (!empty($r->state_collections)) {
						    if (!empty($r->location_libelle)) {
						        $affichage .= "<strong>".$r->location_libelle."</strong> : ";
						    }
							$affichage .= $r->state_collections."<br />\n";
							$bool = true;
						}
					}
					if ($bool == true) {
					    $this->isbd .= $affichage;
					}
				}
			}
		}
		return;
	}

	// finalisation du rsultat
	public function finalize() {
		global $msg, $charset;

		$javascript_template ="
						<div id='el_!!id!!_Parent' class='notice-parent'>
                            ".get_expandBase_button('el_!!id!!_')."
							<span class='notice-heada'>!!header!!</span>
							<div id='el_!!id!!_Child' class='notice-child' style='width:inherit;display:none;' >
	   					 		!!serial_type!! !!isbd!!
							</div>
						</div>";
		$this->result = str_replace('!!id!!', $this->notice_id, $javascript_template);
		$this->result = str_replace('!!header!!', $this->header, $this->result);
		
		$this->result = str_replace('!!isbd!!', $this->isbd, $this->result);
		$this->result = str_replace('!!serial_type!!', "<span class='fond-mere'>[".$msg['isbd_type_perio']."]</span>", $this->result);
		
		if ($this->action) {
		    if (count($this->action_values)) {
		        foreach($this->action_values as $v) {
		            $this->header = str_replace("!!$v!!", htmlentities(addslashes($this->$v),ENT_QUOTES,$charset), $this->header);
		        }
		    }
		}
	}

}