<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: selector_display_abt.class.php,v 1.1.2.3 2025/11/05 15:17:33 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

//dfinition de la classe d'affichage des abonnements en liste pour selecteur
class selector_display_abt extends selector_display {

	public $abt_id=0;					//id abonnement
	public $abt;					//objet abonnement
	public $aff_date_echeance = '';	//date echeance abt actuel
	public $aff_nb_recipients = 0;	//nombre de destinataires abt actuel

	public $typ_lig = 4; //type de ligne
	public $titre = '';				//titre renvoye
	public $editeur1 = '';				//editeur 1 renvoye
	public $periodicite = '';			//periodicite
	public $duree = '';				//duree abt
	public $aff_date_debut = '';		//date debut abt renvoyee
	public $abt_name = '';		//nom abonnement renvoyee

//TODO
	public $nb_num = 0;				//nb numeros

	//constructeur
	public function __construct($id, $base_url, $form_checker='') {
	    parent::__construct($id, $base_url, $form_checker);
	    $this->abt_id=intval($id);
	}
	
	public function get_notice_id() {
	    return $this->abt->num_notice;
	}

	// rcupration des valeurs en table
	public function getData() {
		$q = "SELECT abts_abts.*, ";
		$q.= "notices.tit1, notices.tit3, notices.tit4, notices.ed1_id, notices.ed2_id, notices.year, notices.code, notices.prix, ";
		$q.= "abts_modeles.num_periodicite, abts_periodicites.libelle, ";
		$q.= "docs_location.location_libelle ";
		$q.= "FROM abts_abts ";
		$q.= "join abts_abts_modeles on abts_abts.abt_id=abts_abts_modeles.abt_id ";
		$q.= "join abts_modeles on abts_abts_modeles.modele_id=abts_modeles.modele_id ";
		$q.= "left join abts_periodicites on abts_modeles.num_periodicite=abts_periodicites.periodicite_id ";
		$q.= "join notices on abts_abts.num_notice=notices.notice_id ";
		$q.= "join docs_location on abts_abts.location_id=docs_location.idlocation ";
		$q.= "where abts_abts.abt_id='".$this->abt_id."' ";
		$r = pmb_mysql_query($q);
		$this->abt = pmb_mysql_fetch_object($r);
	}

	// creation header
	public function doHeader() {
		global $msg, $charset;
		global $pmb_serialcirc_active;

		//aff. nom prio
		$this->header = htmlentities($this->abt->tit1, ENT_QUOTES, $charset);

		//aff. nom abonnement
		$this->header.= "&nbsp;/&nbsp;".htmlentities($this->abt->abt_name, ENT_QUOTES, $charset);

		//aff. localisation
		$this->header.= "&nbsp;/&nbsp;".htmlentities($this->abt->location_libelle, ENT_QUOTES, $charset);

		//aff. periodicite
		if ($this->abt->num_periodicite) {
			$this->header.= "&nbsp;(".htmlentities($this->abt->libelle, ENT_QUOTES, $charset);
		} else {
			$this->header.= "&nbsp;(".htmlentities($msg['abonnements_periodicite_manuel'], ENT_QUOTES, $charset);
		}

		//aff. duree
		$this->header.= "&nbsp;-&nbsp;".$this->abt->duree_abonnement."&nbsp;".htmlentities($msg['abonnements_periodicite_unite_mois'], ENT_QUOTES, $charset).")";

		//aff. date echeance
		$this->aff_date_echeance = format_date($this->abt->date_fin);

		//aff. nb destinataire
		if($pmb_serialcirc_active) {
		    $serialcirc_diff=new serialcirc_diff(0,$this->abt_id);
		    $this->aff_nb_recipients = $serialcirc_diff->diffusion_nb_recipients;
		}

		//renv. nom abonnement
		$this->abt_name.= $this->abt->abt_name;

		//renv. code
		$this->code=$this->abt->code;

		//renv. titre
		$this->titre = $this->abt->tit1;
		if ($this->abt->tit3) $this->titre.= "&nbsp;= ".$this->abt->tit3;
		if ($this->abt->tit4) $this->titre.= "&nbsp;: ".$this->abt->tit4;

		//renv. editeur1
		if ($this->abt->ed1_id) {
			$editeur = new editeur($this->abt->ed1_id);
			$this->editeur1 = $editeur->get_isbd();
		}

		//renv. periodicite
		if ($this->abt->num_periodicite) {
			$this->periodicite=$this->abt->libelle;
		}

		//renv. duree
		$this->duree = $this->abt->duree_abonnement;

		//renv. date debut abt
		$q = "select date_add('".$this->abt->date_fin."', interval 1 day) as date_debut, ";
		$q.= " date_add('".$this->abt->date_fin."', interval ".$this->duree." month) as date_fin ";
		$r = pmb_mysql_query($q);
		$obj = pmb_mysql_fetch_object($r);
		$this->aff_date_debut = format_date($obj->date_debut);

//TODO A revoir, car le prix n'est pas accessible sur les notices de perio
		//renv. prix
		if ($this->abt->prix!=='') $this->prix=$this->abt->prix;
	}

	// creation contenu
	public function doContent() {
		global $fonction_auteur, $msg;

		//mention titre
		$this->isbd = $this->titre;

		//mention responsabilit
		$mention_resp = array() ;
		$as = array_search ("0", $this->responsabilites["responsabilites"]);
		if ($as!== FALSE && $as!== NULL) {
			$auteur_0 = $this->responsabilites["auteurs"][$as] ;
			$auteur = new auteur($auteur_0["id"]);
			$mention_resp_lib = $auteur->get_isbd();
			if ($auteur_0["fonction"]) {
				$mention_resp_lib .= ", ".$fonction_auteur[$auteur_0["fonction"]];
			}
			$mention_resp[] = $mention_resp_lib ;
		}
		$as = array_keys ($this->responsabilites["responsabilites"], "1" );
		for ($i = 0 ; $i < count($as) ; $i++) {
			$indice = $as[$i] ;
			$auteur_1 = $this->responsabilites["auteurs"][$indice] ;
			$auteur = new auteur($auteur_1["id"]);
			$mention_resp_lib = $auteur->get_isbd();
			if ($auteur_1["fonction"]) {
				$mention_resp_lib .= ", ".$fonction_auteur[$auteur_1["fonction"]];
			}
			$mention_resp[] = $mention_resp_lib ;
		}
		$as = array_keys ($this->responsabilites["responsabilites"], "2" ) ;
		for ($i = 0 ; $i < count($as) ; $i++) {
			$indice = $as[$i] ;
			$auteur_2 = $this->responsabilites["auteurs"][$indice] ;
			$auteur = new auteur($auteur_2["id"]);
			$mention_resp_lib = $auteur->get_isbd();
			if ($auteur_2["fonction"]) {
				$mention_resp_lib .= ", ".$fonction_auteur[$auteur_2["fonction"]];
			}
			$mention_resp[] = $mention_resp_lib ;
		}
		$libelle_mention_resp = implode ("; ",$mention_resp) ;
		if($libelle_mention_resp) {
			$this->isbd .= "&nbsp;/ ". $libelle_mention_resp ." " ;
		}

		// zone de l'adresse
		$ed_isbd = '';
		if($this->abt->ed1_id) {
			$editeur = new editeur($this->abt->ed1_id);
			$ed_isbd .= $editeur->get_isbd();
		}
		if($this->abt->year) {
		    if ($ed_isbd) {
		        $ed_isbd .= ', '.$this->abt->year;
		    } else {
		        $ed_isbd = $this->abt->year;
		    }
		}
		if($ed_isbd) {
			$this->isbd .= ".&nbsp;-&nbsp;$ed_isbd";
		}

		//code (ISSN,...)
		if ($this->abt->code) {
		    $this->isbd .="<br /><b>{$msg[165]}</b>&nbsp;: ".$this->abt->code;
		}
	}

	//gnration du template javascript
	public function finalize() {
		global $msg;

		$javascript_template ="
			<div id='el_!!id!!_Parent' class='notice-parent'><span class='acq_sel_display_middle'>";
		if(trim($this->form_checker)){
		    $javascript_template.=$this->getCheckbox();
		}
		$javascript_template.="
				<img src='".get_url_icon('plus.gif')."' name='imEx' id='el_!!id!!_Img' title='".$msg['admin_param_detail']."' onClick=\"expandBase('el_!!id!!_', true); return false;\" />
				</span><span class='notice-heada'>!!header!!</span>
				<div id='el_!!id!!_Child' class='notice-child' style='width:inherit;display:none;' >
   			 		!!serial_type!! !!isbd!!
				</div>
			</div>";

		if ($this->action) {
		    $this->finalizeHeaderFromAction();
		}

		$this->result = str_replace('!!id!!', $this->abt_id, $javascript_template);
		$this->result = str_replace('!!header!!', $this->header, $this->result);

		$this->result = str_replace('!!isbd!!', $this->isbd, $this->result);
		$this->result = str_replace('!!serial_type!!', "<span class='fond-mere'>[".$msg['isbd_type_perio']."]</span>", $this->result);
	}
	
	public function getNomActe() {
	    global $msg;
	    global $acquisition_show_abt_in_cmde;
	    
	    // addslashes ??
	    $nom_acte = $msg['pointage_label_abonnement']." ".$this->duree." ".$msg['abonnements_periodicite_unite_mois'];
	    $nom_acte .= "<br />".$msg['abonnements_date_debut']." : ".$this->aff_date_debut;
	    $nom_acte .= "<br />".$this->titre;
	    if ($this->editeur1 != '') {
	        $nom_acte .= "<br />".$this->editeur1;
	    }
	    if ($acquisition_show_abt_in_cmde) {
            $nom_acte .= "<br />".$this->abt_name;
	    }
	    return $nom_acte;
	}
}
