// +-------------------------------------------------+
// � 2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: OcrInfos.js,v 1.1.2.1 2025/10/21 08:22:46 qvarin Exp $


define(["dojo/_base/declare", "dojo/dom-construct"], function(declare, domConstruct) {
	return declare(null, {
		allowLoop: false,
		interval: false,
		inCall: false,
		constructor: function() {
			if (!document.getElementById('ocr_infos')) {
				return;
			}

			if (this.allowLoop) {
				window.addEventListener('blur', this.disableCall.bind(this));
				window.addEventListener('focus', this.initCall.bind(this));
				this.initCall();
			} else {
				this.call();
			}
		},
		call: async function() {
			if (false === this.inCall) {
				this.inCall = true;

				try {
					const response = await fetch('./ajax.php?module=ajax&categ=ocr&sub=get_infos');
					const data = await response.json();
					this.updateContainer(data);
				} catch (_) {}
				this.inCall = false;
			} else {
				this.disableCall();
				this.initCall();
			}
		},
		initCall: function() {
			if (false === this.interval && window.document.hasFocus()) {
				this.interval = setInterval(this.call.bind(this), 30000);
			}
		},
		disableCall: function() {
			if (this.interval) {
				clearInterval(this.interval);
				this.interval = false;
			}
		},
		updateContainer: function(data) {
			const container = document.getElementById('ocr_infos');
			if (container) {
				domConstruct.empty(container);

				if (data.state) {
					domConstruct.create('p', {
						'class': 'indexation_title',
						innerHTML: data.state
					}, container);
				}
			}
		}
	});
});